slim update-installation - perform a sequence of update actions on an installation graph
========================================================================================

## SYNOPSIS

`slim` `update-installation` \[(`-h`|`--help`)] \[(`-a`|`--actions=`)&lt;action> \[&lt;action>...]] \[(`-i`|`--installation=`)&lt;filename>]
\[(`-o`|`--output-dir=`)&lt;output-dir>] \[(`-r`|`--repository=`)&lt;repository>] \[`--disable-automatic-resolution`]
\[(`-c`|`combine-search-head-indexer-workloads`)]
\[(`-d`|`--deployment-packages=)`&lt;specification> \[&lt;specification>...]]
\[(`-f`|`--forwarder-workloads=`&lt;forwarder-workloads>]
\[(`-t`|`--target-os=`)&lt;os-name>] (`-p`|`--package=`)&lt;app-source>

## DESCRIPTION

Performs a sequence of update actions on the app installation graph for a Splunk system.

## OPTIONS

`-h`, `--help`  
Print help message and exit.

`-a` &lt;action> \[&lt;action>...], `--actions` &lt;action> \[&lt;action>...]  
Apply actions to the given installation graph: `add`, `remove`, `set`, or `update`.

`--disable-automatic-resolution`
Do not automatically resolve dependency conflicts by updating installed versions.

`-i` &lt;filename>, `--installation=`&lt;filename>  
Read installation graph from the file at this location (default: empty).

`-o` &lt;output-dir>, `--output-dir=`&lt;output-dir>  
Save targeted deployment packages to the directory at this location (default: current directory).

`-r` &lt;repository>, `--repository=`&lt;repository>  
Look for dependent source packages in the directory at this location (default: `${SLIM_REPOSITORY:=~/.slim/repository}`).

`-t` &lt;os-name>, `--target-os=`&lt;os-name>
Specify the target OS to be used when evaluating OS-specific dependencies defined in the manifest: *, _mac, _windows, _linux_x86, _linux_x86_64. By default, all OS-specific dependencies will be installed (*).

`-c`, `--combine-search-head-indexer-workloads`
Combine search head and indexer workloads into a single deployment package.

`-d` &lt;specification> [&lt;specification> ...], `--deployment-packages=`&lt;specification> [&lt;specification> ...]
Specify a set of deployment packages by name, workload, and—for forwarder workloads—input groups. A deployment
specification is represented by a JSON object:

```
{
    "name": "<package-name>",
    "workload": [("searchHead" | "indexer" | "forwarder")(,("searchHead" | "indexer" | "forwarder") ...)](,
    "inputGroups": ["<group-name>"(, "<group-name>" ...)])
}
```

`-f` &lt;forwarder-workloads>, `--forwarder-workloads` &lt;forwarder-workloads>
Map app input groups to a set of server classes (default: ["_search_heads", "_indexers", "_forwarders"]). A forwarder workload
is represented by an JSON array of objects:

```
[
    "<server-class-name>": ["<input-group-name>"(, "<input-group-name>" ...)],
    "<server-class-name>": ["<input-group-name>"(, "<input-group-name>" ...)] ...
]
```

`-p` &lt;app-source>, `--target-os=`&lt;app-source>
Specify the location of the app package.