/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.hive;

import com.splunk.search.ParseNode;
import com.splunk.search.ParseNodeCmp;
import com.splunk.search.ParseNodeGroup;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.log4j.Logger;

public class HivePPDUtil {
    private static final String OLD_SEARCH_ARGUMENT_FACTORY = "org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory";
    private static final String NEW_SEARCH_ARGUMENT_FACTORY = "org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory";
    private static final String METHOD_NAME = "newBuilder";
    private static final String FACTORY_FIELD = "FACTORY";
    private static Logger gLogger = Logger.getLogger(HivePPDUtil.class);
    private static TypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");

    public static HivePPDInfo getHivePPDInfo(ParseNode root, String[] columnNames, List<TypeInfo> columnTypes) {
        HivePPDInfo info = new HivePPDInfo();
        try {
            SearchArgument.Builder builder = null;
            Method m = null;
            try {
                Field f = SearchArgument.class.getField(FACTORY_FIELD);
                if (f != null) {
                    Object o = f.get(null);
                    Class<?> c = Class.forName("org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory");
                    m = c.getMethod(METHOD_NAME, new Class[0]);
                    builder = (SearchArgument.Builder)m.invoke(o, new Object[0]);
                }
            }
            catch (Exception e) {
                Class<?> c = Class.forName("org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory");
                m = c.getMethod(METHOD_NAME, new Class[0]);
                builder = (SearchArgument.Builder)m.invoke(null, new Object[0]);
            }
            gLogger.debug((Object)("builder=" + builder));
            root = HivePPDUtil.normalize(root);
            gLogger.debug((Object)("root=" + root));
            if (root == null) {
                return info;
            }
            if (columnNames.length != columnTypes.size()) {
                throw new IllegalArgumentException("columnNames and columnTypes must have same number of elements");
            }
            LinkedHashMap<String, DecomposedColumnInfo> decomposedColumns = HivePPDUtil.getDecomposedColumns(columnNames, columnTypes);
            String[] readColNames = new String[decomposedColumns.size()];
            if (root.isLeaf()) {
                gLogger.debug((Object)"root.isLeaf=t, start building exprNodeDesc ...");
                builder.startAnd();
                info.exprNodeDesc = HivePPDUtil.parseCmpNode(builder, (ParseNodeCmp)root, decomposedColumns, readColNames);
                builder.end();
            } else {
                info.exprNodeDesc = HivePPDUtil.parseGroupNode(builder, (ParseNodeGroup)root, decomposedColumns, readColNames);
            }
            info.sarg = builder.build();
            StringBuilder sb = new StringBuilder();
            for (String s : readColNames) {
                sb.append(s + ",");
            }
            if (sb.length() > 0) {
                info.neededColumns = sb.substring(0, sb.length() - 1);
            }
        }
        catch (Exception e) {
            gLogger.warn((Object)("Unable to create a SearchArgument. ORC PPD is not applied. root=" + root), (Throwable)e);
            info.sarg = null;
            info.exprNodeDesc = null;
            info.neededColumns = null;
        }
        return info;
    }

    private static LinkedHashMap<String, DecomposedColumnInfo> getDecomposedColumns(String[] columnNames, List<TypeInfo> columnTypes) {
        LinkedHashMap<String, DecomposedColumnInfo> decomposedColumns = new LinkedHashMap<String, DecomposedColumnInfo>();
        int columnIndex = 0;
        int columnId = 0;
        decomposedColumns.put("null", new DecomposedColumnInfo(columnId, TypeInfoFactory.getStructTypeInfo(Arrays.asList(columnNames), columnTypes)));
        for (TypeInfo t : columnTypes) {
            int n = columnIndex++;
            ++columnId;
            columnId = HivePPDUtil.getDecomposedColumns(t, decomposedColumns, columnNames[n], columnId);
        }
        return decomposedColumns;
    }

    private static int getDecomposedColumns(TypeInfo type, LinkedHashMap<String, DecomposedColumnInfo> decomposedColumns, String decomposedColumnName, int columnId) {
        decomposedColumns.put(decomposedColumnName, new DecomposedColumnInfo(columnId, type));
        switch (type.getCategory()) {
            case LIST: {
                ++columnId;
                columnId = HivePPDUtil.getDecomposedColumns(((ListTypeInfo)type).getListElementTypeInfo(), decomposedColumns, decomposedColumnName + ".element", columnId);
                break;
            }
            case MAP: {
                MapTypeInfo mti = (MapTypeInfo)type;
                ++columnId;
                columnId = HivePPDUtil.getDecomposedColumns(mti.getMapKeyTypeInfo(), decomposedColumns, decomposedColumnName + ".key", columnId);
                ++columnId;
                columnId = HivePPDUtil.getDecomposedColumns(mti.getMapValueTypeInfo(), decomposedColumns, decomposedColumnName + ".value", columnId);
                break;
            }
            case STRUCT: {
                StructTypeInfo sti = (StructTypeInfo)type;
                for (String fieldName : sti.getAllStructFieldNames()) {
                    ++columnId;
                    columnId = HivePPDUtil.getDecomposedColumns(sti.getStructFieldTypeInfo(fieldName), decomposedColumns, decomposedColumnName + "." + fieldName, columnId);
                }
                break;
            }
            case UNION: {
                UnionTypeInfo uti = (UnionTypeInfo)type;
                int tag = 0;
                for (TypeInfo t : uti.getAllUnionObjectTypeInfos()) {
                    int n = tag++;
                    ++columnId;
                    columnId = HivePPDUtil.getDecomposedColumns(t, decomposedColumns, decomposedColumnName + "." + n, columnId);
                }
                break;
            }
        }
        return columnId;
    }

    private static ParseNode normalize(ParseNode node) {
        if (node == null) {
            return null;
        }
        ParseNode result = null;
        if (node.isLeaf()) {
            if (node.getType() == ParseNode.Type.cmp && !((ParseNodeCmp)node).hasRegex()) {
                return node;
            }
        } else if (node.getType() == ParseNode.Type.group) {
            ParseNodeGroup png = (ParseNodeGroup)node;
            if (png.getChildren() == null || png.getChildren().isEmpty()) {
                if (!png.isConjunctive()) {
                    result = new ParseNodeCmp(ParseNodeCmp.Operator.EQUALS, "1", "2");
                }
            } else {
                ArrayList<ParseNode> children = new ArrayList<ParseNode>();
                boolean skip = false;
                for (ParseNode pn : png.getChildren()) {
                    if (pn.isLeaf() && (pn.getType() == ParseNode.Type.term || pn.getType() == ParseNode.Type.phrase)) {
                        if (png.isConjunctive()) continue;
                        skip = true;
                        break;
                    }
                    ParseNode kid = HivePPDUtil.normalize(pn);
                    if (kid == null) continue;
                    children.add(kid);
                }
                if (!children.isEmpty() && !skip) {
                    result = children.size() == 1 ? (ParseNode)children.get(0) : new ParseNodeGroup(png.isConjunctive(), children);
                }
            }
        }
        return result;
    }

    private static Object boxLiteral(String lhs, String rhs, Map<String, DecomposedColumnInfo> decomposedColumns, String[] readColumnNames) {
        DecomposedColumnInfo decomposedColumn = null;
        try {
            String literal = rhs;
            decomposedColumn = decomposedColumns.get(lhs);
            if (decomposedColumn == null) {
                return literal;
            }
            readColumnNames[decomposedColumn.columnId] = lhs;
            if (decomposedColumn.columnType.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                PrimitiveObjectInspector.PrimitiveCategory t = ((PrimitiveTypeInfo)decomposedColumn.columnType).getPrimitiveCategory();
                return HivePPDUtil.boxLiteral(t, rhs);
            }
            return literal;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse the type of a search node: lhs=" + lhs + ", rhs=" + rhs + ", decomposedColumn=" + decomposedColumn, e);
        }
    }

    private static Object boxLiteral(PrimitiveObjectInspector.PrimitiveCategory t, String v) {
        switch (t) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return Long.parseLong(v);
            }
            case FLOAT: 
            case DOUBLE: {
                return Double.parseDouble(v);
            }
        }
        return v;
    }

    private static PredicateLeaf.Type getType(Object literal) {
        if (literal instanceof Byte || literal instanceof Short || literal instanceof Integer || literal instanceof Long) {
            return PredicateLeaf.Type.LONG;
        }
        if (literal instanceof HiveChar || literal instanceof HiveVarchar || literal instanceof String) {
            return PredicateLeaf.Type.STRING;
        }
        if (literal instanceof Float || literal instanceof Double) {
            return PredicateLeaf.Type.FLOAT;
        }
        if (literal instanceof DateWritable) {
            return PredicateLeaf.Type.DATE;
        }
        if (literal instanceof Timestamp) {
            return PredicateLeaf.Type.TIMESTAMP;
        }
        if (literal instanceof HiveDecimal || literal instanceof BigDecimal) {
            return PredicateLeaf.Type.DECIMAL;
        }
        if (literal instanceof Boolean) {
            return PredicateLeaf.Type.BOOLEAN;
        }
        throw new IllegalArgumentException("Unknown type for literal " + literal);
    }

    private static ExprNodeGenericFuncDesc parseCmpNode(SearchArgument.Builder builder, ParseNodeCmp pnc, Map<String, DecomposedColumnInfo> decomposedColumns, String[] readColumnNames) throws SemanticException {
        Object literal = HivePPDUtil.boxLiteral(pnc.getLeftHandSide(), pnc.getRightHandSide(), decomposedColumns, readColumnNames);
        if (pnc.isNegated()) {
            builder.startNot();
        }
        GenericUDF gudf = null;
        ExprNodeGenericFuncDesc exprNodeDesc = null;
        ArrayList<Object> children = new ArrayList<Object>();
        DecomposedColumnInfo decomposedColumnInfo = decomposedColumns.get(pnc.getLeftHandSide());
        TypeInfo type = stringTypeInfo;
        if (decomposedColumnInfo != null) {
            type = decomposedColumnInfo.columnType;
        }
        children.add(new ExprNodeColumnDesc(type, pnc.getLeftHandSide(), "", false));
        children.add(new ExprNodeConstantDesc(type, literal));
        switch (pnc.getOperator()) {
            case LESS_THAN_EQUALS: {
                builder.lessThanEquals(pnc.getLeftHandSide(), HivePPDUtil.getType(literal), literal);
                gudf = FunctionRegistry.getFunctionInfo((String)"<=").getGenericUDF();
                break;
            }
            case LESS_THAN: {
                builder.lessThan(pnc.getLeftHandSide(), HivePPDUtil.getType(literal), literal);
                gudf = FunctionRegistry.getFunctionInfo((String)"<").getGenericUDF();
                break;
            }
            case EQUALS: {
                builder.equals(pnc.getLeftHandSide(), HivePPDUtil.getType(literal), literal);
                gudf = FunctionRegistry.getFunctionInfo((String)"=").getGenericUDF();
                break;
            }
            case GREATER_THAN: {
                builder.startNot().lessThanEquals(pnc.getLeftHandSide(), HivePPDUtil.getType(literal), literal).end();
                gudf = FunctionRegistry.getFunctionInfo((String)">").getGenericUDF();
                break;
            }
            case GREATER_THAN_EQUALS: {
                builder.startNot().lessThan(pnc.getLeftHandSide(), HivePPDUtil.getType(literal), literal).end();
                gudf = FunctionRegistry.getFunctionInfo((String)">=").getGenericUDF();
                break;
            }
            case NOT_EQUALS: {
                builder.startNot().equals(pnc.getLeftHandSide(), HivePPDUtil.getType(literal), literal).end();
                gudf = FunctionRegistry.getFunctionInfo((String)"!=").getGenericUDF();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operator: " + (Object)((Object)pnc.getOperator()));
            }
        }
        if (pnc.isNegated()) {
            builder.end();
        }
        exprNodeDesc = new ExprNodeGenericFuncDesc(type, gudf, children);
        return exprNodeDesc;
    }

    private static ExprNodeGenericFuncDesc parseGroupNode(SearchArgument.Builder builder, ParseNodeGroup png, Map<String, DecomposedColumnInfo> decomposedColumns, String[] readColumnNames) throws SemanticException {
        ExprNodeGenericFuncDesc exprNodeDesc = null;
        ArrayList<ExprNodeGenericFuncDesc> children = new ArrayList<ExprNodeGenericFuncDesc>();
        if (png.isConjunctive()) {
            builder.startAnd();
            exprNodeDesc = new ExprNodeGenericFuncDesc(stringTypeInfo, FunctionRegistry.getFunctionInfo((String)"and").getGenericUDF(), children);
        } else {
            builder.startOr();
            exprNodeDesc = new ExprNodeGenericFuncDesc(stringTypeInfo, FunctionRegistry.getFunctionInfo((String)"or").getGenericUDF(), children);
        }
        ExprNodeGenericFuncDesc current = null;
        int i = 0;
        for (ParseNode kid : png.getChildren()) {
            current = kid.isLeaf() ? HivePPDUtil.parseCmpNode(builder, (ParseNodeCmp)kid, decomposedColumns, readColumnNames) : HivePPDUtil.parseGroupNode(builder, (ParseNodeGroup)kid, decomposedColumns, readColumnNames);
            if (i < 2) {
                children.add(current);
            } else {
                ExprNodeGenericFuncDesc previous = exprNodeDesc;
                children = new ArrayList();
                exprNodeDesc = png.isConjunctive() ? new ExprNodeGenericFuncDesc(stringTypeInfo, FunctionRegistry.getFunctionInfo((String)"and").getGenericUDF(), children) : new ExprNodeGenericFuncDesc(stringTypeInfo, FunctionRegistry.getFunctionInfo((String)"or").getGenericUDF(), children);
                children.add(previous);
                children.add(current);
            }
            ++i;
        }
        builder.end();
        return exprNodeDesc;
    }

    public static class HivePPDInfo {
        public ExprNodeGenericFuncDesc exprNodeDesc;
        public SearchArgument sarg;
        public String neededColumns;
    }

    private static class DecomposedColumnInfo {
        TypeInfo columnType;
        int columnId;
        String columnValue;

        public DecomposedColumnInfo(int columnId, TypeInfo columnType) {
            this.columnId = columnId;
            this.columnType = columnType;
        }

        public String toString() {
            return "[columnId=" + this.columnId + ", columnType=" + this.columnType + "], columnValue=" + this.columnValue;
        }
    }
}

