/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource;

import java.lang.reflect.Type;

public class Field {
    private String fieldName;
    private FieldType fieldType;
    private Repetition repetition;

    public Field() {
    }

    public Field(String fieldName, FieldType fieldType, Repetition repetition) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.repetition = repetition;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public Repetition getRepetition() {
        return this.repetition;
    }

    public static Type toType(FieldType type) {
        switch (type) {
            case STRING: {
                return String.class;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type.name());
    }

    public static enum FieldType {
        STRING,
        INT,
        LONG,
        DOUBLE,
        FLOAT,
        SHORT,
        BYTE,
        BOOLEAN;

    }

    public static enum Repetition {
        REQUIRED,
        OPTIONAL,
        REPEATED;

    }
}

