/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.s2s;

import com.splunk.s2s.ReadableV4;
import com.splunk.s2s.S2SString;
import com.splunk.s2s.S2SUtil;
import com.splunk.s2s.StreamingS2S;
import com.splunk.s2s.TCPSignature;
import com.splunk.s2s.WritableV4;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Channel
implements ReadableV4,
WritableV4 {
    public static final int EXPECTED_PIECES = 4;
    TCPSignature _fwdSignature;
    long _id;
    S2SString[] _pieces;
    S2SString[] _headers;
    String _source = null;
    String _sourcetype = null;
    String _host = null;
    String _extra = null;
    boolean _isControlChannel = false;

    public Channel() {
    }

    public Channel(TCPSignature fwdSignature) {
        this._fwdSignature = fwdSignature;
    }

    public Channel(TCPSignature fwdSignature, long id, S2SString[] pieces, S2SString[] headers) {
        this(fwdSignature);
        this._id = id;
        this._pieces = pieces;
        this._headers = headers;
        if (this._pieces.length != 4) {
            throw new IllegalArgumentException("Unexpected channel pieces size=" + this._pieces.length);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("channel: {id=").append(this._id);
        if (this._pieces != null && this._pieces.length > 0) {
            sb.append(", pieces=[");
            for (S2SString p : this._pieces) {
                sb.append(String.valueOf(p)).append(",");
            }
            sb.append("]");
        }
        if (this._headers != null && this._headers.length > 0) {
            sb.append(", headers=[");
            for (S2SString h : this._headers) {
                sb.append(String.valueOf(h)).append(",");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    public long getId() {
        return this._id;
    }

    public String getSource() {
        return this._source;
    }

    public String getSourcetype() {
        return this._sourcetype;
    }

    public String getHost() {
        return this._host;
    }

    public String getExtra() {
        return this._extra;
    }

    public boolean isControlChannel() {
        return this._isControlChannel;
    }

    public S2SString[] getPieces() {
        return this._pieces;
    }

    public TCPSignature getFwdSignature() {
        return this._fwdSignature;
    }

    public S2SString getPredefinedField(int id) {
        return this._headers == null || id >= this._headers.length ? null : this._headers[id];
    }

    @Override
    public void readFromS2SV4(InputStream in, StreamingS2S parent) throws IOException {
        this._id = S2SUtil.readBase128(in);
        this._pieces = new S2SString[4];
        for (int i = 0; i < 4; ++i) {
            int size = (int)S2SUtil.readBase128(in);
            if (size == 0) continue;
            this._pieces[i] = new S2SString(size - 1);
            S2SString.readFully(in, this._pieces[i]);
            String str = this._pieces[i].toString();
            if (str.startsWith("source::")) {
                this._source = str.substring("source::".length());
                continue;
            }
            if (str.startsWith("sourcetype::")) {
                this._sourcetype = str.substring("sourcetype::".length());
                continue;
            }
            if (str.startsWith("host::")) {
                this._host = str.substring("host::".length());
                continue;
            }
            this._extra = str;
        }
        this._isControlChannel = "fwd".equals(this._source) && "fwdinfo".equals(this._sourcetype);
        int p = (int)S2SUtil.readBase128(in);
        this._headers = new S2SString[p];
        for (int i = 0; i < this._headers.length; ++i) {
            this._headers[i] = S2SString.newFrom(in, parent);
        }
    }

    @Override
    public void writeToS2SV4(OutputStream out) throws IOException {
        int i;
        S2SUtil.writeBase128(out, this._id);
        for (i = 0; i < 4; ++i) {
            S2SString p = this._pieces[i];
            if (p == null) {
                S2SUtil.writeBase128(out, 0);
                continue;
            }
            S2SUtil.writeBase128(out, p.getBytes().length + 1);
            out.write(p.getBytes());
        }
        S2SUtil.writeBase128(out, this._headers == null ? 0 : this._headers.length);
        if (this._headers != null) {
            for (i = 0; i < this._headers.length; ++i) {
                this._headers[i].writeToS2SV4(out);
            }
        }
    }
}

