/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal;

import com.splunk.journal.EventData;
import com.splunk.journal.FieldDecoder;
import com.splunk.journal.PositionTrackingInputStream;
import com.splunk.journal.PrimitiveLongList;
import com.splunk.journal.RawdataMetaKeyItemType;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;

public class RawdataJournalReader
implements Closeable,
Iterable<EventData> {
    static final byte OPCODE_NOP = 0;
    static final byte OPCODE_OLDSTYLE_EVENT = 1;
    static final byte OPCODE_OLDSTYLE_EVENT_WITH_HASH = 2;
    static final byte OPCODE_NEW_HOST_CODE = 3;
    static final byte OPCODE_NEW_SOURCE_CODE = 4;
    static final byte OPCODE_NEW_SOURCETYPE_CODE = 5;
    static final byte OPCODE_NEW_STRING_CODE = 6;
    static final byte OPCODE_DELETE = 8;
    static final byte OPCODE_SPLUNK_PRIVATE = 9;
    static final byte OPCODE_HEADER = 10;
    static final byte OPCODE_HASHSLICE = 11;
    static Logger logger = Logger.getLogger(RawdataJournalReader.class);
    public static Charset UTF_8 = Charset.forName("UTF-8");
    private byte version = 0;
    private State state = State.WAITING_FOR_HEADER_OPCODE;
    private byte opcode;
    private byte hashIdx = 0;
    private long opcodeOffset;
    private long strEndPos = -1L;
    private long baseIndexTime = 0L;
    private byte alignBits = 0;
    private long alignMask = 0L;
    private final PositionTrackingInputStream input;
    private final FieldDecoder fieldMap = new FieldDecoder();
    private EventData eventData = new EventData(this.fieldMap);
    private PrivateEventData privateEventData = new PrivateEventData();
    final int NUM_BITS_INT = 32;
    final int NUM_BITS_LONG = 64;

    private RawdataJournalReader(InputStream inputStream) throws IOException {
        this.input = new PositionTrackingInputStream(inputStream);
    }

    public static RawdataJournalReader getReaderForStream(InputStream inputStream) throws IOException {
        return new RawdataJournalReader(inputStream);
    }

    public static RawdataJournalReader getReaderForGzipCompressedStream(InputStream inputStream) throws IOException {
        return new RawdataJournalReader(new GZIPInputStream(inputStream));
    }

    public static RawdataJournalReader getReaderForFile(File journalPath) throws IOException {
        BufferedInputStream base = new BufferedInputStream(new FileInputStream(journalPath));
        String extension = RawdataJournalReader.getExtension(journalPath);
        if (null != extension) {
            if (extension.equals("gz")) {
                return RawdataJournalReader.getReaderForGzipCompressedStream(base);
            }
            throw new IllegalArgumentException("Unknown extension: " + extension);
        }
        return RawdataJournalReader.getReaderForStream(base);
    }

    @Override
    public Iterator<EventData> iterator() {
        return new Iterator<EventData>(){
            EventData eventData = null;

            @Override
            public boolean hasNext() {
                if (null == this.eventData) {
                    try {
                        this.eventData = RawdataJournalReader.this.readEvent();
                    }
                    catch (IOException ex) {
                        logger.error((Object)"Caught exception while iterating");
                        return false;
                    }
                }
                return null != this.eventData;
            }

            @Override
            public EventData next() {
                EventData tmp = this.eventData;
                this.eventData = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FieldDecoder getFieldDecoder() {
        return this.fieldMap;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private static String getExtension(File path) {
        String name = path.getName();
        int idx = name.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        return name.substring(idx + 1);
    }

    private void gotHeader(byte version, long initialIndexTime, byte alignBits) {
        logger.debug((Object)("Parsed header of journal file. Version: " + version));
    }

    private void gotDelete(long val) {
    }

    private void gotPrivate(byte[] val) {
    }

    private void gotHashslice(byte[] val) {
    }

    private long getMostRecentOpcodeOffset() {
        return this.opcodeOffset;
    }

    private void handleOpcode() throws IOException {
        if (this.opcode >= 32 && this.opcode <= 43) {
            this.eventOpcode();
            return;
        }
        if (this.opcode >= 17 && this.opcode <= 31) {
            this.getStateForNewActiveThingee();
            return;
        }
        switch (this.opcode) {
            case 0: {
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.state = State.GET_NEW_STRING;
                return;
            }
            case 8: {
                this.state = State.GET_DELETE_OFFSET;
                return;
            }
            case 9: {
                this.state = State.GET_SPLUNK_PRIVATE;
                return;
            }
            case 11: {
                this.state = State.GET_HASH_SLICE;
                break;
            }
            case 1: 
            case 2: {
                this.eventOpcode();
                return;
            }
            default: {
                this.input.unread(this.opcode);
                this.state = State.GOT_BAD_OPCODE;
                return;
            }
        }
    }

    public EventData readEvent() throws IOException {
        while (true) {
            switch (this.state) {
                case WAITING_FOR_OPCODE: {
                    this.opcode = this.input.getNextByte();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.opcodeOffset = this.input.getCurrentOffset() - 1L;
                    this.handleOpcode();
                    break;
                }
                case GET_EVENT_LENGTH: {
                    this.readEventProper();
                    return this.eventData;
                }
                case GET_ACTIVE_HOST: {
                    int host = this.readVariableWidthIntAsInt();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.fieldMap.setActiveHost(host);
                    if (this.afterNewActiveHost()) break;
                    this.state = State.WAITING_FOR_OPCODE;
                    break;
                }
                case GET_ACTIVE_SOURCE: {
                    int source = this.readVariableWidthIntAsInt();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.fieldMap.setActiveSource(source);
                    this.afterNewActiveSource();
                    break;
                }
                case GET_ACTIVE_SOURCETYPE: {
                    int sourcetype = this.readVariableWidthIntAsInt();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.fieldMap.setActiveSourcetype(sourcetype);
                    this.afterNewActiveSourcetype();
                    break;
                }
                case GET_ACTIVE_TIME: {
                    long time = this.read32BitLong();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.fieldMap.setActiveTime(time);
                    this.state = State.WAITING_FOR_OPCODE;
                    break;
                }
                case GET_NEW_STRING: {
                    byte[] code = this.readString();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.fieldMap.addCode(this.opcode, code);
                    this.state = State.WAITING_FOR_OPCODE;
                    break;
                }
                case GET_SPLUNK_PRIVATE: {
                    byte[] privVal = this.readString();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.gotPrivate(privVal);
                    this.state = State.WAITING_FOR_OPCODE;
                    break;
                }
                case GET_HASH_SLICE: {
                    byte[] hashVal = this.readString();
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.gotHashslice(hashVal);
                    this.state = State.WAITING_FOR_OPCODE;
                    break;
                }
                case GET_DELETE_OFFSET: {
                    this.gotDelete(this.readVariableWidthLong() << this.alignBits);
                    if (this.input.isEndOfStreamReached()) {
                        return null;
                    }
                    this.state = State.WAITING_FOR_OPCODE;
                    break;
                }
                case WAITING_FOR_HEADER_OPCODE: {
                    this.state = this.readHeader();
                    if (null != this.state) break;
                    this.state = State.WAITING_FOR_OPCODE;
                    return null;
                }
                case GOT_BAD_OPCODE: {
                    long boc = this.readVariableWidthLong();
                    if (boc != 10L) {
                        this.handleError("Bad opcode: " + boc);
                    }
                    this.handleError("Got unexpected header record");
                }
            }
        }
    }

    private State readHeader() throws IOException {
        this.opcode = this.input.getNextByte();
        if (this.input.isEndOfStreamReached()) {
            return null;
        }
        this.opcodeOffset = this.input.getCurrentOffset() - 1L;
        if (this.opcode != 10) {
            return State.GOT_BAD_OPCODE;
        }
        this.version = 0;
        this.baseIndexTime = 0L;
        this.version = this.input.getNextByte();
        if (this.input.isEndOfStreamReached()) {
            return null;
        }
        this.alignBits = this.input.getNextByte();
        if (this.alignBits > 63) {
            this.handleError("Invalid align value: " + this.alignBits);
        }
        if (this.input.isEndOfStreamReached()) {
            return null;
        }
        this.baseIndexTime = this.read32BitLong();
        if (this.input.isEndOfStreamReached()) {
            return null;
        }
        this.gotHeader(this.version, this.baseIndexTime, this.alignBits);
        this.alignMask = (1L << this.alignBits) - 1L;
        return State.WAITING_FOR_OPCODE;
    }

    private void readEventProper() throws IOException {
        int numRead;
        this.privateEventData.endPosOfCurrentEvent = this.readVariableWidthLong();
        if (this.privateEventData.endPosOfCurrentEvent > Long.MAX_VALUE - this.input.getCurrentOffset()) {
            this.handleError("Bad event end pos: " + this.privateEventData.endPosOfCurrentEvent);
        }
        this.privateEventData.endPosOfCurrentEvent += this.input.getCurrentOffset();
        if (this.eventHasEstorage(this.opcode)) {
            int len = this.readVariableWidthIntAsInt();
            if (len >= 0x10000000) {
                this.handleError("Event had too many metadata terms: " + len);
            }
            this.eventData.setEstorage(new byte[len]);
        }
        if ((this.opcode & 1) == 0) {
            byte[] hash = this.eventData.getHash();
            while (this.hashIdx < hash.length) {
                byte by = this.hashIdx;
                this.hashIdx = (byte)(by + 1);
                hash[by] = this.input.getNextByte();
            }
            this.hashIdx = 0;
        }
        this.eventData.setStreamId(this.read64BitLong());
        this.eventData.setStreamOffset(this.readVariableWidthLong());
        this.eventData.setStreamSuboffset(this.readVariableWidthInt());
        this.eventData.setIndexTime((long)this.readVariableWidthSignedInt() + this.baseIndexTime);
        this.eventData.setEncodedSubseconds(this.readVariableWidthLong());
        this.privateEventData.metaDataCount = (int)this.readVariableWidthInt();
        while (this.privateEventData.metaDataCount > 0) {
            this.privateEventData.metaKeyReader.readMetakeys();
            --this.privateEventData.metaDataCount;
        }
        if (this.eventHasEstorage(this.opcode) && (numRead = this.input.readFully(this.eventData.getEstorage())) < this.eventData.getEstorage().length) {
            this.handleError("End of stream reached while reading estorage section");
        }
        if (this.privateEventData.endPosOfCurrentEvent < this.input.getCurrentOffset()) {
            this.handleError("Event record overran length (" + this.input.getCurrentOffset() + " > " + this.privateEventData.endPosOfCurrentEvent + ")");
        }
        this.strEndPos = this.privateEventData.endPosOfCurrentEvent;
        assert (this.strEndPos > this.input.getCurrentOffset());
        byte[] rawEvent = this.readString();
        if (null == rawEvent) {
            this.handleError("End of stream reached before current event was finished");
        }
        this.eventData.setRawContents(rawEvent);
        this.eventData.setMetaInfo(this.privateEventData.metaKeyReader.metaInfo);
        this.eventData.setIncludedPunctuation((this.opcode & 0x22) == 34);
        this.state = State.WAITING_FOR_OPCODE;
    }

    private boolean eventHasEstorage(byte opcode) {
        return (opcode & 4) != 0;
    }

    private byte[] readString() throws IOException {
        int len = 0;
        len = this.strEndPos < 0L ? (int)this.readVariableWidthLong() : (int)(this.strEndPos - this.input.getCurrentOffset());
        byte[] text = new byte[len];
        if (text.length > this.input.readFully(text)) {
            return null;
        }
        this.strEndPos = -1L;
        return text;
    }

    private void resetEvent() {
        this.privateEventData.reset();
        this.eventData.reset();
    }

    long readVariableWidthInt() throws IOException {
        return this.readVariableWidthBase128Number(32);
    }

    int readVariableWidthIntAsInt() throws IOException {
        long val = this.readVariableWidthInt();
        if (val >>> 31 != 0L) {
            this.handleError("Deserialized number overflowed signed 4 bytes");
        }
        return (int)val;
    }

    long readVariableWidthLong() throws IOException {
        long val = this.readVariableWidthBase128Number(64);
        if (val < 0L) {
            this.handleError("Deserialized number overflowed signed 8 bytes");
        }
        return val;
    }

    long readVariableWidthSignedLong() throws IOException {
        return this.readVariableWidthBase128Number(64);
    }

    int readVariableWidthSignedInt() throws IOException {
        return (int)this.readVariableWidthBase128Number(32);
    }

    private long readVariableWidthBase128Number(int maxShift) throws IOException {
        long scratchPad = 0L;
        for (int shift = 0; shift <= maxShift + 7; shift += 7) {
            if (shift >= maxShift) {
                this.handleError("base128 number too large");
            }
            byte datum = this.input.getNextByte();
            if (this.input.isEndOfStreamReached()) {
                return -1L;
            }
            long byteAsLong = 0xFF & datum;
            if ((datum & 0x80) != 0) {
                scratchPad |= (byteAsLong & 0xFFFFFFFFFFFFFF7FL) << shift;
                continue;
            }
            if (shift == 0) {
                scratchPad = byteAsLong;
                break;
            }
            long numBinaryDigits = 64 - Long.numberOfLeadingZeros(byteAsLong);
            if (numBinaryDigits + (long)shift > (long)maxShift) {
                this.handleError("base128 number too large");
            }
            scratchPad |= byteAsLong << shift;
            break;
        }
        return scratchPad;
    }

    long read64BitLong() throws IOException {
        return this.readFixedWidthNumber(64);
    }

    long read32BitLong() throws IOException {
        return this.readFixedWidthNumber(32);
    }

    private long readFixedWidthNumber(int numBits) throws IOException {
        long scratchPad = 0L;
        for (int shift = 0; shift < numBits; shift += 8) {
            byte datum = this.input.getNextByte();
            long byteAsLong = 0xFF & datum;
            scratchPad |= byteAsLong << shift;
        }
        return scratchPad;
    }

    private boolean getStateForNewActiveThingee() {
        if ((this.opcode & 8) != 0) {
            this.state = State.GET_ACTIVE_HOST;
            return true;
        }
        return this.afterNewActiveHost();
    }

    private boolean afterNewActiveHost() {
        if ((this.opcode & 4) != 0) {
            this.state = State.GET_ACTIVE_SOURCE;
            return true;
        }
        return this.afterNewActiveSource();
    }

    private boolean afterNewActiveSource() {
        if ((this.opcode & 2) != 0) {
            this.state = State.GET_ACTIVE_SOURCETYPE;
            return true;
        }
        return this.afterNewActiveSourcetype();
    }

    private boolean afterNewActiveSourcetype() {
        if ((this.opcode & 1) != 0) {
            this.state = State.GET_ACTIVE_TIME;
            return true;
        }
        this.state = State.WAITING_FOR_OPCODE;
        return false;
    }

    private void eventOpcode() {
        if ((this.getMostRecentOpcodeOffset() & this.alignMask) != 0L) {
            this.handleError("Event started at offset incompatible with %" + this.alignBits + "-bit align");
        }
        this.resetEvent();
        this.eventData.setFileOffset(this.getMostRecentOpcodeOffset());
        this.state = State.GET_EVENT_LENGTH;
    }

    void handleError(String msg) {
        msg = msg + " [offset = " + this.input.getCurrentOffset() + "]";
        logger.fatal((Object)msg);
        throw new IllegalStateException(msg);
    }

    private static enum State {
        WAITING_FOR_OPCODE,
        GET_EVENT_LENGTH,
        GET_ACTIVE_HOST,
        GET_ACTIVE_SOURCE,
        GET_ACTIVE_SOURCETYPE,
        GET_ACTIVE_TIME,
        GET_NEW_STRING,
        GET_SPLUNK_PRIVATE,
        GET_HASH_SLICE,
        GET_DELETE_OFFSET,
        WAITING_FOR_HEADER_OPCODE,
        GOT_BAD_OPCODE;

    }

    private class PrivateEventData {
        long endPosOfCurrentEvent = 0L;
        int metaDataCount = 0;
        MetaKeyReader metaKeyReader = new MetaKeyReader();

        private PrivateEventData() {
        }

        void reset() {
            this.metaDataCount = 0;
            this.endPosOfCurrentEvent = 0;
            this.metaKeyReader = new MetaKeyReader();
        }
    }

    private class MetaKeyReader {
        PrimitiveLongList metaInfo = new PrimitiveLongList();

        private MetaKeyReader() {
        }

        public void readMetakeys() throws IOException {
            long metakey = RawdataJournalReader.this.readVariableWidthLong();
            if (RawdataJournalReader.this.input.isEndOfStreamReached()) {
                return;
            }
            int numToRead = -1;
            RawdataMetaKeyItemType metavalueType = null;
            if (RawdataJournalReader.this.opcode <= 2) {
                this.metaInfo.add(metakey <<= 3);
                numToRead = 1;
            } else {
                if (RawdataJournalReader.this.opcode < 36) {
                    metakey <<= 2;
                }
                this.metaInfo.add(metakey);
                metavalueType = RawdataMetaKeyItemType.getTypeFromCombined(metakey);
                numToRead = metavalueType.getExtraIntsNeeded();
            }
            while (numToRead > 0) {
                long metaval = RawdataJournalReader.this.readVariableWidthSignedLong();
                if (RawdataJournalReader.this.input.isEndOfStreamReached()) {
                    return;
                }
                --numToRead;
                this.metaInfo.add(metaval);
            }
        }
    }
}

