/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.s2s;

import com.splunk.s2s.ReadableV4;
import com.splunk.s2s.S2SUtil;
import com.splunk.s2s.S2SValue;
import com.splunk.s2s.StreamingS2S;
import com.splunk.s2s.WritableV4;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class S2SString
implements S2SValue,
ReadableV4,
WritableV4,
Comparable<S2SString> {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    byte[] _data = null;

    public S2SString() {
    }

    public S2SString(int size) {
        this._data = new byte[size];
    }

    public S2SString(byte[] data) {
        this._data = data;
    }

    public S2SString(byte[] data, int off, int len) {
        this._data = new byte[len];
        System.arraycopy(data, off, this._data, 0, len);
    }

    public S2SString(String val) {
        this._data = val.getBytes(UTF8);
    }

    public String toString() {
        return new String(this._data);
    }

    @Override
    public byte[] getBytes() {
        return this._data;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int size() {
        return this._data == null ? 0 : this._data.length;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public Number asNumber() {
        throw new UnsupportedOperationException("Not a number");
    }

    public boolean empty() {
        return this._data == null || this._data.length == 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof S2SString)) {
            return false;
        }
        S2SString s2so = (S2SString)other;
        return Arrays.equals(this._data, s2so._data);
    }

    public int hashCode() {
        int hash = 5381;
        for (int i = 0; i < this._data.length; ++i) {
            hash = (hash << 5) + hash + (this._data[i] & 0xFF);
        }
        return hash;
    }

    @Override
    public void readFromS2SV4(InputStream in, StreamingS2S parent) throws IOException {
        int p = (int)S2SUtil.readBase128(in);
        this._data = new byte[p];
        S2SUtil.readFully(in, this._data);
    }

    @Override
    public void writeToS2SV4(OutputStream out) throws IOException {
        S2SUtil.writeBase128(out, this._data == null ? 0 : this._data.length);
        if (this._data != null) {
            out.write(this._data);
        }
    }

    public static void readFully(InputStream in, S2SString str) throws IOException {
        S2SUtil.readFully(in, str._data);
    }

    public static S2SString newFrom(InputStream in, StreamingS2S parent) throws IOException {
        S2SString result = new S2SString();
        result.readFromS2SV4(in, parent);
        return result;
    }

    @Override
    public int compareTo(S2SString o) {
        return S2SString.compareBytes(this._data, 0, this._data.length, o._data, 0, o._data.length);
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }
}

