/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal;

public class PrimitiveLongList {
    private long[] data = new long[30];
    private int endPos = 0;

    public void expand() {
        int len = Math.max((int)(1.5 * (double)this.data.length), this.data.length + 1);
        long[] replacement = new long[len];
        System.arraycopy(this.data, 0, replacement, 0, this.data.length);
        this.data = replacement;
    }

    public void add(long val) {
        if (this.endPos == this.data.length) {
            this.expand();
        }
        this.data[this.endPos++] = val;
    }

    public void clear() {
        this.endPos = 0;
    }

    public int length() {
        return this.endPos;
    }

    public long get(int pos) {
        if (pos >= this.endPos) {
            throw new IndexOutOfBoundsException("Length is " + this.endPos + ", but attempt to access position " + pos);
        }
        return this.data[pos];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{PrimitiveLongList: [");
        boolean first = true;
        for (int i = 0; i < this.endPos; ++i) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(this.data[i]);
        }
        builder.append("]");
        return builder.toString();
    }
}

