/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.SplunkEvent;
import com.splunk.df.search.SplunkEventChunk;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.ComputeEngineFactory;
import com.splunk.df.search.compute.ExecutionHints;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.spark.SparkUtils;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import com.splunk.df.util.EstimatedEventCount;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;
import org.apache.spark.SparkEnv;
import org.json.JSONObject;

public class Utils
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(Utils.class);

    public static <T> T as(Class<T> t, Object o) {
        return t.isInstance(o) ? (T)t.cast(o) : null;
    }

    public static String decodeAndDecompress(String data) throws IOException, DataFormatException {
        byte[] dataBytes = Base64.decodeBase64((String)data);
        Inflater inf = new Inflater();
        inf.setInput(dataBytes);
        byte[] output = new byte[0x100000];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        do {
            len = inf.inflate(output);
            baos.write(output);
            Arrays.fill(output, (byte)0);
        } while (len == output.length);
        inf.end();
        baos.flush();
        String payload = new String(baos.toByteArray(), "UTF-8");
        baos.close();
        baos = null;
        payload = payload.trim();
        return payload;
    }

    public static String compressAndEncode(String payload) throws IOException {
        int len;
        long start = System.currentTimeMillis();
        byte[] payloadBytes = payload.getBytes();
        logger.debug((Object)("Length of payload bytes: " + payloadBytes.length));
        Deflater def = new Deflater(1);
        def.setInput(payloadBytes);
        def.finish();
        byte[] chunk = new byte[51200];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            len = def.deflate(chunk);
            baos.write(chunk, 0, len);
            Arrays.fill(chunk, (byte)0);
        } while (len == chunk.length);
        def.end();
        baos.flush();
        byte[] output = baos.toByteArray();
        baos.close();
        baos = null;
        logger.debug((Object)("Size of compressed data: " + output.length));
        String encoded = Base64.encodeBase64String((byte[])output);
        output = null;
        logger.debug((Object)("Size of compressed and encoded data: " + encoded.length()));
        logger.debug((Object)("Time to compress and encode: " + (System.currentTimeMillis() - start) + " millis"));
        return encoded;
    }

    public static boolean incompleteCsvLine(String line) {
        int idx = line.lastIndexOf(",\"");
        int idx1 = line.lastIndexOf("\"");
        return idx > 0 && idx1 <= idx + 1;
    }

    public static void printJvmStats(String prefix) {
        Runtime rt = Runtime.getRuntime();
        long mb = 0x100000L;
        long total = rt.totalMemory() / mb;
        long max = rt.maxMemory() / mb;
        long free = rt.freeMemory() / mb;
        logger.debug((Object)(prefix + ": total memory: " + total + "; max memory: " + max + "; free memory: " + free));
    }

    public static int getKeyIndex(String[] strs, String key) {
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (!str.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Throwable t) {
            logger.error((Object)("Error sleeping: " + t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object lock, long time) {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(time);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void waitForData(BufferedReader br, String message) {
        try {
            logger.debug((Object)message);
            while (!br.ready()) {
                Utils.sleep(100L);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error while waiting for buffer to have data", t);
            throw new RuntimeException(t);
        }
    }

    public static void waitForData(BufferedReader br, String message, long millis) {
        try {
            while (!br.ready()) {
                Utils.sleep(millis);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error while waiting for buffer to have data", t);
        }
    }

    public static String readData(BufferedReader br, int size) throws IOException {
        if (size == 0) {
            return "";
        }
        char[] buff = new char[size];
        int totalRead = 0;
        while (true) {
            int charsRead;
            if (!br.ready()) {
                Utils.sleep(100L);
                continue;
            }
            if ((totalRead += (charsRead = br.read(buff, totalRead, size - totalRead))) == size) break;
        }
        return new String(buff);
    }

    public static SplunkEvent createEmptyEvent(String[] metadata) {
        Object[] data = new String[metadata.length];
        Arrays.fill(data, "");
        SplunkEvent event = new SplunkEvent(metadata, (String[])data);
        return event;
    }

    public static String toHex(String s) {
        return String.format("%040x", new BigInteger(1, s.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordChunk(String recordingFolder, SplunkEventChunk chunk) {
        File chunkFile = new File(recordingFolder + "/chunk-" + chunk.getSparkLookupCode() + "-" + chunk.getNumEvents() + "-" + System.currentTimeMillis());
        try {
            if (!chunkFile.createNewFile()) {
                logger.error((Object)("Could not record chunk to file: " + chunkFile.getAbsolutePath() + " because could not create new file"));
                return;
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Could not create chunk file: " + chunkFile.getAbsolutePath() + ": " + t.getMessage()), t);
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(chunkFile)));
            String data = Utils.decodeAndDecompress(chunk.getCompressedData());
            bw.write(data);
            bw.flush();
            logger.debug((Object)("Writen chunk file: " + chunkFile.getAbsolutePath() + " to disk"));
        }
        catch (Throwable t) {
            logger.error((Object)("Error while writing to chunk file: " + chunkFile.getAbsolutePath() + ": " + t.getMessage()), t);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Throwable t) {
                    logger.error((Object)("Error while closing chunk file writer: " + t.getMessage()), t);
                }
            }
        }
    }

    public static void appendCSVRecord(StringBuilder sb, CSVRecord rec) {
        int size = rec.size();
        for (int i = 0; i < size; ++i) {
            String field = rec.get(i);
            sb.append("\"" + field + "\"");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        sb.append("\n");
    }

    public static String toCSVString(CSVRecord rec) {
        StringBuilder sb = new StringBuilder();
        int size = rec.size();
        for (int i = 0; i < size; ++i) {
            String field = rec.get(i);
            sb.append("\"" + field + "\"");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            logger.error((Object)"Process is not alive");
            return false;
        }
    }

    public static boolean runCommand(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to run command, exception - ", t);
            return false;
        }
    }

    public static void renameArgsCheckAndTermMatcherCreation(RenameNode[] renames, TermMatcher[] fromNameArr, TermMatcher[] toNameArr) {
        for (int i = 0; i < renames.length; ++i) {
            String fromNameStr = renames[i].getFieldName();
            String toNameStr = renames[i].getNewFieldName();
            TermMatcher fromName = new TermMatcher(fromNameStr);
            TermMatcher toName = new TermMatcher(toNameStr);
            if (fromName.parts().length != toName.parts().length) {
                throw new IllegalArgumentException("Wildcard mismatch '" + fromNameStr + "' as '" + toNameStr + "'.");
            }
            fromNameArr[i] = fromName;
            toNameArr[i] = toName;
        }
    }

    public static String getRenameField(String originStr, TermMatcher fromName, TermMatcher toName) {
        boolean needRename = originStr.startsWith("__mv_") ? fromName.match(originStr.substring("__mv_".length())) : fromName.match(originStr);
        if (!needRename) {
            return null;
        }
        String[] fromParts = fromName.parts();
        String[] toParts = toName.parts();
        String toField = Utils.replaceEach(originStr, fromParts, toParts);
        if (fromParts.length > 0 && toParts.length > 0) {
            if (fromParts[0].isEmpty() && !toParts[0].isEmpty()) {
                toField = toParts[0] + toField;
            }
            if (fromParts[fromParts.length - 1].isEmpty() && !toParts[fromParts.length - 1].isEmpty()) {
                toField = toField + toParts[fromParts.length - 1];
            }
        }
        return toField;
    }

    public static String getLocalHostAddress() {
        try {
            String ipAddr = InetAddress.getLocalHost().getHostAddress();
            logger.debug((Object)String.format("Localhost ip-address: %s", ipAddr));
            return ipAddr;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not getLocalHostAddress", t);
        }
    }

    public static String getIpFromEnv(String env, boolean defaultToLocalHost) {
        if (env == null || env.trim().length() == 0) {
            throw new RuntimeException("Host/IP env var is null or empty.");
        }
        String host = System.getenv(env);
        logger.debug((Object)("Host:" + host + " from env: " + env));
        if (host == null || host.trim().length() == 0) {
            if (defaultToLocalHost) {
                return Utils.getLocalHostAddress();
            }
            throw new RuntimeException("Host/IP env var: " + env + " is not set.");
        }
        try {
            return InetAddress.getByName(host.trim()).getHostAddress();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not get the ip address of the host:" + host, t);
        }
    }

    public static String getIpFromSplunkHostnameEnv() {
        return Utils.getIpFromEnv("SPLUNK_HOSTNAME", false);
    }

    public static SearchResult mergeMetaInfo(SearchResult sr, SearchResult metaInfo) {
        if (metaInfo == null || metaInfo.isEmpty()) {
            return sr;
        }
        ArrayList<SearchResult.FieldMeta> mf = new ArrayList<SearchResult.FieldMeta>();
        ArrayList<Object> mv = new ArrayList<Object>();
        for (int mi = 0; mi < metaInfo.getSize(); ++mi) {
            if (!metaInfo.getFieldNames()[mi].fieldName().startsWith("_")) continue;
            mf.add(metaInfo.getFieldNames()[mi]);
            mv.add(metaInfo.getFieldValues()[mi]);
        }
        if (mf.isEmpty()) {
            return sr;
        }
        return SearchResultFactory.getInstance().merge(sr, SearchResultFactory.getInstance().createSearchResult(mf.toArray(new SearchResult.FieldMeta[mf.size()]), mv.toArray(new Object[mv.size()])));
    }

    public static String[] getNonEmpty(String[] parts) {
        ArrayList<String> nonEmptyParts = new ArrayList<String>();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            nonEmptyParts.add(p);
        }
        return nonEmptyParts.toArray(new String[nonEmptyParts.size()]);
    }

    public static Double convertToDouble(String val) {
        if (val == null || val.length() == 0) {
            return null;
        }
        String nonDecimalPattern = "^(\\d+\\.){2}";
        Pattern pattern = Pattern.compile(nonDecimalPattern);
        Matcher matcher = pattern.matcher(val);
        if (matcher.find()) {
            return null;
        }
        boolean pointSeen = false;
        boolean eSeen = false;
        boolean numberSeen = false;
        StringBuilder builder = new StringBuilder();
        char cur = '\u0000';
        for (int i = 0; i < val.length(); ++i) {
            cur = val.charAt(i);
            if ('0' <= cur && cur <= '9') {
                numberSeen = true;
                builder.append(cur);
                continue;
            }
            if (cur == '.') {
                if (eSeen || pointSeen) break;
                pointSeen = true;
                builder.append(cur);
                continue;
            }
            if (cur == 'e' || cur == 'E') {
                if (!numberSeen || eSeen) break;
                eSeen = true;
                builder.append(cur);
                continue;
            }
            if (cur != '-' && cur != '+' || i != 0 && val.charAt(i - 1) != 'e' && val.charAt(i - 1) != 'E') break;
            builder.append(cur);
        }
        if (!numberSeen) {
            return null;
        }
        cur = builder.charAt(builder.length() - 1);
        if (builder.length() > 1 && (cur == '+' || cur == '-')) {
            builder.deleteCharAt(builder.length() - 1);
        }
        if ((cur = builder.charAt(builder.length() - 1)) == 'e' || cur == 'E') {
            builder.append(0);
        }
        return new Double(builder.toString());
    }

    public static FederatedDataSetInfo getDataSetInfo(String datasetName, HashMap<Integer, FederatedDataSetInfo> datasetInfoMap) {
        Object deploymentName = null;
        for (Map.Entry<Integer, FederatedDataSetInfo> entry : datasetInfoMap.entrySet()) {
            FederatedDataSetInfo fshDatasetInfo = entry.getValue();
            if (!fshDatasetInfo.getDatasetName().equalsIgnoreCase(datasetName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getDeploymentForDataSet(String datasetName, HashMap<Integer, FederatedDataSetInfo> datasetInfoMap) {
        String deploymentName = null;
        for (Map.Entry<Integer, FederatedDataSetInfo> entry : datasetInfoMap.entrySet()) {
            FederatedDataSetInfo fshDatasetInfo = entry.getValue();
            if (!fshDatasetInfo.getDatasetName().equalsIgnoreCase(datasetName)) continue;
            deploymentName = fshDatasetInfo.getDeploymentName();
        }
        assert (deploymentName != null);
        return deploymentName;
    }

    public static boolean isDownloadRemoteLogEnabled(ComputeEngineContext ctx) {
        return (Boolean)ctx.get(FETCH_REMOTE_SEARCH_LOG.toString());
    }

    public static boolean updateHeaderFields(HashSet<SearchResult.FieldMeta> keys, SearchResult sr) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> srdata = sr.getDataMap();
        if (srdata.isEmpty()) {
            return false;
        }
        int count = keys.size();
        SearchResult.FieldMeta[] fieldArray = sr.getFieldNames();
        for (int i = 0; i < fieldArray.length; ++i) {
            keys.add(fieldArray[i]);
        }
        boolean keysChanged = false;
        if (keys.size() > count) {
            keysChanged = true;
        }
        return keysChanged;
    }

    public static boolean isFastStartup() {
        boolean fast = true;
        String fastStr = System.getenv("DFS_FAST_STARTUP");
        if (fastStr != null) {
            try {
                fast = Boolean.valueOf(fastStr);
                logger.info((Object)String.format("fast startup overridden by envvar: %s, value: %b", "DFS_FAST_STARTUP", fast));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to boolean", "DFS_FAST_STARTUP"));
            }
        }
        logger.debug((Object)String.format("setting fast startup mode to: %b", fast));
        return fast;
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        int i;
        if (text == null || text.isEmpty() || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i2 = 0; i2 < searchLength; ++i2) {
            if (noMoreMatchesForReplIndex[i2] || searchList[i2] == null || searchList[i2].isEmpty() || replacementList[i2] == null) continue;
            tempIndex = i2 > 0 && i2 == searchLength - 1 ? text.lastIndexOf(searchList[i2]) : text.indexOf(searchList[i2]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i2] = true;
                continue;
            }
            if (textIndex != -1) continue;
            textIndex = tempIndex;
            replaceIndex = i2;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i3 = 0; i3 < searchList.length; ++i3) {
            int greater;
            if (searchList[i3] == null || replacementList[i3] == null || (greater = replacementList[i3].length() - searchList[i3].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        block2: while (textIndex != -1) {
            for (int i4 = start; i4 < textIndex; ++i4) {
                buf.append(text.charAt(i4));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            int replacedIndex = replaceIndex + 1;
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = replacedIndex; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                tempIndex = i > 0 && i == searchLength - 1 ? text.lastIndexOf(searchList[i]) : text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1) continue;
                textIndex = tempIndex;
                replaceIndex = i;
                continue block2;
            }
        }
        int textLength = text.length();
        for (i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        return result;
    }

    public static int getMaxSupportedWorkers() {
        int numWorkers = 100;
        String maxWorkersStr = System.getenv("DFC_MAX_WORKERS");
        if (maxWorkersStr != null && !maxWorkersStr.trim().isEmpty()) {
            try {
                numWorkers = Integer.valueOf(maxWorkersStr);
                logger.info((Object)String.format("max workers updated through env var: %d", numWorkers));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max workers: %s to int", maxWorkersStr));
            }
        }
        logger.info((Object)String.format("using max workers: %d", numWorkers));
        return numWorkers;
    }

    public static long getWorkerStartupWaitTime() {
        long wait = 2000L;
        String waitStr = System.getenv("DFC_WORKER_START_WAIT_TIME_MILLIS");
        if (waitStr != null && !waitStr.trim().isEmpty()) {
            try {
                wait = Long.valueOf(waitStr);
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max worker wait time millis: %s to long", waitStr));
            }
        }
        logger.info((Object)String.format("using max worker startup time: %d millis", wait));
        return wait;
    }

    public static boolean isDfsElasticModeEnabled() {
        boolean enabled = false;
        String enabledStr = System.getenv("DFS_ELASTIC_MODE_ENABLED");
        if (enabledStr != null && !enabledStr.trim().isEmpty()) {
            try {
                enabled = Boolean.valueOf(enabledStr);
                logger.debug((Object)String.format("elastic mode set to: %b by envvar", enabled));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse elastic mode value: %s to boolean", enabledStr));
            }
        }
        logger.debug((Object)String.format("elastic mode set to: %b", enabled));
        return enabled;
    }

    private static int getMinWorkers() {
        int workers = 4;
        String workersStr = System.getenv("DFS_MIN_WORKERS");
        if (workersStr != null && !workersStr.trim().isEmpty()) {
            try {
                workers = Integer.valueOf(workersStr);
                logger.info((Object)String.format("min workers set to: %d by envvar", workers));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse: %s to int - min workers", workersStr));
            }
        }
        logger.info((Object)String.format("min workers set to: %d", workers));
        return workers;
    }

    public static int getStartupWorkers(long estimatedEventCount, int workerMemMbs, int driverMemMbs, int totalCores, int coresPerWorker, long maxReduceParSize, int totalCoresOnSH, boolean[] lowLatencyMode) {
        int coresRequired;
        int actualNumPars;
        double rdinBoost = Utils.getRdinBoost();
        long boostedEstimatedEventCount = (long)((double)estimatedEventCount * rdinBoost);
        ComputeEngineContext ctx = new ComputeEngineContext();
        ctx.addContext("executor.memory.mbs", workerMemMbs);
        ctx.addContext("driver.memory.mbs", driverMemMbs);
        ctx.addContext("numCores", totalCores);
        ctx.addContext("cores.per.executor", coresPerWorker);
        ctx.addContext("MAX_REDUCE_PARTITION_SIZE", maxReduceParSize);
        ExecutionHints hints = ComputeEngineFactory.getInstance().getExecutionHints(ComputeEngineConstants.EngineType.SPARK, ctx);
        int actualCoresRequired = actualNumPars = hints.defaultPartitionCount(estimatedEventCount, 2);
        actualCoresRequired = Math.max(1, actualCoresRequired);
        lowLatencyMode[0] = actualCoresRequired <= totalCoresOnSH;
        logger.debug((Object)String.format("can search execute in low latency mode: %b since actual cores required (huge dataset - don't panic, just pars): %d and total cores on search head: %d", lowLatencyMode[0], actualCoresRequired, totalCoresOnSH));
        int boostedNumPars = hints.defaultPartitionCount(boostedEstimatedEventCount, 2);
        int tasksPerCore = Utils.getTasksPerCore();
        int coresToBeUsed = coresRequired = boostedNumPars / tasksPerCore;
        coresToBeUsed = Math.min(totalCores, coresRequired);
        int numWorkers = (int)Math.ceil((double)coresToBeUsed / (double)coresPerWorker);
        numWorkers = Math.max(1, numWorkers);
        logger.info((Object)String.format("base minimum number of workers required: %d, each with %d cores", numWorkers, coresPerWorker));
        int numWorkersTemp = Math.max(Utils.getMinWorkers(), numWorkers);
        if (numWorkersTemp * coresPerWorker <= totalCores) {
            numWorkers = numWorkersTemp;
            logger.info((Object)String.format("allocating increased workers due to min worker demand: %d", numWorkers));
        } else {
            logger.info((Object)String.format("cannot allocate %d min workers hence going by %d", numWorkersTemp, numWorkers));
        }
        numWorkers = Math.min(Utils.getMaxSupportedWorkers(), numWorkers);
        coresToBeUsed = numWorkers * coresPerWorker;
        logger.info((Object)String.format("number of startup workers: %d, boosted estd event count: %d, worker mem: %d mbs, driver mem: %d mbs, total cores: %d, cores per worker: %d, max reduce par size: %d, boosted num pars: %d, cores to be used: %d", numWorkers, boostedEstimatedEventCount, workerMemMbs, driverMemMbs, totalCores, coresPerWorker, maxReduceParSize, boostedNumPars, coresToBeUsed));
        return numWorkers;
    }

    public static String createScratchDirectory() {
        if (SparkUtils.sparkHome == null) {
            throw new RuntimeException("SPARK_HOME not set.");
        }
        String sparkLocalDir = String.format("%s/dfstmp", SparkUtils.sparkHome);
        File scratchDir = new File(sparkLocalDir);
        if (!scratchDir.exists()) {
            try {
                boolean success = scratchDir.mkdirs();
                if (!success) {
                    throw new RuntimeException(String.format("could not create scratch directory: %s", scratchDir.getAbsolutePath()));
                }
                logger.info((Object)String.format("dfs scratch dir created: %s", scratchDir.getAbsolutePath()));
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("failed to create scratch directory: %s", scratchDir.getAbsolutePath()));
            }
        } else {
            logger.info((Object)String.format("dfc scratch directory already exists: %s", scratchDir.getAbsolutePath()));
        }
        return scratchDir.getAbsolutePath();
    }

    public static int getTasksPerCore() {
        int tasks = 10;
        String tasksStr = System.getenv("TASKS_PER_CORE");
        if (tasksStr != null) {
            try {
                tasks = Integer.parseInt(tasksStr);
                logger.debug((Object)String.format("tasks per core during rdin phase set to: %d based on envvar", tasks));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s not set properly, should be int, but is: %s", "TASKS_PER_CORE", tasksStr));
            }
        }
        logger.debug((Object)String.format("tasks per core set to: %d", tasks));
        return tasks;
    }

    public static int tasksForWorkers(int numWorkers, int coresPerWorker) {
        return numWorkers * coresPerWorker * Utils.getTasksPerCore();
    }

    public static Pair<Integer, Long> getEstimatedEventCount(String splunkConf) {
        JSONObject dfsExecution = new JSONObject(splunkConf).getJSONObject("limits").getJSONObject("dfs");
        long estimatedEventCount = 0L;
        int numIndexServers = 0;
        if (dfsExecution.has("estimatedEventCount")) {
            EstimatedEventCount ec = new EstimatedEventCount(dfsExecution.getJSONArray("estimatedEventCount"));
            estimatedEventCount = ec.getTotalEventCount();
            numIndexServers = ec.getSplunkServerCount();
        }
        logger.info((Object)("Estimated Event Count = " + estimatedEventCount));
        logger.info((Object)String.format("number of index servers: %d", numIndexServers));
        return new Pair<Integer, Long>(numIndexServers, estimatedEventCount);
    }

    public static double getRdinBoost() {
        double boost = 2.0;
        String boostStr = System.getenv("DFS_RDIN_BOOST");
        if (boostStr != null) {
            try {
                boost = Double.valueOf(boostStr);
            }
            catch (Throwable t) {
                logger.info((Object)String.format("rdin boost envvar was invalid: %s, reason: %s, hence the default would be used: %.2f", boostStr, t.getMessage(), boost));
            }
        }
        return boost;
    }

    public static int fractionOfRemainingCores(double remainingCores) {
        double fraction = 0.5;
        String fractionStr = System.getenv("DFS_REMAINING_CORES_FRACTION");
        if (fractionStr != null && !fractionStr.trim().isEmpty()) {
            try {
                fraction = Double.valueOf(fractionStr);
                logger.info((Object)String.format("fraction of remaining cores to use: %.2f set via envvar", fraction));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s value to double (remaining cores fraction)", fractionStr));
            }
        }
        fraction = Math.min(1.0, fraction);
        int coresToUse = (int)(remainingCores * fraction);
        coresToUse = Math.max(1, coresToUse);
        logger.info((Object)String.format("cores to use: %d, remaining cores: %d, fraction: %.2f", coresToUse, (int)remainingCores, fraction));
        return coresToUse;
    }

    public static int getElasticStartNumWorkers() {
        int numWorkers = 1;
        String numWorkersStr = System.getenv("DFS_ELASTIC_START_NUM_WORKERS");
        if (numWorkersStr != null && !numWorkersStr.trim().isEmpty()) {
            try {
                numWorkers = Integer.valueOf(numWorkersStr);
                logger.info((Object)String.format("number of workers to start with in elastic mode set to: %d by envvar", numWorkers));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int: num start workers in elastic mode", numWorkersStr));
            }
        }
        logger.info((Object)String.format("number of workers to start in elastic mode: %d", numWorkers));
        return numWorkers;
    }

    public static int getCoresPerWorker(int hostCores) {
        int maxCoresPerWorker;
        int cores;
        for (cores = maxCoresPerWorker = Utils.getMaxCoresPerWorker(); cores > 1; --cores) {
            if (hostCores % cores != 0) continue;
            logger.info((Object)String.format("host cores: %d is multiple of cores: %d - hence each worker will have %d cores, max worker cores: %d", hostCores, cores, cores, maxCoresPerWorker));
            return cores;
        }
        logger.info((Object)String.format("host cores: %d is not multiple of max cores per worker: %d hence %d is used", hostCores, maxCoresPerWorker, cores));
        return cores;
    }

    public static int getMaxCoresPerWorker() {
        int cores = 4;
        String coresStr = System.getenv("DFS_MAX_CORES_PER_WORKER");
        if (coresStr != null && !coresStr.trim().isEmpty()) {
            try {
                cores = Integer.valueOf(coresStr);
                logger.info((Object)String.format("max cores per worker set to: %d by envvar", cores));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int - max cores per worker", coresStr));
            }
        }
        logger.info((Object)String.format("max cores per worker set to: %d", cores));
        return cores;
    }

    public static boolean isSparseDataset(double currPars, double requiredPars) {
        double ratio = 4.0;
        String ratioStr = System.getenv("DFS_DATASET_SPARSENESS_RATIO");
        if (ratioStr != null && !ratioStr.trim().isEmpty()) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("dataset sparseness ratio set to: %.2f based on envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse dataset sparseness ratio: %s to double value", ratioStr));
            }
        }
        ratio = Math.max(1.0, ratio);
        logger.info((Object)String.format("dataset sparseness ratio set to: %.2f", ratio));
        return requiredPars < currPars / ratio;
    }

    public static int getDfcPortSpan() {
        int span = 4;
        String spanStr = System.getenv("DFS_DFC_PORT_SPAN");
        if (spanStr != null && !spanStr.trim().isEmpty()) {
            try {
                span = Integer.valueOf(spanStr);
                logger.info((Object)String.format("dfc port span set to: %d through envvar", span));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("dfc port span value: %s could not be parsed to int", spanStr));
            }
        }
        logger.info((Object)String.format("dfc port span set to: %d", span));
        return span;
    }

    public static long getMaxLimitRecords() {
        long max = 100000L;
        String maxStr = System.getenv("DFS_MAX_LIMIT_RECORDS");
        if (maxStr != null && !maxStr.trim().isEmpty()) {
            try {
                max = Long.valueOf(maxStr);
                logger.info((Object)String.format("max number of limit records set to: %d via envvar", max));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("max number of limit records: %s could not be parsed to long", maxStr));
            }
        }
        logger.info((Object)String.format("max number of limit records set to: %d", max));
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAll(Object lock) {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public static double getPartitionBoostPostJoin() {
        double boost = 2.0;
        String boostStr = System.getenv("PAR_BOOST_POST_JOIN");
        if (boostStr != null) {
            try {
                boost = Double.valueOf(boostStr);
                logger.info((Object)String.format("partition boost post join overridden by envvar: %.2f", boost));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("partition boost post join could not be parsed as double: %s", boostStr));
            }
        }
        logger.info((Object)String.format("partition boost post join set at: %.2f", boost));
        return boost;
    }

    public static long getMaxSortSeed() {
        long maxSeed = 1000L;
        String maxSeedStr = System.getenv("DFS_MAX_SORT_SEED");
        if (maxSeedStr != null) {
            try {
                maxSeed = Long.valueOf(maxSeedStr);
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max seed envvar: %s, reason: %s", maxSeedStr, t.getMessage()));
            }
        }
        return maxSeed;
    }

    public static String printByFields(IOrdering[] fields) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            IOrdering field = fields[i];
            String fieldName = field.getField().getFieldName();
            SortOrder asc = field.getSortOrder();
            String fieldTxt = String.format("%s (%s)", fieldName, asc.toString());
            sb.append(fieldTxt);
            if (i >= fields.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] data = new byte[4];
        is.read(data);
        return ByteBuffer.wrap(data).getInt();
    }

    public static boolean readBoolean(InputStream is) throws IOException {
        int intVal = Utils.readInt(is);
        if (intVal != 0 && intVal != 1) {
            throw new RuntimeException(String.format("boolean value expected but found: %d", intVal));
        }
        return intVal != 0;
    }

    public static double readDouble(InputStream is) throws IOException {
        byte[] data = new byte[8];
        is.read(data);
        return ByteBuffer.wrap(data).getDouble();
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] data = new byte[8];
        is.read(data);
        return ByteBuffer.wrap(data).getLong();
    }

    public static void write(OutputStream os, long val) throws IOException {
        os.write(ByteBuffer.allocate(8).putLong(val).array());
    }

    public static void write(OutputStream os, int val) throws IOException {
        os.write(ByteBuffer.allocate(4).putInt(val).array());
    }

    public static void write(OutputStream os, String str) throws IOException {
        int strLen = str.length();
        Utils.write(os, strLen);
        os.write(str.getBytes());
    }

    public static void write(OutputStream os, double value) throws IOException {
        os.write(ByteBuffer.allocate(8).putDouble(value).array());
    }

    private static ValueType getValueType(Object value) {
        if (value instanceof String) {
            return ValueType.STRING;
        }
        if (value instanceof Double) {
            return ValueType.DOUBLE;
        }
        throw new RuntimeException(String.format("%s not supported", value.getClass().getName()));
    }

    public static void write(OutputStream os, Object value) throws IOException {
        int valType = Utils.getValueType(value).ordinal();
        Utils.write(os, valType);
        if (valType == ValueType.STRING.ordinal()) {
            Utils.write(os, (String)value);
        } else if (valType == ValueType.DOUBLE.ordinal()) {
            Utils.write(os, (Double)value);
        } else {
            throw new RuntimeException(String.format("%s not supported", value.getClass().getName()));
        }
    }

    public static Object readObject(InputStream is) throws IOException {
        int valType = Utils.readInt(is);
        if (valType == ValueType.STRING.ordinal()) {
            return Utils.readString(is);
        }
        if (valType == ValueType.DOUBLE.ordinal()) {
            return Utils.readDouble(is);
        }
        throw new RuntimeException(String.format("unsupported value type: %d", valType));
    }

    public static String readString(InputStream is) throws IOException {
        int len = Utils.readInt(is);
        byte[] bytes = new byte[len];
        is.read(bytes);
        return new String(bytes);
    }

    public static void write(OutputStream os, boolean value) throws IOException {
        int intVal = value ? 1 : 0;
        Utils.write(os, intVal);
    }

    public static StringBuilder dump(StringBuilder sb, SearchResult sr) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = sr.getDataMap();
        Iterator elems = data.entrySet().iterator();
        sb.append("{");
        while (elems.hasNext()) {
            Map.Entry elem = elems.next();
            SearchResult.FieldMeta field = (SearchResult.FieldMeta)elem.getKey();
            sb.append("\"").append(field.fieldName()).append("\"");
            sb.append(":");
            Object val = elem.getValue();
            Utils.dump(sb, val);
            if (!elems.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb;
    }

    public static String dump(SplunkKVRecord kvrec) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"key\": ");
        sb = Utils.dump(sb, kvrec.getKey());
        sb.append(", \"val\": ");
        sb = Utils.dump(sb, kvrec.getVal());
        sb.append("}");
        return sb.toString();
    }

    public static String dump(SplunkRecord rec) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"val\": ");
        sb = Utils.dump(sb, rec.getVal());
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder dump(StringBuilder sb, Object obj) {
        return sb.append("{ \"class\":\"").append(obj.getClass().getName()).append("\", \"value\":\"").append(obj.toString()).append("\"}");
    }

    public static boolean requireDownProcessing(AggregateFunction func) {
        return func.equals((Object)AggregateFunction.DC) || func.equals((Object)AggregateFunction.DISTINCT_COUNT) || func.equals((Object)AggregateFunction.VALUES);
    }

    public static boolean shrinkPostVolumeReduction(int numPars) {
        boolean always = false;
        String alwaysStr = System.getenv("DFS_ALWAYS_SHRINK_PIPELINE_BEFORE_REDUCE");
        boolean setByEnvvar = false;
        if (alwaysStr != null && !alwaysStr.trim().isEmpty()) {
            try {
                always = Boolean.valueOf(alwaysStr);
                setByEnvvar = true;
            }
            catch (Throwable t) {
                logger.info((Object)String.format("could not parse always shrink before reduce to boolean: %s", alwaysStr));
            }
        }
        logger.info((Object)String.format("always shrink before reduce set to: %b updated through envvar: %b", always, setByEnvvar));
        if (always) {
            return true;
        }
        int shrinkPars = 100000;
        String shrinkParsStr = System.getenv("DFS_BEFORE_REDUCE_SHRINK_PARTITION_COUNT_THRESHOLD");
        if (shrinkParsStr != null && !shrinkParsStr.trim().isEmpty()) {
            try {
                shrinkPars = Integer.valueOf(shrinkParsStr);
                logger.info((Object)String.format("shrink partitions threshold set to: %d based on envvar", shrinkPars));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse shrink partiton count threshold to int: %s", shrinkParsStr));
            }
        }
        logger.info((Object)String.format("shrink partitions threshold set at: %d", shrinkPars));
        if (numPars >= shrinkPars) {
            logger.info((Object)String.format("execution will shrink partitions before reduce since num pars: %d is >= shrink threshold: %d", numPars, shrinkPars));
            return true;
        }
        logger.info((Object)String.format("execution is NOT considered for shrinkage since num pars: %d is < shrink threshold: %d", numPars, shrinkPars));
        return false;
    }

    private static double getPostRdinPartitionCompactionRatio() {
        double ratio = 0.8;
        String ratioStr = System.getenv("DFS_POST_RDIN_PARTITION_COMPACTION_RATIO");
        if (ratioStr != null && !ratioStr.trim().isEmpty()) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("post rdin partition compaction ratio set to: %.2f by envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse post rdin partition compaction ratio to double: %s", ratioStr));
            }
        }
        logger.info((Object)String.format("post rdin partition compaction ratio set to: %.2f", ratio));
        return ratio;
    }

    public static int getMaxShuffleTasksSupported() {
        int max = 150000;
        String maxStr = System.getenv("DFS_MAX_SHUFFLE_TASKS_SUPPORTED");
        if (maxStr != null && !maxStr.trim().isEmpty()) {
            try {
                max = Integer.valueOf(maxStr);
                logger.info((Object)String.format("max shuffle tasks supported set to: %d by envvar", max));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max shuffle tasks supported to int: %s", maxStr));
            }
        }
        logger.info((Object)String.format("max shuffle tasks supported set to: %d", max));
        return max;
    }

    public static int compactPartitions(int numPars) {
        double numParsDbl = numPars;
        numPars = (int)(numParsDbl *= Utils.getPostRdinPartitionCompactionRatio());
        numPars = Math.max(1, numPars);
        numPars = Math.min(numPars, Utils.getMaxShuffleTasksSupported());
        return numPars;
    }

    public static double getJvmStartupRatio() {
        double ratio = 0.4;
        String ratioStr = System.getenv("DFS_JVM_STARTUP_MEM_RATIO");
        if (ratioStr != null && !ratioStr.trim().isEmpty()) {
            try {
                ratio = Double.valueOf(ratioStr);
                if (ratio > 1.0) {
                    ratio = 1.0;
                }
                logger.info((Object)String.format("jvm startup memory ratio set to: %.2f via envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse jvm memory startup ratio to double: %s", ratioStr));
            }
        }
        logger.info((Object)String.format("jvm startup memory ratio set to: %.2f", ratio));
        return ratio;
    }

    public static boolean compactReducePartitions() {
        boolean compact = false;
        String compactStr = System.getenv("DFS_COMPACT_REDUCE_PARTITIONS");
        boolean setViaEnvvar = false;
        if (compactStr != null && !compactStr.trim().isEmpty()) {
            try {
                compact = Boolean.valueOf(compactStr);
                setViaEnvvar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse compact reduce partitions to boolean: %s", compactStr));
            }
        }
        logger.info((Object)String.format("compact reduce partitions set to: %b using envvar: %b", compact, setViaEnvvar));
        return compact;
    }

    public static HashSet<String> getPartitionKeys(RdOutCommand rdoutCmd) {
        String hashKeys = rdoutCmd.getPartitionkeys();
        if (hashKeys == null || hashKeys.trim().isEmpty()) {
            return new HashSet<String>();
        }
        String[] keys = hashKeys.split(",");
        int len = keys.length;
        HashSet<String> unique = new HashSet<String>();
        for (int i = 0; i < len; ++i) {
            String key = keys[i];
            if (key == null || key.trim().isEmpty()) continue;
            unique.add(key);
        }
        logger.info((Object)String.format("unique partitioning hash keys found in rdout command: %s, size: %d", unique.toString(), unique.size()));
        return unique;
    }

    public static boolean isInternalFieldToSuppress(boolean retainMVFields, SearchResult.FieldMeta field) {
        return field != null && field.length() != 0 && field.charAt(0) == '_' && (!retainMVFields || field.fieldName() == null || field.length() < 4 || !field.fieldName().startsWith("__mv_")) || field != null && field.fieldName() != null && (field.fieldName().startsWith("prestats_reserved_*") || field.fieldName().startsWith("psrsvd_*"));
    }

    public static File getSparkExecutorLogFile() {
        File logDirectory = new File(System.getProperty("DISPATCH_DIR"), SparkEnv.get().executorId());
        return new File(logDirectory, "dfs.log");
    }

    private static enum ValueType {
        STRING,
        INTEGER,
        DOUBLE,
        LONG;

    }
}

