/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;

public class EstimateQuantileValue
extends BaseAggregateValue {
    private static final long serialVersionUID = 1L;
    private ByteBuffer digestBytes;

    public EstimateQuantileValue() {
        TDigest digestQuantile = TDigest.createMergingDigest((double)100.0);
        this.digestBytes = ByteBuffer.allocate(digestQuantile.smallByteSize());
        digestQuantile.asSmallBytes(this.digestBytes);
    }

    @Override
    public AggregateValue accumulate(Object item) {
        assert (item instanceof ByteBuffer);
        this.doAccumulation((ByteBuffer)item);
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue value) {
        assert (value instanceof EstimateQuantileValue);
        this.doAccumulation((ByteBuffer)value.getValue());
        return this;
    }

    @Override
    public Object getValue() {
        return this.digestBytes;
    }

    public Double getQuantile(Double quantile) {
        MergingDigest digestQuantile = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(this.digestBytes.array()));
        return digestQuantile.quantile(quantile.doubleValue());
    }

    private void doAccumulation(ByteBuffer byteBuffer) {
        MergingDigest tmpDigest = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(byteBuffer.array()));
        MergingDigest digestQuantile = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(this.digestBytes.array()));
        digestQuantile.add((TDigest)tmpDigest);
        this.digestBytes = ByteBuffer.allocate(digestQuantile.smallByteSize());
        digestQuantile.asSmallBytes(this.digestBytes);
    }
}

