/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.df.search.compute.ComputeEngineConstants;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExternalCommandMetadataRegistry
implements Serializable,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(ExternalCommandMetadataRegistry.class);
    private static final long serialVersionUID = 1L;
    private HashMap<String, ExternalCommandMetadata> registry = new HashMap();

    public void addMetadata(String commandName, ExternalCommandMetadata metadata) {
        this.registry.put(commandName, metadata);
    }

    public ExternalCommandMetadata getMetdata(String commandName) {
        return this.registry.get(commandName);
    }

    public static class JavaJarExternalCommandMetadata
    extends ExternalCommandMetadata {
        private static final long serialVersionUID = 1L;

        public JavaJarExternalCommandMetadata(String commandName, String jarName, String jarPath, String clazz) {
            super(jarName, jarPath, commandName, clazz);
        }

        public String toString() {
            return String.format("type: jar, command: %s, jar: %s, class: %s", this.getCommandName(), this.getLibFilePath(), this.getClassName());
        }
    }

    public static abstract class ExternalCommandMetadata
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String commandName;
        private String clazz;
        private String libFileName;
        private String libFilePath;

        ExternalCommandMetadata(String libFileName, String libFilePath, String name, String clazz) {
            this.commandName = name;
            this.clazz = clazz;
            this.libFileName = libFileName;
            this.libFilePath = libFilePath;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String getLibFileName() {
            return this.libFileName;
        }

        public String getLibFilePath() {
            return this.libFilePath;
        }

        public void setLibFilePath(String path) {
            logger.debug((Object)String.format("Set path for file: %s -> %s", this.libFileName, path));
            this.libFilePath = path;
        }
    }
}

