/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class FSHSerializableJobsInfo
implements Serializable {
    static final Logger logger = Logger.getLogger(FSHSerializableJobsInfo.class);
    private HashMap<String, HashMap<String, ArrayList<String>>> fshJobsMapInfo = null;
    private HashMap<String, String> fshDatasetToInfo = null;

    public FSHSerializableJobsInfo(HashMap<String, HashMap<String, ArrayList<String>>> fshJobsMapInfo, HashMap<String, String> fshDatasetToInfo) {
        this.fshJobsMapInfo = fshJobsMapInfo;
        this.fshDatasetToInfo = fshDatasetToInfo;
    }

    public String getFederatedSearchInfo(String triggerSid) {
        return this.fshDatasetToInfo.get(triggerSid);
    }

    public Iterator getIterator() {
        return this.fshJobsMapInfo.entrySet().iterator();
    }

    public void dumpFSHSerializableInfo() {
        StringBuilder sb = new StringBuilder();
        Iterator fshMapIterator = this.getIterator();
        while (fshMapIterator.hasNext()) {
            Map.Entry fshIterator = (Map.Entry)fshMapIterator.next();
            sb.append(String.format("Dataset Name=%s\n", fshIterator.getKey()));
            for (Map.Entry entry : ((HashMap)fshIterator.getValue()).entrySet()) {
                sb.append(String.format("\t Base sid=%s\n", entry.getKey()));
                for (int i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                    sb.append(String.format("\t\t search=%s\n", ((ArrayList)entry.getValue()).get(i)));
                }
                sb.append(String.format("\t\tScaled FSH Info==>%s\n", this.fshDatasetToInfo.get(entry.getKey())));
            }
            sb.append("\n\n");
            sb.append("-----------------------------------------------------------------\n");
        }
        sb.append("-----------------------------------------------------------------\n");
        logger.info((Object)("FSH Serialized Jobs Map Info===>\n" + sb.toString()));
        sb.append("-----------------------------------------------------------------\n");
        logger.info((Object)String.format("FSH Serializable Jobs Map Info===>\n%s\n", sb.toString()));
    }
}

