/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSSearchConstants;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Deprecated
public class DFCLauncher
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFCLauncher.class);
    private Process dfcProc;
    private String dfcCmd;

    public DFCLauncher(int numCores, int numExecutors, String executorMem, String driverMem, String dfsComputeHost, int dfsComputePort, String dfcMainClass, String dfsJar, List<String> paramsArray) {
        ArrayList<String> dfcProcArgs = new ArrayList<String>();
        dfcProcArgs.add("spark-submit");
        dfcProcArgs.add("--conf");
        dfcProcArgs.add("spark.network.timeout=10000s");
        dfcProcArgs.add("--conf");
        dfcProcArgs.add("spark.driver.extraJavaOptions=-XX:+CMSClassUnloadingEnabled");
        dfcProcArgs.add("--conf");
        dfcProcArgs.add("spark.executor.extraJavaOptions=-XX:+UseCompressedOops -XX:+CMSClassUnloadingEnabled");
        dfcProcArgs.add("--total-executor-cores");
        dfcProcArgs.add(String.valueOf(numCores));
        dfcProcArgs.add("--num-executors");
        dfcProcArgs.add(String.valueOf(numExecutors));
        dfcProcArgs.add("--executor-cores");
        int executorCores = numCores / numExecutors;
        if (executorCores < 1) {
            executorCores = 1;
        }
        dfcProcArgs.add(String.valueOf(executorCores));
        dfcProcArgs.add("--executor-memory");
        dfcProcArgs.add(executorMem);
        dfcProcArgs.add("--driver-memory");
        dfcProcArgs.add(driverMem);
        dfcProcArgs.add("--master");
        dfcProcArgs.add(String.format("spark://%s:%d", dfsComputeHost, dfsComputePort));
        dfcProcArgs.add("--class");
        dfcProcArgs.add(dfcMainClass);
        dfcProcArgs.add("--jars");
        String dfsRoot = System.getenv("DFS_HOME");
        dfcProcArgs.add(String.format("%s/libs/commons-csv-1.3.jar,%s/libs/felix.jar,%s/libs/splunk-sdk-java-1.5.0.jar", dfsRoot, dfsRoot, dfsRoot));
        dfcProcArgs.add(String.format("%s/libs/%s", dfsRoot, dfsJar));
        dfcProcArgs.addAll(paramsArray);
        try {
            this.dfcProc = new ProcessBuilder(dfcProcArgs).start();
            this.dfcCmd = StringUtils.join(dfcProcArgs, (String)" ");
            logger.error((Object)String.format("^^^^^^ launched dfc using cmd: %s", this.dfcCmd));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Process getDfcProc() {
        return this.dfcProc;
    }

    public static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public void finalize() {
        try {
            if (DFCLauncher.isAlive(this.dfcProc)) {
                this.dfcProc.destroy();
                logger.error((Object)String.format("destroyed dfc process since dfc launcher is getting garbage collected", this.dfcCmd));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void destroyDfc() {
        try {
            if (DFCLauncher.isAlive(this.dfcProc)) {
                this.dfcProc.destroy();
                logger.error((Object)String.format("destroyed dfc process as requested by the caller", this.dfcCmd));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

