/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.CommitListener;
import com.splunk.collect.EventWriter;
import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongList;

public abstract class AbstractEventWriter
implements EventWriter {
    private static final Logger gLogger = Logger.getLogger(AbstractEventWriter.class);
    protected long _lastCommitTime = 0L;
    protected long _lastCommitEventCount = 0L;
    protected long _lastAddEventTime = 0L;
    protected long _eventCount = 0L;
    protected long _rawByteCount = 0L;
    protected LongArrayList _uncommitedEventIds = null;
    protected LongArrayList _commitedEventIds = null;
    protected ArrayList<CommitListener> _commitListeners = null;
    protected int _autoCommitEventCount = 0;
    protected int _autoCommitTimeMs = 0;

    public AbstractEventWriter(boolean trackEventIds) {
        if (trackEventIds) {
            this._uncommitedEventIds = new LongArrayList(500);
            this._commitedEventIds = new LongArrayList(500);
        }
    }

    public void setAutoCommitBehavior(int autoCommitEventCount, int autoCommitTimeMs) {
        this._autoCommitEventCount = autoCommitEventCount;
        this._autoCommitTimeMs = autoCommitTimeMs;
    }

    public void addCommitListener(CommitListener listener) {
        if (null == this._commitListeners) {
            this._commitListeners = new ArrayList();
        }
        this._commitListeners.add(listener);
    }

    @Override
    public final long getLastAddEventTime() {
        return this._lastAddEventTime;
    }

    @Override
    public final long getLastCommitTime() {
        return this._lastCommitTime;
    }

    @Override
    public final long getEventCount() {
        return this._eventCount;
    }

    @Override
    public final long getRawEventBytes() {
        return this._rawByteCount;
    }

    @Override
    public void commit() {
        gLogger.debug((Object)("About to commit events. Current event count=" + this._eventCount));
        if (this._lastCommitEventCount == this._eventCount) {
            this._lastCommitTime = System.currentTimeMillis();
            return;
        }
        this.commitImpl();
        if (this._uncommitedEventIds != null) {
            this._commitedEventIds.addAll((LongList)this._uncommitedEventIds);
            this._uncommitedEventIds.clear();
        }
        if (this._commitListeners != null) {
            long[] ids = this.getCommitedEventIds();
            if (null == ids) {
                gLogger.debug((Object)"Commit triggered but no IDs to ACK. Skipping notification of listeners.");
            } else {
                for (CommitListener listener : this._commitListeners) {
                    if (gLogger.isDebugEnabled()) {
                        gLogger.debug((Object)("Notifying listener of class " + listener.getClass().getCanonicalName()));
                    }
                    try {
                        listener.commitCompleted(ids);
                    }
                    catch (IOException ex) {
                        gLogger.error((Object)"Problem while acknowledging committed events", (Throwable)ex);
                    }
                }
            }
        }
        this._lastCommitTime = System.currentTimeMillis();
        this._lastCommitEventCount = this._eventCount;
    }

    @Override
    public final void addEvent(Event e) throws IOException {
        if (e.getRaw() == null || e.getRaw().empty()) {
            return;
        }
        if (e.getChannel() == null) {
            return;
        }
        this._lastAddEventTime = System.currentTimeMillis();
        if (e.hasAckId() && this._uncommitedEventIds != null) {
            this._uncommitedEventIds.add(e.getAckEventId());
        }
        if (e.getRaw() != null) {
            this._rawByteCount += (long)e.getRaw().size();
        }
        this.addEventImpl(e);
        ++this._eventCount;
        if (this._autoCommitEventCount > 0 && this._autoCommitTimeMs > 0 && this._uncommitedEventIds != null && this._uncommitedEventIds.size() > this._autoCommitEventCount && System.currentTimeMillis() - this._lastCommitTime > (long)this._autoCommitTimeMs) {
            this.commit();
        }
    }

    @Override
    public final long[] getCommitedEventIds() {
        if (this._commitedEventIds == null) {
            return null;
        }
        long[] result = this._commitedEventIds.toLongArray();
        this._commitedEventIds.clear();
        return result;
    }

    @Override
    public void gotDropChannel(Channel c) {
    }

    protected abstract void commitImpl();

    protected abstract void addEventImpl(Event var1) throws IOException;
}

