/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandSourceKind;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.visitors.NodeVisitor;

public class ReverseRenameVisitor
extends NodeVisitor<Node> {
    private final RenameNode[] renames;

    public ReverseRenameVisitor(RenameNode[] renames) {
        this.renames = renames;
    }

    @Override
    public Node visit(Node node) {
        return node;
    }

    @Override
    public Node visit(FieldNode node) {
        for (RenameNode rename : this.renames) {
            if (rename.getNewFieldName().equals(node.getFieldName())) {
                return rename.getField();
            }
            if (!rename.getFieldName().equals("*") || !rename.getNewFieldName().endsWith("*")) continue;
            String prefix = rename.getNewFieldName().replace("*", "");
            return new FieldNode(node.getFieldName().substring(prefix.length()));
        }
        return node;
    }

    @Override
    public Node visit(ComparisonNode node) {
        return new ComparisonNode(node.getOperator(), (TypeNode)node.getLhs().accept(this), (TypeNode)node.getRhs().accept(this));
    }

    @Override
    public Node visit(FunctionNode node) {
        TypeNode[] args = new TypeNode[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (TypeNode)node.getArguments().get(i).accept(this);
        }
        return new FunctionNode(node.getFunctionName(), args);
    }

    @Override
    public Node visit(AndNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (IWherePredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new AndNode(args);
    }

    @Override
    public Node visit(OrNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (IWherePredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new OrNode(args);
    }

    @Override
    public Node visit(XorNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (IWherePredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new XorNode(args);
    }

    @Override
    public Node visit(SearchAndNode node) {
        ISearchPredicate[] args = new ISearchPredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (ISearchPredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new SearchAndNode(args);
    }

    @Override
    public Node visit(SearchComparisonNode node) {
        return new SearchComparisonNode(node.getOperator(), (FieldNode)node.getLhs().accept(this), node.getRhs(), node.is_negated(), node.is_lhs_quoted(), node.is_rhs_quoted(), node.is_indexed(), node.getModifier());
    }

    @Override
    public Node visit(SearchOrNode node) {
        ISearchPredicate[] args = new ISearchPredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (ISearchPredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new SearchOrNode(args);
    }

    @Override
    public Node visit(SearchXorNode node) {
        ISearchPredicate[] args = new ISearchPredicate[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (ISearchPredicate)((Object)node.getArguments().get(i).accept(this));
        }
        return new SearchXorNode(args);
    }

    @Override
    public Node visit(SearchFunctionNode node) {
        return (Node)super.visit(node);
    }

    @Override
    public Node visit(SearchCommand node) {
        if (node.getCommandSourceKind() == CommandSourceKind.GENERATING) {
            return new SearchCommand((IPredicate)((Object)node.getPredicate().getNode().accept(this)));
        }
        return new SearchCommand((CommandNode)node.getSource().accept(this), (IPredicate)((Object)node.getPredicate().getNode().accept(this)));
    }
}

