/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.TStatsCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.visitors.ComparableStringVisitor;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class NormalizingVisitor
extends NodeVisitor<Node> {
    private final ComparableStringVisitor comparer = new ComparableStringVisitor();

    @Override
    public Node visit(Node node) {
        return node;
    }

    @Override
    public Node visit(ComparisonNode node) {
        if (this.comparer.reorderRequired(node.getLhs(), node.getRhs())) {
            return new ComparisonNode(node.getOperator().reverse(), node.getRhs(), node.getLhs());
        }
        return node;
    }

    @Override
    public CommandNode visit(CommandNode node) {
        CommandNode[] visitedSources = new CommandNode[node.getSources().length];
        for (int i = 0; i < visitedSources.length; ++i) {
            visitedSources[i] = (CommandNode)node.getSources()[i].accept(this);
        }
        if (visitedSources.length == 0) {
            return node;
        }
        if (visitedSources.length == 1) {
            return node.setSource(visitedSources[0]);
        }
        return node.setSources(visitedSources);
    }

    @Override
    public Node visit(InputlookupCommand node) {
        ISearchPredicate predicate = node.getWhere();
        if (node.isGenerating() && predicate == null) {
            return node;
        }
        if (predicate != null) {
            predicate = (ISearchPredicate)((Object)predicate.getNode().accept(this));
        }
        if (node.isGenerating()) {
            return new InputlookupCommand(node.getLookupName(), predicate, node.getStart(), node.getMax());
        }
        return new InputlookupCommand((CommandNode)node.getSource().accept(this), node.getLookupName(), predicate, node.getStart(), node.getMax());
    }

    @Override
    public Node visit(TStatsCommand node) {
        ISearchPredicate predicate = (ISearchPredicate)node.getPredicate();
        if (node.isGenerating() && predicate == null) {
            return node;
        }
        if (predicate != null) {
            predicate = (ISearchPredicate)((Object)predicate.getNode().accept(this));
        }
        if (node.isGenerating()) {
            return new TStatsCommand(node.getAggregates(), node.getByFields(), predicate, node.getNamespace(), node.getOptions());
        }
        return new TStatsCommand((CommandNode)node.getSource().accept(this), node.getAggregates(), node.getByFields(), predicate, node.getNamespace(), node.getOptions());
    }

    @Override
    public Node visit(SearchCommand node) {
        ISearchPredicate visited = (ISearchPredicate)((Object)node.getPredicate().getNode().accept(this));
        if (node.isGenerating()) {
            return new SearchCommand(visited);
        }
        return new SearchCommand((CommandNode)node.getSource().accept(this), visited);
    }

    @Override
    public Node visit(WhereCommand node) {
        return new WhereCommand((CommandNode)node.getSource().accept(this), (IPredicate)((Object)node.getPredicate().getNode().accept(this)));
    }

    @Override
    public Node visit(SearchOrNode node) {
        return new SearchOrNode(NormalizingVisitor.asSearchPredicates(this.reorder(this.visitAll(node.getArguments()))));
    }

    @Override
    public Node visit(SearchXorNode node) {
        return new SearchXorNode(NormalizingVisitor.asSearchPredicates(this.reorder(this.visitAll(node.getArguments()))));
    }

    @Override
    public Node visit(SearchAndNode node) {
        return new SearchAndNode(NormalizingVisitor.asSearchPredicates(this.reorder(this.visitAll(node.getArguments()))));
    }

    @Override
    public Node visit(AndNode node) {
        return new AndNode(NormalizingVisitor.asPredicates(this.reorder(this.visitAll(node.getArguments()))));
    }

    @Override
    public Node visit(OrNode node) {
        return new OrNode(NormalizingVisitor.asPredicates(this.reorder(this.visitAll(node.getArguments()))));
    }

    @Override
    public Node visit(XorNode node) {
        return new XorNode(NormalizingVisitor.asPredicates(this.reorder(this.visitAll(node.getArguments()))));
    }

    private Node[] visitAll(Node[] nodes) {
        return this.visitAll(Arrays.asList(nodes));
    }

    private <T extends Node> Node[] visitAll(List<T> nodes) {
        Node[] translated = new Node[nodes.size()];
        for (int i = 0; i < translated.length; ++i) {
            translated[i] = ((Node)nodes.get(i)).accept(this);
        }
        return translated;
    }

    private Node[] reorder(Node[] args) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        Object[] compares = new String[args.length];
        for (int i = 0; i < compares.length; ++i) {
            Node arg = args[i];
            String compareString = arg.accept(this.comparer);
            compares[i] = compareString;
            map.put(compareString, arg);
        }
        Arrays.sort(compares);
        Node[] newArgs = new Node[compares.length];
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = (Node)map.get(compares[i]);
        }
        return newArgs;
    }

    private static IWherePredicate[] asPredicates(Node[] args) {
        IWherePredicate[] predicates = new IWherePredicate[args.length];
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = (IWherePredicate)((Object)args[i]);
        }
        return predicates;
    }

    private static ISearchPredicate[] asSearchPredicates(Node[] args) {
        ISearchPredicate[] predicates = new ISearchPredicate[args.length];
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = (ISearchPredicate)((Object)args[i]);
        }
        return predicates;
    }
}

