/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.RepresentativeRow;
import com.splunk.commons.Row;
import com.splunk.commons.Unknown;
import com.splunk.commons.ast.matchers.CidrMatcher;
import com.splunk.commons.ast.matchers.IMatcher;
import com.splunk.commons.ast.matchers.NumberMatcher;
import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.MultiValueNode;
import com.splunk.commons.ast.nodes.expressions.NullNode;
import com.splunk.commons.ast.nodes.expressions.Number;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.util.StringUtils;
import com.splunk.commons.visitors.NodeVisitor;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.util.SubnetUtils;

public class ExpressionEvaluator
extends NodeVisitor<Object>
implements Serializable {
    private Row currentRow;
    private boolean fillNull = false;

    public Object evaluate(Node node) {
        return this.evaluate(node, null);
    }

    public Object evaluate(Node node, Row row) {
        this.currentRow = row;
        return node.accept(this);
    }

    public Object evaluate(Node node, Row row, boolean fillNull) {
        Object result;
        this.currentRow = row;
        this.fillNull = fillNull;
        try {
            result = node.accept(this);
            if (result == null) {
                result = fillNull;
            }
        }
        catch (Exception e) {
            result = fillNull;
        }
        return result;
    }

    public Row getRow() {
        return this.currentRow;
    }

    @Override
    public Object visit(Node node) {
        throw new UnsupportedOperationException(String.format("Node of type %1$s not supported in evaluator", node.getClass().toString()));
    }

    @Override
    public Object visit(AndNode node) {
        boolean result = true;
        for (TypeNode typeNode : node.getArguments()) {
            try {
                result = (Boolean)typeNode.accept(this);
            }
            catch (Exception e) {
                result = false;
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object visit(OrNode node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            boolean result = false;
            try {
                result = (Boolean)node.getArguments().get(i).accept(this);
            }
            catch (Exception e) {
                continue;
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(XorNode node) {
        boolean preResult;
        try {
            preResult = (Boolean)node.getArguments().get(0).accept(this);
        }
        catch (Exception e) {
            preResult = false;
        }
        for (int i = 1; i < node.getArguments().size(); ++i) {
            boolean result;
            try {
                result = (Boolean)node.getArguments().get(i).accept(this);
            }
            catch (Exception e) {
                result = false;
            }
            preResult = result != preResult;
        }
        return preResult;
    }

    @Override
    public Object visit(FunctionNode node) {
        Object[] args = new Object[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = node.getArguments().get(i).accept(this);
        }
        switch (FunctionNode.FunctionName.lookup(node.getFunctionName())) {
            case abs: {
                return ExpressionEvaluator.abs(args[0]);
            }
            case ceil: 
            case ceiling: {
                return ExpressionEvaluator.ceiling(args[0]);
            }
            case exact: {
                return ExpressionEvaluator.exact(args[0]);
            }
            case exp: {
                return ExpressionEvaluator.exp(args[0]);
            }
            case floor: {
                return ExpressionEvaluator.floor(args[0]);
            }
            case ln: {
                return ExpressionEvaluator.ln(args[0]);
            }
            case log: {
                return ExpressionEvaluator.log(args);
            }
            case pi: {
                return 3.14159265358;
            }
            case pow: {
                return ExpressionEvaluator.pow(args[0], args[1]);
            }
            case round: {
                return ExpressionEvaluator.round(args);
            }
            case sqrt: {
                return ExpressionEvaluator.sqrt(args[0]);
            }
            case caseF: {
                return ExpressionEvaluator.caseF(args);
            }
            case coalesce: {
                return ExpressionEvaluator.coalesce(args);
            }
            case ifF: {
                return ExpressionEvaluator.ifF(args);
            }
            case nullF: {
                return null;
            }
            case nullif: {
                return ExpressionEvaluator.nullif(args[0], args[1]);
            }
            case validate: {
                return ExpressionEvaluator.validate(args);
            }
            case typeof: {
                return args[0] == null ? "Invalid" : ExpressionEvaluator.typeof(args[0]);
            }
            case len: {
                return args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[] ? null : Integer.valueOf(args[0].toString().length());
            }
            case lower: {
                return ExpressionEvaluator.lower(args[0]);
            }
            case substr: {
                return ExpressionEvaluator.substr(args);
            }
            case upper: {
                return ExpressionEvaluator.upper(args[0]);
            }
            case urldecode: {
                return ExpressionEvaluator.urldecode(args[0]);
            }
            case split: {
                return ExpressionEvaluator.split(args);
            }
            case tonumber: {
                return ExpressionEvaluator.tonumber(args);
            }
            case tostring: {
                return ExpressionEvaluator.tostring(args);
            }
            case add: {
                return ExpressionEvaluator.add(args[0], args[1]);
            }
            case subtract: {
                return ExpressionEvaluator.subtract(args[0], args[1]);
            }
            case multiply: {
                return ExpressionEvaluator.multiply(args[0], args[1]);
            }
            case divide: {
                return ExpressionEvaluator.divide(args[0], args[1]);
            }
            case modulo: {
                return ExpressionEvaluator.modulo(args[0], args[1]);
            }
            case concat: {
                return ExpressionEvaluator.concat(args[0], args[1]);
            }
            case eval: {
                return node.getArguments().get(0).accept(this);
            }
        }
        throw new UnsupportedOperationException(String.format("Function %1$s not implemented.", node.getFunctionName()));
    }

    @Override
    public Object visit(MultiValueNode node) {
        StringNode[] stringNodes = node.getValue();
        int len = stringNodes.length;
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = stringNodes[i].getValue();
        }
        return result;
    }

    @Override
    public Object visit(BooleanFunctionNode node) {
        Object[] args = new Object[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = node.getArguments().get(i).accept(this);
        }
        switch (FunctionNode.FunctionName.lookup(node.getFunctionName())) {
            case cidrmatch: {
                return ExpressionEvaluator.cidrMatch(args);
            }
            case falseF: {
                return false;
            }
            case in: {
                return ExpressionEvaluator.in(args);
            }
            case like: {
                return ExpressionEvaluator.like(args[0], args[1]);
            }
            case match: {
                return ExpressionEvaluator.match(args[0], args[1]);
            }
            case searchmatch: {
                return args[0];
            }
            case trueF: {
                return true;
            }
            case isbool: {
                return args[0] == null ? false : args[0].getClass() == Boolean.class;
            }
            case isint: {
                return ExpressionEvaluator.isint(args[0]);
            }
            case isnotnull: {
                return args[0] != null;
            }
            case isnull: {
                return args[0] == null;
            }
            case isnum: {
                return args[0] == null ? false : ExpressionEvaluator.isnum(args[0].toString());
            }
            case isstr: {
                return args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[] ? false : !ExpressionEvaluator.isnum(args[0].toString());
            }
        }
        throw new UnsupportedOperationException(String.format("Function %1$s not implemented.", node.getFunctionName()));
    }

    @Override
    public Object visit(ComparisonNode node) {
        Object lhs = node.getLhs().accept(this);
        Object rhs = node.getRhs().accept(this);
        return ExpressionEvaluator.compare(node.getOperator(), lhs, rhs, this.fillNull);
    }

    @Override
    public Object visit(FieldNode node) {
        this.assertHasRow();
        if (this.currentRow.containsKey(node.getFieldName())) {
            return this.currentRow.get(node.getFieldName());
        }
        if (this.currentRow instanceof RepresentativeRow && this.currentRow.containsKey("*")) {
            return Unknown.VALUE;
        }
        return null;
    }

    @Override
    public Object visit(StringNode node) {
        return node.getValue();
    }

    @Override
    public Object visit(SearchQuotableNode node) {
        this.assertHasRow();
        boolean match = false;
        if (this.currentRow.containsKey("_raw")) {
            if (this.currentRow instanceof RepresentativeRow && this.currentRow.get("_raw") == Unknown.VALUE) {
                match = true;
            } else {
                String raw = (String)this.currentRow.get("_raw");
                match = ((TermMatcher)node.getMatcher()).match(raw);
            }
        } else if (this.currentRow instanceof RepresentativeRow && this.currentRow.containsKey("*")) {
            match = true;
        }
        if (node.is_negated()) {
            return !match;
        }
        return match;
    }

    @Override
    public Object visit(SearchAndNode node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            boolean result;
            try {
                result = (Boolean)node.getArguments().get(i).accept(this);
            }
            catch (Exception e) {
                result = false;
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object visit(SearchOrNode node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            boolean result;
            try {
                result = (Boolean)node.getArguments().get(i).accept(this);
            }
            catch (Exception e) {
                continue;
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(SearchXorNode node) {
        boolean preResult;
        try {
            preResult = (Boolean)node.getArguments().get(0).accept(this);
        }
        catch (Exception e) {
            preResult = false;
        }
        for (int i = 1; i < node.getArguments().size(); ++i) {
            boolean result;
            try {
                result = (Boolean)node.getArguments().get(i).accept(this);
            }
            catch (Exception e) {
                result = false;
            }
            preResult = result != preResult;
        }
        return preResult;
    }

    @Override
    public Object visit(SearchComparisonNode node) {
        boolean match;
        block16: {
            block14: {
                TypeNode rhs;
                Object value;
                block18: {
                    block17: {
                        block15: {
                            this.assertHasRow();
                            match = false;
                            String fieldName = node.getLhs().getFieldName();
                            if (!this.currentRow.containsKey(fieldName)) break block14;
                            value = this.currentRow.get(fieldName);
                            rhs = node.getRhs();
                            if (value != Unknown.VALUE || !(this.currentRow instanceof RepresentativeRow)) break block15;
                            match = true;
                            break block16;
                        }
                        if (value != null) break block17;
                        match = false;
                        break block16;
                    }
                    if (!(rhs instanceof StringNode)) break block18;
                    String source = value.toString();
                    IMatcher matcher = node.getMatcher();
                    switch (node.getOperator()) {
                        case EQUAL: 
                        case NOT_EQUAL: 
                        case EQUAL_EQUAL: {
                            boolean bl = match = matcher instanceof CidrMatcher ? ((CidrMatcher)matcher).match(source) : ((TermMatcher)matcher).match(source);
                            if (node.getOperator() == Operator.NOT_EQUAL) {
                                match = !match;
                                break;
                            }
                            break block16;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Operator %1$s not supported", node.getOperator().toSplOperator()));
                        }
                    }
                    break block16;
                }
                if (rhs instanceof NumberNode && Number.isNumeric(value)) {
                    try {
                        match = (Boolean)((NumberMatcher)node.getMatcher()).match(value);
                    }
                    catch (Exception e) {
                        return null;
                    }
                } else if (rhs instanceof NumberNode) {
                    try {
                        match = (Boolean)ExpressionEvaluator.compareNumbers(node.getOperator(), value, ((NumberNode)rhs).getValue());
                    }
                    catch (Exception e) {
                        return null;
                    }
                } else {
                    match = rhs instanceof BooleanNode && value instanceof Boolean ? ExpressionEvaluator.compareBooleans(node.getOperator(), (Boolean)value, ((BooleanNode)rhs).getValue()) : node.getOperator() == Operator.NOT_EQUAL;
                }
                break block16;
            }
            if (this.currentRow instanceof RepresentativeRow && this.currentRow.containsKey("*")) {
                match = true;
            }
        }
        if (node.is_negated()) {
            return !match;
        }
        return match;
    }

    @Override
    public Object visit(SearchSubSearchPredicateNode node) {
        throw new UnsupportedOperationException("Evaluating Subsearch predicate expressions it not supported.");
    }

    @Override
    public Object visit(BooleanNode node) {
        return node.getValue();
    }

    @Override
    public Object visit(NullNode node) {
        return NullNode.getValue();
    }

    @Override
    public Object visit(NumberNode node) {
        return node.getValue();
    }

    private static Object compare(Operator operator, Object lhs, Object rhs, boolean fillNull) {
        if (lhs == null || rhs == null) {
            return fillNull;
        }
        if (lhs == Unknown.VALUE || rhs == Unknown.VALUE) {
            return true;
        }
        if (Number.isNumeric(lhs) || Number.isNumeric(rhs)) {
            return ExpressionEvaluator.compareNumbers(operator, lhs, rhs);
        }
        if (lhs instanceof String || rhs instanceof String) {
            return ExpressionEvaluator.compareStrings(operator, lhs.toString(), rhs.toString());
        }
        if (lhs instanceof Boolean && rhs instanceof Boolean) {
            return ExpressionEvaluator.compareBooleans(operator, (Boolean)lhs, (Boolean)rhs);
        }
        return false;
    }

    private static boolean compareBooleans(Operator operator, Boolean lhs, Boolean rhs) {
        switch (operator) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                return lhs.equals(rhs);
            }
            case NOT_EQUAL: {
                return !lhs.equals(rhs);
            }
        }
        throw new UnsupportedOperationException(String.format("Operator %1$s not supported for boolean comparisons.", operator.toSplOperator()));
    }

    private static boolean compareStrings(Operator operator, String lhs, String rhs) {
        switch (operator) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                return lhs.equals(rhs);
            }
            case NOT_EQUAL: {
                return !lhs.equals(rhs);
            }
            case GREATER_THAN: {
                return lhs.compareTo(rhs) > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return lhs.compareTo(rhs) >= 0;
            }
            case LESS_THAN: {
                return lhs.compareTo(rhs) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return lhs.compareTo(rhs) <= 0;
            }
        }
        throw new UnsupportedOperationException(String.format("Operator %1$s not supported for string comparisons.", operator.toSplOperator()));
    }

    private static Object compareNumbers(Operator operator, Object lhs, Object rhs) {
        switch (operator) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                return Number.equal(lhs, rhs);
            }
            case NOT_EQUAL: {
                return Number.notEqual(lhs, rhs);
            }
            case GREATER_THAN: {
                return Number.greaterThan(lhs, rhs);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Number.greaterThanEqual(lhs, rhs);
            }
            case LESS_THAN: {
                return Number.lessThan(lhs, rhs);
            }
            case LESS_THAN_OR_EQUAL: {
                return Number.lessThanEqual(lhs, rhs);
            }
        }
        throw new UnsupportedOperationException(String.format("Operator %1$s not supported for numeric comparisons.", operator.toSplOperator()));
    }

    private void assertHasRow() {
        if (this.currentRow == null) {
            throw new IllegalStateException("Need a row to evaluate.");
        }
    }

    private static boolean cidrMatch(Object[] args) {
        boolean retValue;
        if (args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[] || args[1] == null || args[1] instanceof Boolean || args[1] instanceof Object[]) {
            return false;
        }
        try {
            SubnetUtils utils = new SubnetUtils(args[0].toString());
            utils.setInclusiveHostCount(true);
            retValue = utils.getInfo().isInRange(args[1].toString());
        }
        catch (Exception e) {
            retValue = false;
        }
        return retValue;
    }

    private static boolean like(Object value, Object pattern) {
        if (value == null || value instanceof Boolean || value instanceof Object[]) {
            return false;
        }
        if (pattern == null || !(pattern instanceof String)) {
            return false;
        }
        TermMatcher matcher = new TermMatcher(pattern.toString(), FunctionNode.FunctionName.like);
        return matcher.match(value.toString());
    }

    private static Object tostring(Object[] args) {
        if (args.length == 1) {
            if (args[0] == null) {
                return "Null";
            }
            if (args[0] instanceof Boolean) {
                if (args[0].equals(true)) {
                    return "True";
                }
                if (args[0].equals(false)) {
                    return "False";
                }
            }
            if (args[0] instanceof Object[]) {
                StringBuilder sb = new StringBuilder();
                String prefix = "";
                for (Object val : (Object[])args[0]) {
                    sb.append(prefix);
                    prefix = " ";
                    if (val == null) {
                        sb.append("Null");
                        continue;
                    }
                    sb.append(val.toString());
                }
                return sb.toString();
            }
            return args[0].toString();
        }
        if (args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[]) {
            return null;
        }
        if (args[1] == null || args[1] instanceof Boolean || args[1] instanceof Object[]) {
            return null;
        }
        String format = args[1].toString();
        if (format.equalsIgnoreCase("hex")) {
            return ExpressionEvaluator.toStringHex(args[0]);
        }
        if (format.equalsIgnoreCase("commas")) {
            return ExpressionEvaluator.toStringCommas(args[0]);
        }
        if (format.equalsIgnoreCase("duration")) {
            return ExpressionEvaluator.toStringDuration(args[0]);
        }
        return null;
    }

    private static String toStringDuration(Object arg0) {
        BigDecimal numValue;
        try {
            numValue = new BigDecimal(arg0.toString());
        }
        catch (Exception e) {
            return null;
        }
        if (numValue.compareTo(BigDecimal.ZERO) == -1) {
            return null;
        }
        BigDecimal[] bigRet = numValue.divideAndRemainder(new BigDecimal(60));
        String seconds = bigRet[1].toPlainString();
        long newVal = bigRet[0].longValue();
        if (seconds.length() == 1) {
            seconds = "0" + seconds;
        }
        int count = 1;
        int minutes = 0;
        int hours = 0;
        int days = 0;
        while (newVal > 0L) {
            if (++count == 4) {
                if (newVal > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("The first argument is out of range");
                }
                days = (int)newVal;
                break;
            }
            if (count == 2) {
                minutes = (int)(newVal % 60L);
                newVal /= 60L;
            }
            if (count != 3) continue;
            hours = (int)(newVal % 24L);
            newVal /= 24L;
        }
        if (count == 4) {
            return String.format("%d+%02d:%02d:", days, hours, minutes) + seconds;
        }
        return String.format("%02d:%02d:", hours, minutes) + seconds;
    }

    private static String toStringCommas(Object arg0) {
        BigDecimal bdValue;
        try {
            bdValue = new BigDecimal(arg0.toString());
        }
        catch (Exception e) {
            return null;
        }
        BigDecimal[] commasRet = bdValue.divideAndRemainder(BigDecimal.ONE);
        String remainderPart = "";
        if (commasRet[1].compareTo(BigDecimal.ZERO) != 0) {
            bdValue = bdValue.setScale(2, 4);
            commasRet = bdValue.divideAndRemainder(BigDecimal.ONE);
            remainderPart = commasRet[1].toPlainString().substring(1);
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        return decimalFormat.format(commasRet[0]) + remainderPart;
    }

    private static String toStringHex(Object arg0) {
        Double numValue;
        try {
            numValue = Double.parseDouble(arg0.toString());
        }
        catch (Exception e) {
            return null;
        }
        if (numValue % 1.0 > 0.0) {
            return null;
        }
        if (numValue <= 9.223372036854776E18) {
            long val = numValue.longValue();
            return "0x" + Long.toHexString(val).toUpperCase();
        }
        return null;
    }

    private static Object log(Object[] args) {
        double logResult;
        double num;
        if (args[0] == null) {
            return null;
        }
        try {
            num = Double.parseDouble(args[0].toString());
            if (num <= 0.0) {
                return null;
            }
            if (ExpressionEvaluator.isInfOrNaN(num)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (args.length == 1) {
            logResult = Math.log10(num);
        } else {
            double base;
            if (args[1] == null) {
                return null;
            }
            try {
                base = Double.parseDouble(args[1].toString());
            }
            catch (Exception e) {
                return null;
            }
            if (base <= 0.0) {
                throw new IllegalArgumentException("The base for Function log should be larger than 0");
            }
            logResult = Math.log(num) / Math.log(base);
        }
        return logResult;
    }

    private static Object substr(Object[] args) {
        int start;
        if (args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[] || args[1] == null) {
            return null;
        }
        String value = args[0].toString();
        int valLen = value.length();
        try {
            start = new Integer(args[1].toString());
        }
        catch (NumberFormatException e) {
            start = new BigDecimal(args[1].toString()).intValueExact();
        }
        int end = valLen;
        if (start < 0) {
            start = valLen + start;
        } else {
            int n = start = start == 0 ? start : start - 1;
        }
        if (start < 0 || start > valLen) {
            return null;
        }
        if (args.length == 3 && args[2] != null) {
            int len;
            try {
                len = new Integer(args[2].toString());
            }
            catch (NumberFormatException e) {
                len = new BigDecimal(args[2].toString()).intValueExact();
            }
            if (len < 0) {
                return null;
            }
            end = start + len;
            if (end > valLen) {
                end = valLen;
            }
        }
        if (start <= end) {
            return value.substring(start, end);
        }
        return null;
    }

    private static Object sqrt(Object arg) {
        if (arg == null) {
            return null;
        }
        try {
            double num = Double.parseDouble(arg.toString());
            if (num < 0.0) {
                return null;
            }
            return ExpressionEvaluator.isInfOrNaN(num) ? null : Double.valueOf(Math.sqrt(num));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object abs(Object arg) {
        if (arg == null) {
            return null;
        }
        try {
            double num = Double.parseDouble(arg.toString());
            return ExpressionEvaluator.isInfOrNaN(num) ? null : Double.valueOf(Math.abs(num));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object pow(Object arg0, Object arg1) {
        if (arg0 == null || arg1 == null) {
            return null;
        }
        try {
            double num0 = Double.parseDouble(arg0.toString());
            double num1 = Double.parseDouble(arg1.toString());
            return ExpressionEvaluator.isInfOrNaN(num0) || ExpressionEvaluator.isInfOrNaN(num1) ? null : Double.valueOf(Math.pow(num0, num1));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object exp(Object arg) {
        if (arg == null) {
            return null;
        }
        try {
            double num = Double.parseDouble(arg.toString());
            return ExpressionEvaluator.isInfOrNaN(num) ? null : Double.valueOf(Math.exp(num));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object exact(Object arg) {
        if (arg == null) {
            return null;
        }
        String str = arg.toString();
        if (str.equals("Infinity") || str.equals("-Infinity")) {
            return str;
        }
        try {
            return new BigDecimal(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object ln(Object arg) {
        if (arg == null) {
            return null;
        }
        try {
            Double num = Double.parseDouble(arg.toString());
            if (num <= 0.0) {
                return null;
            }
            return ExpressionEvaluator.isInfOrNaN(num) ? null : Double.valueOf(Math.log(num));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isnum(String argStr) {
        try {
            double numVal = Double.parseDouble(argStr);
            if (Double.isInfinite(numVal)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String typeof(Object arg) {
        if (arg instanceof Boolean) {
            return "Bool";
        }
        if (arg instanceof Object[]) {
            return "Multivalue";
        }
        return ExpressionEvaluator.isnum(arg.toString()) ? "Number" : "String";
    }

    private static Object floor(Object arg) {
        double num;
        if (arg == null) {
            return null;
        }
        try {
            num = Double.parseDouble(arg.toString());
        }
        catch (Exception e) {
            return null;
        }
        if (num <= 9.223372036854776E18) {
            return (long)Math.floor(num);
        }
        try {
            BigDecimal bdnum = new BigDecimal(arg.toString());
            return bdnum.setScale(0, 3);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean in(Object[] args) {
        int size = args.length;
        String[] types = new String[size];
        if (args[0] == null) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            types[i] = args[i] == null ? "Invalid" : ExpressionEvaluator.typeof(args[i]);
        }
        String curType = types[0];
        block13: for (int i = 1; i < size; ++i) {
            if (types[i] != curType) continue;
            switch (curType) {
                case "Number": {
                    if (!((Boolean)Number.equal(args[0], args[i])).booleanValue()) continue block13;
                    return true;
                }
                case "String": {
                    if (!args[0].toString().equals(args[i].toString())) continue block13;
                    return true;
                }
                case "Bool": {
                    if (!args[0].equals(args[i])) continue block13;
                    return true;
                }
                case "Multivalue": {
                    if (!Arrays.equals((Object[])args[0], (Object[])args[1])) continue block13;
                    return true;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Type %1$s is not supported.", curType));
                }
            }
        }
        return false;
    }

    private static Object ceiling(Object arg) {
        double num;
        if (arg == null) {
            return null;
        }
        try {
            num = Double.parseDouble(arg.toString());
        }
        catch (Exception e) {
            return null;
        }
        if (num <= 9.223372036854776E18) {
            return (long)Math.ceil(num);
        }
        try {
            BigDecimal bdnum = new BigDecimal(arg.toString());
            return bdnum.setScale(0, 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object add(Object arg0, Object arg1) {
        if (arg0 == null || arg0 instanceof Boolean || arg0 instanceof Object[] || arg1 == null || arg1 instanceof Boolean || arg1 instanceof Object[]) {
            return null;
        }
        try {
            return Number.add(arg0, arg1);
        }
        catch (Exception e) {
            return new StringBuffer(arg0.toString()).append(arg1.toString()).toString();
        }
    }

    private static Object subtract(Object arg0, Object arg1) {
        Object subtractResult;
        if (arg0 == null || arg0 instanceof Boolean || arg0 instanceof Object[] || arg1 == null || arg1 instanceof Boolean || arg1 instanceof Object[]) {
            return null;
        }
        try {
            subtractResult = Number.subtract(arg0, arg1);
        }
        catch (Exception e) {
            return null;
        }
        return subtractResult;
    }

    private static Object multiply(Object arg0, Object arg1) {
        Object multiResult;
        if (arg0 == null || arg0 instanceof Boolean || arg0 instanceof Object[] || arg1 == null || arg1 instanceof Boolean || arg1 instanceof Object[]) {
            return null;
        }
        try {
            multiResult = Number.multiply(arg0, arg1);
        }
        catch (Exception e) {
            return null;
        }
        return multiResult;
    }

    private static Object divide(Object arg0, Object arg1) {
        Object divresult;
        if (arg0 == null || arg0 instanceof Boolean || arg0 instanceof Object[] || arg1 == null || arg1 instanceof Boolean || arg1 instanceof Object[]) {
            return null;
        }
        try {
            divresult = Number.divide(arg0, arg1);
            if (ExpressionEvaluator.isInfOrNaN(divresult)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return divresult;
    }

    private static Object modulo(Object arg0, Object arg1) {
        Object moduloresult;
        if (arg0 == null || arg0 instanceof Boolean || arg0 instanceof Object[] || arg1 == null || arg1 instanceof Boolean || arg1 instanceof Object[]) {
            return null;
        }
        try {
            moduloresult = Number.modulo(arg0, arg1);
            if (ExpressionEvaluator.isInfOrNaN(moduloresult)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return moduloresult;
    }

    private static Object concat(Object arg0, Object arg1) {
        if (arg0 == null || arg0 instanceof Boolean || arg0 instanceof Object[] || arg1 == null || arg1 instanceof Boolean || arg1 instanceof Object[]) {
            return null;
        }
        return arg0.toString() + arg1.toString();
    }

    private static Object caseF(Object[] args) {
        int caseLen = args.length;
        for (int i = 0; i < caseLen; i += 2) {
            boolean caseResult;
            try {
                if (args[i] == null) {
                    args[i] = false;
                }
                caseResult = (Boolean)args[i];
            }
            catch (Exception e) {
                return null;
            }
            if (!caseResult) continue;
            return args[i + 1];
        }
        return null;
    }

    private static Object nullif(Object arg0, Object arg1) {
        String type1;
        if (arg0 == null || arg1 == null) {
            return arg0;
        }
        String type0 = ExpressionEvaluator.typeof(arg0);
        if (type0.equals(type1 = ExpressionEvaluator.typeof(arg1))) {
            switch (type0) {
                case "Number": {
                    if (!((Boolean)Number.equal(arg0, arg1)).booleanValue()) break;
                    return null;
                }
                case "String": {
                    if (!arg0.toString().equals(arg1.toString())) break;
                    return null;
                }
                case "Bool": {
                    if (!arg0.equals(arg1)) break;
                    return null;
                }
                case "Multivalue": {
                    if (!Arrays.equals((Object[])arg0, (Object[])arg1)) break;
                    return null;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Type %1$s is not supported.", type0));
                }
            }
        }
        return arg0;
    }

    private static Object urldecode(Object arg) {
        if (arg == null || arg instanceof Boolean || arg instanceof Object[]) {
            return null;
        }
        String value = arg.toString();
        boolean matchSplunkd = true;
        if (matchSplunkd) {
            try {
                return ExpressionEvaluator.urldecodeHelper(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String urldecodeHelper(String s) {
        if (s.indexOf(37) == -1 && s.indexOf(43) == -1) {
            return s;
        }
        int i = 0;
        StringBuffer sb = new StringBuffer();
        block4: while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    continue block4;
                }
                case '%': {
                    if (i + 2 < s.length()) {
                        char first = Character.toLowerCase(s.charAt(i + 1));
                        char second = Character.toLowerCase(s.charAt(i + 2));
                        if (ExpressionEvaluator.validChar(first) && ExpressionEvaluator.validChar(second)) {
                            sb.append((char)(ExpressionEvaluator.decodeValue(first) * 16 + ExpressionEvaluator.decodeValue(second)));
                            i += 3;
                            continue block4;
                        }
                    }
                    sb.append('%');
                    ++i;
                    continue block4;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private static boolean validChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f';
    }

    private static int decodeValue(char c) {
        return c >= '0' && c <= '9' ? c - 48 : c - 97 + 10;
    }

    private static Object tonumber(Object[] args) {
        if (args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[]) {
            return null;
        }
        int base = 10;
        if (args.length == 2) {
            if (args[1] == null || args[1] instanceof Boolean || args[1] instanceof Object[]) {
                return null;
            }
            try {
                base = Integer.parseInt(args[1].toString());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (base == 10) {
            BigDecimal number;
            try {
                number = new BigDecimal(args[0].toString());
            }
            catch (Exception e) {
                return null;
            }
            return number.toPlainString();
        }
        String numStr = args[0].toString();
        int lenStr = numStr.length();
        if (base == 16) {
            int i = 0;
            if (numStr.charAt(i) == '-' || numStr.charAt(i) == '+') {
                ++i;
            }
            if (i + 2 <= lenStr && numStr.charAt(i) == '0' && Character.toLowerCase(numStr.charAt(i + 1)) == 'x') {
                return Long.decode(numStr);
            }
        }
        return Long.parseLong(numStr, base);
    }

    private static Object round(Object[] args) {
        if (args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[]) {
            return null;
        }
        if (args.length == 2) {
            int decimalPlaces;
            if (args[1] == null || args[1] instanceof Boolean || args[1] instanceof Object[]) {
                return null;
            }
            try {
                decimalPlaces = new Integer(args[1].toString());
            }
            catch (NumberFormatException e) {
                decimalPlaces = new BigDecimal(args[1].toString()).intValueExact();
            }
            if (decimalPlaces > 100 || decimalPlaces < 0) {
                throw new IllegalArgumentException("The second argument for Function round should be positive and less than 101.");
            }
            BigDecimal bdValue = new BigDecimal(args[0].toString());
            return bdValue.setScale(decimalPlaces, 4);
        }
        double numVal = Double.parseDouble(args[0].toString());
        if (numVal <= 9.223372036854776E18) {
            return Math.round(numVal);
        }
        BigDecimal bdValue = new BigDecimal(args[0].toString());
        return bdValue.setScale(0, 4);
    }

    private static Object validate(Object[] args) {
        int size = args.length;
        for (int i = 0; i < size; i += 2) {
            boolean validateResult;
            try {
                if (args[i] == null) {
                    args[i] = false;
                }
                validateResult = (Boolean)args[i];
            }
            catch (Exception e) {
                return null;
            }
            if (validateResult) continue;
            return args[i + 1];
        }
        return null;
    }

    private static Object coalesce(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            return args[i];
        }
        return null;
    }

    private static Object split(Object[] args) {
        if (args[0] == null || args[0] instanceof Boolean || args[0] instanceof Object[] || args[1] == null || args[1] instanceof Boolean || args[1] instanceof Object[]) {
            return null;
        }
        String value = args[0].toString();
        if (value.length() == 0) {
            return null;
        }
        return value.split(StringUtils.escapeMetaCharacters(args[1].toString()), 0);
    }

    private static Object ifF(Object[] args) {
        boolean result;
        try {
            if (args[0] == null) {
                args[0] = false;
            }
            result = (Boolean)args[0];
        }
        catch (Exception e) {
            return null;
        }
        return result ? args[1] : args[2];
    }

    private static boolean isint(Object arg) {
        if (arg == null) {
            return false;
        }
        String intStr = arg.toString();
        if (intStr == null || intStr.length() == 0) {
            return false;
        }
        boolean hasFlag = false;
        int strLen = intStr.length();
        for (int i = 0; i < strLen; ++i) {
            if (intStr.charAt(i) == '-' || intStr.charAt(i) == '+') {
                if (i != 0 || i == strLen - 1) {
                    return false;
                }
                hasFlag = true;
                continue;
            }
            if (Character.isDigit(intStr.charAt(i))) continue;
            return false;
        }
        return (!hasFlag || strLen <= 309) && (hasFlag || strLen <= 308);
    }

    private static Object match(Object arg0, Object arg1) {
        if (arg0 == null || arg0 instanceof Boolean || arg0 instanceof Object[] || arg1 == null || arg1 instanceof Boolean || arg1 instanceof Object[]) {
            return false;
        }
        String value = arg0.toString();
        StringBuilder regex = new StringBuilder();
        regex.append(".*");
        regex.append(arg1.toString());
        regex.append(".*");
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    private static Object lower(Object arg) {
        if (arg == null || arg instanceof Boolean) {
            return null;
        }
        if (arg instanceof Object[]) {
            Object[] elements = (Object[])arg;
            Object[] result = new Object[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                result[i] = elements[i] == null || elements[i] instanceof Boolean || elements[i] instanceof Object[] ? null : elements[i].toString().toLowerCase();
            }
            return result;
        }
        return arg.toString().toLowerCase();
    }

    private static Object upper(Object arg) {
        if (arg == null || arg instanceof Boolean) {
            return null;
        }
        if (arg instanceof Object[]) {
            Object[] elements = (Object[])arg;
            Object[] result = new Object[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                result[i] = elements[i] == null || elements[i] instanceof Boolean || elements[i] instanceof Object[] ? null : elements[i].toString().toUpperCase();
            }
            return result;
        }
        return arg.toString().toUpperCase();
    }

    private static boolean isInfOrNaN(Object num) {
        if (num instanceof Double && (Double.isInfinite((Double)num) || Double.isNaN((Double)num))) {
            return true;
        }
        return num instanceof Float && (Float.isInfinite(((Float)num).floatValue()) || Float.isNaN(((Float)num).floatValue()));
    }
}

