/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

public enum Operator {
    EQUAL("="),
    EQUAL_EQUAL("=="),
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUAL(">="),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUAL("<="),
    NOT_EQUAL("!=");

    private final String symbol;

    private Operator(String symbol) {
        this.symbol = symbol;
    }

    public static Operator load(String operator) {
        for (Operator op : Operator.values()) {
            if (!op.equals(operator)) continue;
            return op;
        }
        throw new IllegalArgumentException("invalid operator: " + operator);
    }

    public boolean equals(String operator) {
        return this.symbol.equals(operator);
    }

    public String toString() {
        return this.symbol;
    }

    public String toSplOperator() {
        return this.toString();
    }

    public Operator reverse() {
        switch (this) {
            case EQUAL: {
                return EQUAL;
            }
            case NOT_EQUAL: {
                return NOT_EQUAL;
            }
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException("invalid Operator: " + ((Object)((Object)this)).getClass().getName());
    }
}

