/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;

public class UnionCommand
extends CommandNode {
    private String extras = "";
    private final IOrdering[] sortByFields = new IOrdering[]{new SortNode("_time", SortOrder.DESC)};
    private final Map.Entry<String, String>[] options;

    public UnionCommand(CommandNode lhs, CommandNode rhs) {
        this(new CommandNode[]{lhs, rhs});
    }

    public UnionCommand(CommandNode[] sources) {
        this(sources, null);
    }

    public UnionCommand(CommandNode[] sources, Map.Entry<String, String>[] options) {
        super(UnionCommand.flatten(sources), "union", CommandType.SP_STREAM, new FieldProperties[0]);
        UnionCommand.assertTrue("Union needs at least 2 sources.", sources.length >= 2);
        this.options = options;
    }

    private static CommandNode[] flatten(CommandNode[] commands) {
        ArrayList<CommandNode> flattened = new ArrayList<CommandNode>();
        for (CommandNode node : commands) {
            if (node instanceof UnionCommand) {
                flattened.addAll(Arrays.asList(UnionCommand.flatten((UnionCommand)node)));
                continue;
            }
            if (node instanceof FromCommand && ((FromCommand)node).supportsShorthand() && node.getDataset() instanceof TransientDataset && ((TransientDataset)node.getDataset()).getSource() instanceof UnionCommand) {
                flattened.addAll(Arrays.asList(UnionCommand.flatten((UnionCommand)((TransientDataset)node.getDataset()).getSource())));
                continue;
            }
            flattened.add(node);
        }
        CommandNode[] empty = new CommandNode[flattened.size()];
        return flattened.toArray(empty);
    }

    private static CommandNode[] flatten(UnionCommand command) {
        LinkedHashSet<CommandNode> flattened = new LinkedHashSet<CommandNode>(Arrays.asList(UnionCommand.flatten(command.getSources())));
        CommandNode[] empty = new CommandNode[flattened.size()];
        return flattened.toArray(empty);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSources(CommandNode[] sources) {
        return new UnionCommand(sources);
    }

    private boolean streaming() {
        return this.getPipeline() == CommandType.SP_STREAM;
    }

    public void setExtras(String val) {
        if (val == null) {
            return;
        }
        this.extras = val;
    }

    public IOrdering[] getSortByFields() {
        IOrdering[] fields = new IOrdering[]{};
        if (this.sort()) {
            fields = this.sortByFields;
        }
        return fields;
    }

    public boolean sort() {
        return this.streaming() && this.extras.contains("sort");
    }

    public boolean coalesce() {
        return this.extras.contains("coalesce");
    }

    public boolean custom() {
        return this.extras.contains("custom");
    }

    public boolean cursored() {
        return this.extras.contains("cursor");
    }

    public boolean repartition() {
        return this.extras.contains("repartition");
    }

    public Map.Entry<String, String>[] getOptions() {
        return this.options;
    }
}

