/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Arrays;

public class RenameCommand
extends CommandNode {
    private final RenameNode[] renames;

    public RenameCommand(CommandNode source, RenameNode[] renames) throws IllegalArgumentException {
        super(source, "rename", CommandType.SP_STREAM, new FieldsAndProperties().rename(renames).array());
        if (renames == null) {
            throw new IllegalArgumentException("RenameNode[] renames cannot be null");
        }
        RenameNode[] filteredRenames = (RenameNode[])Arrays.stream(renames).filter(rename -> !rename.getFieldName().equals(rename.getNewFieldName())).toArray(RenameNode[]::new);
        this.setFieldPropertiesArray(new FieldsAndProperties().rename(filteredRenames).array());
        this.renames = filteredRenames;
    }

    public RenameNode[] getRenames() {
        return this.renames;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new RenameCommand(source, this.renames);
    }
}

