/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;

public class FieldsCommand
extends CommandNode {
    private final boolean removeFields;
    private final FieldNode[] fields;
    private final boolean keepColumnOrder;

    public FieldsCommand(CommandNode source, FieldNode[] fields) {
        this(source, fields, false, false);
    }

    public FieldsCommand(CommandNode source, FieldNode[] fields, boolean removeFields) {
        this(source, fields, removeFields, false);
    }

    public FieldsCommand(CommandNode source, FieldNode[] fields, boolean removeFields, boolean keepColumnOrder) {
        super(source, "fields", CommandType.SP_STREAM, new FieldsAndProperties().fields(fields, removeFields).array());
        this.fields = fields == null ? new FieldNode[]{} : fields;
        this.removeFields = removeFields;
        this.keepColumnOrder = keepColumnOrder;
        FieldsCommand.assertTrue(!removeFields || fields.length > 0);
    }

    public boolean isRemoveFields() {
        return this.removeFields;
    }

    public boolean isInKeepMentionedFieldsMode() {
        return !this.removeFields;
    }

    public boolean isKeepColumnOrder() {
        return this.keepColumnOrder;
    }

    public FieldNode[] getFields() {
        return this.fields;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new FieldsCommand(source, this.fields, this.removeFields, this.keepColumnOrder);
    }
}

