/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;

public class SerDeUtil {
    public static void buildJSONString(JsonGenerator jg, StructObjectInspector oi, Object row, Map<Integer, Map> readColumnIds) throws JsonGenerationException, IOException {
        List fieldRefs = oi.getAllStructFieldRefs();
        jg.writeStartObject();
        if (readColumnIds == null) {
            for (StructField fieldRef : fieldRefs) {
                String fieldName = fieldRef.getFieldName();
                jg.writeFieldName(fieldName);
                Object fieldData = oi.getStructFieldData(row, fieldRef);
                ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                SerDeUtil.buildJSONString(jg, true, fieldData, fieldOI, fieldName, null);
            }
        } else {
            for (Map.Entry<Integer, Map> e : readColumnIds.entrySet()) {
                String fieldName = ((StructField)fieldRefs.get(e.getKey())).getFieldName();
                jg.writeFieldName(fieldName);
                Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(e.getKey()));
                ObjectInspector fieldOI = ((StructField)fieldRefs.get(e.getKey())).getFieldObjectInspector();
                SerDeUtil.buildJSONString(jg, true, fieldData, fieldOI, fieldName, e.getValue());
            }
        }
        jg.writeEndObject();
    }

    private static Object buildJSONString(JsonGenerator jg, boolean serialize, Object o, ObjectInspector oi, String fieldName, Map readFieldIds) throws JsonProcessingException, IOException {
        if (o == null) {
            if (serialize) {
                jg.writeNull();
            }
            return null;
        }
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                String s;
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                o = poi.getPrimitiveJavaObject(o);
                if (o instanceof String && (s = (String)o).startsWith("\"") && s.endsWith("\"") && s.length() > 2) {
                    s = s.substring(1, s.length() - 1);
                    o = s;
                }
                if (serialize) {
                    try {
                        jg.writeObject(o);
                    }
                    catch (Exception exc) {
                        jg.writeObject((Object)o.toString());
                    }
                    break;
                }
                return o;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                ObjectInspector listElementObjectInspector = loi.getListElementObjectInspector();
                List olist = loi.getList(o);
                if (olist == null) break;
                if (serialize) {
                    jg.writeStartArray();
                    for (int i = 0; i < olist.size(); ++i) {
                        SerDeUtil.buildJSONString(jg, serialize, olist.get(i), listElementObjectInspector, fieldName, readFieldIds);
                    }
                    jg.writeEndArray();
                    break;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < olist.size(); ++i) {
                    list.add(SerDeUtil.buildJSONString(jg, serialize, olist.get(i), listElementObjectInspector, fieldName, readFieldIds));
                }
                return list;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector mapKeyObjectInspector = moi.getMapKeyObjectInspector();
                ObjectInspector mapValueObjectInspector = moi.getMapValueObjectInspector();
                Map omap = moi.getMap(o);
                if (omap == null) break;
                if (serialize) {
                    jg.writeStartObject();
                    Iterator i = omap.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry;
                        Map.Entry e = entry = i.next();
                        o = SerDeUtil.buildJSONString(jg, false, e.getKey(), mapKeyObjectInspector, fieldName, readFieldIds);
                        jg.writeFieldName(String.valueOf(o));
                        SerDeUtil.buildJSONString(jg, serialize, e.getValue(), mapValueObjectInspector, fieldName, readFieldIds);
                    }
                    jg.writeEndObject();
                    break;
                }
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                Iterator iterator = omap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry e = entry = iterator.next();
                    Object k = SerDeUtil.buildJSONString(jg, serialize, e.getKey(), mapKeyObjectInspector, fieldName, readFieldIds);
                    Object v = SerDeUtil.buildJSONString(jg, serialize, e.getValue(), mapValueObjectInspector, fieldName, readFieldIds);
                    map.put(k, v);
                }
                return map;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List structFields = soi.getAllStructFieldRefs();
                if (readFieldIds == null || readFieldIds.size() == structFields.size() || readFieldIds.isEmpty()) {
                    if (serialize) {
                        jg.writeStartObject();
                        for (StructField sf : structFields) {
                            jg.writeFieldName(sf.getFieldName());
                            SerDeUtil.buildJSONString(jg, serialize, soi.getStructFieldData(o, sf), sf.getFieldObjectInspector(), fieldName, null);
                        }
                        jg.writeEndObject();
                        break;
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (StructField sf : structFields) {
                        String k = sf.getFieldName();
                        Object v = SerDeUtil.buildJSONString(jg, serialize, soi.getStructFieldData(o, sf), sf.getFieldObjectInspector(), fieldName, null);
                        map.put(k, v);
                    }
                    return map;
                }
                if (serialize) {
                    jg.writeStartObject();
                    for (Map.Entry e : readFieldIds.entrySet()) {
                        jg.writeFieldName(((StructField)structFields.get((Integer)e.getKey())).getFieldName());
                        SerDeUtil.buildJSONString(jg, serialize, soi.getStructFieldData(o, (StructField)structFields.get((Integer)e.getKey())), ((StructField)structFields.get((Integer)e.getKey())).getFieldObjectInspector(), fieldName, (Map)e.getValue());
                    }
                    jg.writeEndObject();
                    break;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry e : readFieldIds.entrySet()) {
                    String k = ((StructField)structFields.get((Integer)e.getKey())).getFieldName();
                    Object v = SerDeUtil.buildJSONString(jg, serialize, soi.getStructFieldData(o, (StructField)structFields.get((Integer)e.getKey())), ((StructField)structFields.get((Integer)e.getKey())).getFieldObjectInspector(), fieldName, (Map)e.getValue());
                    map.put(k, v);
                }
                return map;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                byte tag = uoi.getTag(o);
                ObjectInspector foi = (ObjectInspector)uoi.getObjectInspectors().get(tag);
                if (readFieldIds != null) {
                    readFieldIds = (Map)readFieldIds.get(tag);
                }
                if (serialize) {
                    jg.writeStartObject();
                    jg.writeFieldName(String.valueOf(tag));
                    SerDeUtil.buildJSONString(jg, serialize, uoi.getField(o), foi, fieldName, readFieldIds);
                    jg.writeEndObject();
                    break;
                }
                HashMap<Integer, Object> map = new HashMap<Integer, Object>();
                map.put(Integer.valueOf(tag), SerDeUtil.buildJSONString(jg, serialize, uoi.getField(o), foi, fieldName, readFieldIds));
                return map;
            }
            default: {
                throw new RuntimeException("Unknown ObjectInspector category!");
            }
        }
        return null;
    }
}

