/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

public class DoubleWithSigFigsAndPrecision
extends Number {
    double value;
    int sigfigs;
    int precision;

    public DoubleWithSigFigsAndPrecision(double value, int sigfigs, int precision) {
        this.value = value;
        this.sigfigs = sigfigs;
        this.precision = precision;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    private int numDigitsLeftOfDot() {
        if (this.value == 0.0) {
            return 1;
        }
        return (int)Math.log10((long)this.value) + 1;
    }

    public String toString() {
        if (Double.isNaN(this.value)) {
            return Double.toString(this.value);
        }
        if (this.precision == Integer.MAX_VALUE || this.sigfigs == Integer.MAX_VALUE) {
            boolean showAsLong;
            boolean bl = showAsLong = this.value == Math.floor(this.value);
            if (showAsLong) {
                return Long.toString((long)this.value);
            }
            return Double.toString(this.value);
        }
        int numWholeDigits = this.numDigitsLeftOfDot();
        int sigFigsToDisplay = Math.max(numWholeDigits, this.sigfigs);
        double rounded = this.roundOffTo(this.value, sigFigsToDisplay - numWholeDigits);
        return String.format("%" + sigFigsToDisplay + "." + this.precision + "f", rounded).trim();
    }

    private double roundOffTo(double exact, int maxDigitsRightOfDot) {
        double shifter = Math.pow(10.0, maxDigitsRightOfDot);
        double shifted = exact * shifter;
        double rounded = Math.floor(shifted) / shifter;
        return rounded;
    }
}

