/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.fs.FSUtil;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.CleanupMapper;
import com.splunk.mr.CommandHandler;
import com.splunk.mr.PrivilegedCommandHandlerAction;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.packaging.CountingTempFileProvider;
import com.splunk.mr.packaging.IncrementFileCountWhenFileIsStale;
import com.splunk.mr.packaging.SplunkManifestPackager;
import com.splunk.mr.packaging.SynchronizedExecuter;
import com.splunk.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class SetupCommandHandler
implements CommandHandler {
    private static Logger gLogger = Logger.getLogger(SetupCommandHandler.class);
    public static final String INSTALLED_SUFFIX = ".installed";

    public static Path getHDFSSplunkPackages(Configuration conf) {
        return new Path(SplunkMR.getHDFSSplunkHome(conf), "packages");
    }

    public static void copyLocalFileToHdfsWithFailureMessage(Configuration conf, File localFile, Path remoteFile, SearchOutputStream out, String failureMessage) throws IOException {
        String message = failureMessage + " Local file=" + localFile + ", to remote file=" + remoteFile;
        try {
            if (SetupCommandHandler.copyLocalFileToHdfs(conf, localFile, remoteFile, out) != 0) {
                throw new IOException(message);
            }
        }
        catch (IOException e) {
            throw new IOException(message + ", cause=" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int copyLocalFileToHdfs(Configuration conf, File localFile, Path remoteFile, SearchOutputStream out) throws IOException {
        HashMap<String, Object> response;
        int rv = -2;
        String message = "null";
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path remoteDir = remoteFile.getParent();
            if (fs.exists(remoteFile)) {
                message = "Remote package already exists: uri=" + remoteFile.toUri();
                rv = 0;
            } else {
                gLogger.info((Object)String.format("Copying src=%s to dst=%s", localFile, remoteFile.toUri()));
                Path remoteTmpFile = fs.makeQualified(new Path(remoteDir, localFile.getName() + "." + new Random().nextInt(1234567) + ".tmp"));
                long elapsed = System.currentTimeMillis();
                try {
                    FileUtil.copy((File)localFile, (FileSystem)fs, (Path)remoteTmpFile, (boolean)false, (Configuration)conf);
                    fs.rename(remoteTmpFile, remoteFile);
                    elapsed = System.currentTimeMillis() - elapsed;
                    message = String.format("Copied src=%s, dst=%s, size=%d, elapsed_ms=%d", localFile, remoteFile, localFile.length(), elapsed);
                    rv = 0;
                }
                catch (IOException e) {
                    fs.delete(remoteTmpFile, false);
                    throw e;
                }
            }
            response = new HashMap<String, Object>();
            out.setStreamType("response");
            response.put("status", rv == 0 ? "success" : "failed");
        }
        catch (IOException e) {
            try {
                message = e.getMessage();
                gLogger.error((Object)message, (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HashMap<String, Object> response2 = new HashMap<String, Object>();
                out.setStreamType("response");
                response2.put("status", rv == 0 ? "success" : "failed");
                response2.put("message", message);
                try {
                    out.addHeader(response2);
                    out.writeHeader();
                    throw throwable;
                }
                catch (Exception e2) {
                    gLogger.error((Object)message, (Throwable)e2);
                }
                throw throwable;
            }
        }
        response.put("message", message);
        try {
            out.addHeader(response);
            out.writeHeader();
            return rv;
        }
        catch (Exception e) {
            gLogger.error((Object)message, (Throwable)e);
            return rv;
        }
    }

    @Override
    public void execute(Configuration conf, Map<String, Object> args, SearchOutputStream out) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        File localFile = new File(conf.get(SplunkMR.CONF_SETUP_PACKAGE));
        if (!localFile.exists()) {
            this.createLocalPackageIfConfiguredToDoSo(conf, localFile);
        }
        if (!localFile.exists()) {
            throw new IOException(String.format("Local Hunk package does not exist, path=%s", localFile) + ".");
        }
        Path remoteDir = SetupCommandHandler.getHDFSSplunkPackages(conf);
        Path remoteFile = fs.makeQualified(new Path(remoteDir, localFile.getName()));
        SetupCommandHandler.copyLocalFileToHdfsWithFailureMessage(conf, localFile, remoteFile, out, "Hunk setup failed to copy package to HDFS.");
        String replication = conf.get(SplunkMR.CONF_PKG_REPLICATION);
        if (replication != null) {
            fs.setReplication(remoteFile, Short.parseShort(replication));
        }
    }

    private void createLocalPackageIfConfiguredToDoSo(Configuration conf, File localFile) {
        String splunkHome = SplunkMR.getSHSplunkHome(conf);
        File packageFile = SplunkManifestPackager.getPackageFile(splunkHome);
        if (localFile.getAbsolutePath().equals(packageFile.getAbsolutePath())) {
            SplunkManifestPackager.create(splunkHome).ensurePackage(packageFile);
        }
    }

    public static void handleSetupOnSearch(Configuration conf, Map<String, Object> args) throws IOException, InterruptedException {
        File localPackage;
        Path hdfsPackagesHome;
        Path hdfsPackage;
        if (!StrUtil.parseBoolean(conf.get(SplunkMR.CONF_SETUP_ONSEARCH), false)) {
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(hdfsPackage = new Path(hdfsPackagesHome = SetupCommandHandler.getHDFSSplunkPackages(conf), (localPackage = new File(conf.get(SplunkMR.CONF_SETUP_PACKAGE))).getName()))) {
            return;
        }
        SetupCommandHandler sch = new SetupCommandHandler();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        SearchOutputStream out = new SearchOutputStream(buf);
        gLogger.info((Object)"running Hunk setup ...");
        if (SplunkMR.useProxy(conf)) {
            UserGroupInformation realUser = UserGroupInformation.getCurrentUser().getRealUser();
            realUser.doAs((PrivilegedExceptionAction)new PrivilegedCommandHandlerAction(sch, conf, args, out));
        } else {
            sch.execute(conf, args, out);
        }
        gLogger.info((Object)"running Hunk setup ... done");
    }

    private static SynchronizedExecuter.AcquiredHandler<File> installSplunkOnAcquiredTempFile(final Configuration conf, final File localPackage) {
        return new SynchronizedExecuter.AcquiredHandler<File>(){

            @Override
            public void onAcquired(File acquired) {
                try {
                    gLogger.info((Object)("Installing Hunk, acquired=" + acquired.getName() + ", localPackage=" + localPackage));
                    SetupCommandHandler.dnSplunkInstall(conf, acquired, localPackage);
                }
                catch (Exception e) {
                    gLogger.warn((Object)("Got exception when installing Hunk, acquired=" + acquired.getName() + ", localPackage=" + localPackage + ", ex=" + e));
                    FileUtils.deleteQuietly((File)acquired);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static void setupSplunk(Configuration conf) throws IOException, InterruptedException {
        File splunk_home = SplunkMR.getDNSplunkHome(conf);
        File splunk_parent = splunk_home.getParentFile();
        if (!splunk_parent.exists()) {
            splunk_parent.mkdirs();
        }
        String packageName = new File(conf.get(SplunkMR.CONF_SETUP_PACKAGE)).getName();
        File localPackage = new File(splunk_parent, packageName);
        File localPackageInstalled = new File(localPackage.toString() + INSTALLED_SUFFIX);
        gLogger.info((Object)"Check if package already exists, else quit and continue with bundle installation");
        if (localPackageInstalled.exists()) {
            return;
        }
        int maxTempFiles = 5;
        int maxInactivityWaitInSecs = conf.getInt(SplunkMR.CONF_PKG_MAX_INACTIVE_WAIT, 5);
        long splunkSetupTimeLimit = conf.getLong(SplunkMR.CONF_PKG_SETUP_TIME_LIMIT, 20000L);
        long startTime = System.currentTimeMillis();
        long pollInterval = conf.getLong(SplunkMR.CONF_PKG_POLL_INTERVAL, 100L);
        CountingTempFileProvider tempSplunkPackageProvider = new CountingTempFileProvider(localPackage, maxTempFiles, new IncrementFileCountWhenFileIsStale(maxInactivityWaitInSecs));
        gLogger.info((Object)("Will download and install splunk package from hdfs to splunk home on DN " + splunk_home.getName()));
        SynchronizedExecuter.executeOnAcquired(tempSplunkPackageProvider, SetupCommandHandler.installSplunkOnAcquiredTempFile(conf, localPackage), SynchronizedExecuter.ifInstalledExistsOrExceedsTimeLimit(localPackageInstalled, splunkSetupTimeLimit, startTime), SynchronizedExecuter.createFileAtomically(), pollInterval);
        CountingTempFileProvider.reapAllProvidedFiles(localPackage, maxTempFiles);
        if (!localPackageInstalled.exists()) {
            throw new IOException("Hunk timed out while waiting for package=" + localPackage + " to be installed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dnSplunkInstall(Configuration conf, File acquired, File localPackage) throws IOException, InterruptedException {
        File localPackageInstalled = new File(localPackage.getParent(), localPackage.getName() + INSTALLED_SUFFIX);
        if (localPackageInstalled.exists()) {
            gLogger.info((Object)("Hunk package is already installed, local_package_installed=" + localPackageInstalled.getAbsolutePath()));
            return;
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path remotePackage = new Path(SetupCommandHandler.getHDFSSplunkPackages(conf), localPackage.getName());
            if (!fs.exists(remotePackage)) {
                throw new IOException("Hunk package does not exist in HDFS, path=" + remotePackage.toUri() + ".");
            }
            gLogger.info((Object)("copying src=" + remotePackage.toUri() + ", dst=" + acquired));
            FSUtil.verifiedCopy(fs, remotePackage, acquired, false, conf);
            gLogger.info((Object)("installing package=" + acquired));
            ProcessBuilder pb = new ProcessBuilder("tar", "-xmf", acquired.toString());
            pb.directory(acquired.getParentFile());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)new NullOutputStream());
            int rv = p.waitFor();
            if (rv != 0) {
                throw new IOException("Failed to install Hunk package, rv=" + rv + ", path=" + acquired);
            }
            localPackageInstalled.createNewFile();
        }
        finally {
            FileUtils.deleteQuietly((File)acquired);
        }
        gLogger.info((Object)("finished copying and installing package=" + localPackage));
        SetupCommandHandler.cleanupInstalledFiles(localPackage.getParentFile());
    }

    private static void cleanupInstalledFiles(File splunk_parent) {
        long maxTime = System.currentTimeMillis() - -1702967296L;
        File[] files = splunk_parent.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(INSTALLED_SUFFIX) || file.lastModified() < maxTime) continue;
                try {
                    FileUtil.fullyDelete((File)file);
                    gLogger.info((Object)("Deleted installed marker file=" + file));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void cleanupToDeleteDnHomeDirs(File splunk_parent) {
        File[] files;
        for (File f : files = splunk_parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(CleanupMapper.DELETE_SUFFIX);
            }
        })) {
            gLogger.info((Object)("Attempting to delete dnHome2Delete=" + f));
            if (FileUtils.deleteQuietly((File)f)) {
                gLogger.info((Object)("Deleted renamed dnHome directory, dnHome2Delete=" + f));
                continue;
            }
            gLogger.warn((Object)("Unable to delete renamed dnHome directory, dnHome2Delete=" + f));
        }
    }
}

