/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.ExecutorDeadException;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t5b!B\u0010!\u0001\u0011R\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u000f\u0002\u0011)\u0019!C!\u0011\"A\u0011\n\u0001B\u0001B\u0003%!\b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!y\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000b]\u0003A\u0011\u0001-\t\u000f\t\u0004!\u0019!C\u0005G\"1\u0011\u000e\u0001Q\u0001\n\u0011DqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019A\b\u0001)A\u0005e\"I\u0011\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001f\u0005\n{\u0002\u0001\r\u0011!Q!\nyD1\"a\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\n!Q\u0011Q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001e\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\ti\u0007\u0001C!\u0003/Cq!!'\u0001\t\u0003\nY\nC\u0004\u0003\u0004\u0001!\tE!\u0002\b\u0015\t\u001d\u0001%!A\t\u0002\u0011\u0012IAB\u0005 A\u0005\u0005\t\u0012\u0001\u0013\u0003\f!1q\u000b\bC\u0001\u0005'A\u0011B!\u0006\u001d#\u0003%\tAa\u0006\u000339+G\u000f^=CY>\u001c7\u000e\u0016:b]N4WM]*feZL7-\u001a\u0006\u0003C\t\nQA\\3uifT!a\t\u0013\u0002\u000f9,Go^8sW*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0005\u0002\u0001WA\u0011A&L\u0007\u0002E%\u0011aF\t\u0002\u0015\u00052|7m\u001b+sC:\u001ch-\u001a:TKJ4\u0018nY3\u0002\t\r|gNZ\u0002\u0001!\t\u00114'D\u0001%\u0013\t!DEA\u0005Ta\u0006\u00148nQ8oM\u0006y1/Z2ve&$\u00180T1oC\u001e,'\u000f\u0005\u00023o%\u0011\u0001\b\n\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u0006Y!-\u001b8e\u0003\u0012$'/Z:t!\tYDI\u0004\u0002=\u0005B\u0011Q\bQ\u0007\u0002})\u0011q\bM\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007\u0002\u000b\u0001\u0002[8ti:\u000bW.Z\u000b\u0002u\u0005I\u0001n\\:u\u001d\u0006lW\rI\u0001\u0006?B|'\u000f\u001e\t\u0003\u00196k\u0011\u0001Q\u0005\u0003\u001d\u0002\u00131!\u00138u\u0003!qW/\\\"pe\u0016\u001c\u0018!\u00053sSZ,'/\u00128e!>Lg\u000e\u001e*fMB\u0011!+V\u0007\u0002'*\u0011A\u000bJ\u0001\u0004eB\u001c\u0017B\u0001,T\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fa\u0001P5oSRtD\u0003C-\\9vsv\fY1\u0011\u0005i\u0003Q\"\u0001\u0011\t\u000b=J\u0001\u0019A\u0019\t\u000bUJ\u0001\u0019\u0001\u001c\t\u000beJ\u0001\u0019\u0001\u001e\t\u000b\u001dK\u0001\u0019\u0001\u001e\t\u000b)K\u0001\u0019A&\t\u000b=K\u0001\u0019A&\t\u000fAK\u0001\u0013!a\u0001#\u0006Q1/\u001a:jC2L'0\u001a:\u0016\u0003\u0011\u0004\"!Z4\u000e\u0003\u0019T!A\u0019\u0013\n\u0005!4'A\u0004&bm\u0006\u001cVM]5bY&TXM]\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%A\u0006bkRDWI\\1cY\u0016$W#\u00017\u0011\u00051k\u0017B\u00018A\u0005\u001d\u0011un\u001c7fC:\fA\"Y;uQ\u0016s\u0017M\u00197fI\u0002\nQ\u0002\u001e:b]N\u0004xN\u001d;D_:4W#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u0014\u0013\u0001B;uS2L!a\u001e;\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u00039!(/\u00198ta>\u0014HoQ8oM\u0002\n\u0001\u0003\u001e:b]N\u0004xN\u001d;D_:$X\r\u001f;\u0011\u00051Z\u0018B\u0001?#\u0005A!&/\u00198ta>\u0014HoQ8oi\u0016DH/\u0001\u0004tKJ4XM\u001d\t\u0004\u007f\u0006\rQBAA\u0001\u0015\ti(%\u0003\u0003\u0002\u0006\u0005\u0005!a\u0004+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:\u0002\u001b\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:z!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\bE\u000511\r\\5f]RLA!a\u0005\u0002\u000e\t1BK]1ogB|'\u000f^\"mS\u0016tGOR1di>\u0014\u00180A\u0003baBLE-\u0001\u0003j]&$H\u0003BA\u000e\u0003C\u00012\u0001TA\u000f\u0013\r\ty\u0002\u0011\u0002\u0005+:LG\u000fC\u0004\u0002$Q\u0001\r!!\n\u0002!\tdwnY6ECR\fW*\u00198bO\u0016\u0014\bc\u0001\u0017\u0002(%\u0019\u0011\u0011\u0006\u0012\u0003!\tcwnY6ECR\fW*\u00198bO\u0016\u0014\u0018\u0001D2sK\u0006$XmU3sm\u0016\u0014Hc\u0001@\u00020!9\u0011\u0011G\u000bA\u0002\u0005M\u0012A\u00032p_R\u001cHO]1qgB1\u0011QGA \u0003\u000brA!a\u000e\u0002<9\u0019Q(!\u000f\n\u0003\u0005K1!!\u0010A\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0011\u0002D\t!A*[:u\u0015\r\ti\u0004\u0011\t\u0004\u007f\u0006\u001d\u0013\u0002BA%\u0003\u0003\u0011\u0001\u0004\u0016:b]N\u0004xN\u001d;TKJ4XM\u001d\"p_R\u001cHO]1q\u00039\u0019\b.\u001e4gY\u0016lU\r\u001e:jGN$\"!a\u0014\u0011\t\u0005E\u0013qL\u0007\u0003\u0003'RA!!\u0016\u0002X\u00059Q.\u001a;sS\u000e\u001c(\u0002BA-\u00037\n\u0001bY8eC\"\fG.\u001a\u0006\u0003\u0003;\n1aY8n\u0013\u0011\t\t'a\u0015\u0003\u00135+GO]5d'\u0016$\u0018a\u00034fi\u000eD'\t\\8dWN$b\"a\u0007\u0002h\u0005-\u0014qNA:\u0003{\ni\t\u0003\u0004\u0002j]\u0001\rAO\u0001\u0005Q>\u001cH\u000f\u0003\u0004\u0002n]\u0001\raS\u0001\u0005a>\u0014H\u000f\u0003\u0004\u0002r]\u0001\rAO\u0001\u0007Kb,7-\u00133\t\u000f\u0005Ut\u00031\u0001\u0002x\u0005A!\r\\8dW&#7\u000f\u0005\u0003M\u0003sR\u0014bAA>\u0001\n)\u0011I\u001d:bs\"9\u0011qP\fA\u0002\u0005\u0005\u0015\u0001\u00037jgR,g.\u001a:\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"#\u0003\u001d\u0019\b.\u001e4gY\u0016LA!a#\u0002\u0006\n)\"\t\\8dW\u001a+Go\u00195j]\u001ed\u0015n\u001d;f]\u0016\u0014\bbBAH/\u0001\u0007\u0011\u0011S\u0001\u0010i\u0016l\u0007OR5mK6\u000bg.Y4feB!\u00111QAJ\u0013\u0011\t)*!\"\u0003'\u0011{wO\u001c7pC\u00124\u0015\u000e\\3NC:\fw-\u001a:\u0016\u0003-\u000b1\"\u001e9m_\u0006$'\t\\8dWR\u0001\u0012QTAU\u0003[\u000by+!-\u0002B\u0006E\u00171\u001c\t\u0007\u0003?\u000b)+a\u0007\u000e\u0005\u0005\u0005&bAAR\u0001\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u0007\rV$XO]3\t\r\u0005-\u0016\u00041\u0001;\u0003!Awn\u001d;oC6,\u0007BBA73\u0001\u00071\n\u0003\u0004\u0002re\u0001\rA\u000f\u0005\b\u0003gK\u0002\u0019AA[\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004B!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w#\u0013aB:u_J\fw-Z\u0005\u0005\u0003\u007f\u000bILA\u0004CY>\u001c7.\u00133\t\u000f\u0005\r\u0017\u00041\u0001\u0002F\u0006I!\r\\8dW\u0012\u000bG/\u0019\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111\u001a\u0012\u0002\r\t,hMZ3s\u0013\u0011\ty-!3\u0003\u001b5\u000bg.Y4fI\n+hMZ3s\u0011\u001d\t\u0019.\u0007a\u0001\u0003+\fQ\u0001\\3wK2\u0004B!a.\u0002X&!\u0011\u0011\\A]\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u001d\ti.\u0007a\u0001\u0003?\f\u0001b\u00197bgN$\u0016m\u001a\u0019\u0005\u0003C\f\t\u0010\u0005\u0004\u0002d\u0006%\u0018Q^\u0007\u0003\u0003KT1!a:A\u0003\u001d\u0011XM\u001a7fGRLA!a;\u0002f\nA1\t\\1tgR\u000bw\r\u0005\u0003\u0002p\u0006EH\u0002\u0001\u0003\r\u0003g\fY.!A\u0001\u0002\u000b\u0005\u0011Q\u001f\u0002\u0004?\u0012\n\u0014\u0003BA|\u0003{\u00042\u0001TA}\u0013\r\tY\u0010\u0011\u0002\b\u001d>$\b.\u001b8h!\ra\u0015q`\u0005\u0004\u0005\u0003\u0001%aA!os\u0006)1\r\\8tKR\u0011\u00111D\u0001\u001a\u001d\u0016$H/\u001f\"m_\u000e\\GK]1og\u001a,'oU3sm&\u001cW\r\u0005\u0002[9M\u0019AD!\u0004\u0011\u00071\u0013y!C\u0002\u0003\u0012\u0001\u0013a!\u00118z%\u00164GC\u0001B\u0005\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!\u0011\u0004\u0016\u0004#\nm1F\u0001B\u000f!\u0011\u0011yB!\u000b\u000e\u0005\t\u0005\"\u0002\u0002B\u0012\u0005K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001d\u0002)\u0001\u0006b]:|G/\u0019;j_:LAAa\u000b\u0003\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    public final RpcEndpointRef org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef;
    private final JavaSerializer serializer;
    private final boolean authEnabled;
    private final TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    public TransportClientFactory org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory;
    public String org$apache$spark$network$netty$NettyBlockTransferService$$appId;

    public static RpcEndpointRef $lessinit$greater$default$7() {
        return NettyBlockTransferService$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String hostName() {
        return this.hostName;
    }

    private JavaSerializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    public TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new AuthServerBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new AuthClientBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager));
        }
        this.transportContext = new TransportContext(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (RpcHandler)rpcHandler);
        this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$appId = this.conf.getAppId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Server created on ").append(this.hostName()).append(":").append($this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort()).toString());
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, (Function1 & Serializable & scala.Serializable)port -> this.startService$1(BoxesRunTime.unboxToInt((Object)port), bootstraps), this.conf, this.getClass().getName())._1();
    }

    public MetricSet shuffleMetrics() {
        Predef$.MODULE$.require(this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null && this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null, (Function0 & Serializable & scala.Serializable)() -> "NettyBlockTransferServer is not initialized");
        return new MetricSet(this){
            private final HashMap<String, Metric> allMetrics;
            private final /* synthetic */ NettyBlockTransferService $outer;

            private HashMap<String, Metric> allMetrics() {
                return this.allMetrics;
            }

            public Map<String, Metric> getMetrics() {
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.getAllMetrics().getMetrics());
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getAllMetrics().getMetrics());
                return this.allMetrics();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allMetrics = new HashMap<K, V>();
            }
        };
    }

    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager tempFileManager) {
        block3: {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Fetch blocks from ").append(host).append(":").append(port).append(" (executor id ").append(execId).append(")").toString());
            try {
                RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, execId, tempFileManager){
                    private final /* synthetic */ NettyBlockTransferService $outer;
                    private final String host$1;
                    private final int port$1;
                    private final String execId$1;
                    private final DownloadFileManager tempFileManager$1;

                    public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                        try {
                            TransportClient client = this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(this.host$1, this.port$1);
                            new OneForOneBlockFetcher(client, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$appId, this.execId$1, blockIds, listener, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.tempFileManager$1).start();
                        }
                        catch (IOException e) {
                            Success success;
                            boolean v;
                            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean($this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef.askSync(new BlockManagerMessages.IsExecutorAlive($this.execId$1), ClassTag$.MODULE$.Boolean())));
                            if (try_ instanceof Success && !(v = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
                                throw new ExecutorDeadException(new StringBuilder(84).append("The relative remote executor(Id: ").append(this.execId$1).append("),").append(" which maintains the block data to fetch is dead.").toString());
                            }
                            throw e;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.host$1 = host$1;
                        this.port$1 = port$1;
                        this.execId$1 = execId$1;
                        this.tempFileManager$1 = tempFileManager$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createAndStart$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$2 )}, serializedLambda);
                    }
                };
                int maxRetries = this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf().maxIORetries();
                if (maxRetries > 0) {
                    new RetryingBlockFetcher(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), blockFetchStarter, blockIds, listener).start();
                    break block3;
                }
                blockFetchStarter.createAndStart(blockIds, listener);
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while beginning fetchBlocks", e);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    listener.onBlockFetchFailure(x$1, (Throwable)e);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        long l;
        Promise result = Promise$.MODULE$.apply();
        TransportClient client = this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        boolean asStream = blockData.size() > BoxesRunTime.unboxToLong((Object)this.conf.get(package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM()));
        RpcResponseCallback callback = new RpcResponseCallback(this, blockId, asStream, result){
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final BlockId blockId$1;
            private final boolean asStream$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Successfully uploaded block ").append($this.blockId$1).append((Object)($this.asStream$1 ? " as stream" : "")).toString());
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error while uploading ").append($this.blockId$1).append((Object)($this.asStream$1 ? " as stream" : "")).toString(), e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.asStream$1 = asStream$1;
                this.result$1 = result$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onSuccess$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$3 ), $anonfun$onFailure$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$3 )}, serializedLambda);
            }
        };
        if (asStream) {
            ByteBuffer streamHeader = new UploadBlockStream(blockId.name(), metadata).toByteBuffer();
            l = client.uploadStream((ManagedBuffer)new NioManagedBuffer(streamHeader), blockData, callback);
        } else {
            byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
            l = client.sendRpc(new UploadBlock(this.org$apache$spark$network$netty$NettyBlockTransferService$$appId, execId, blockId.name(), metadata, array).toByteBuffer(), callback);
        }
        return result.future();
    }

    public void close() {
        block2: {
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
                this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
            }
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null) {
                this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.close();
            }
            if (this.transportContext == null) break block2;
            this.transportContext.close();
        }
    }

    private final Tuple2 startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String bindAddress, String hostName, int _port, int numCores, RpcEndpointRef driverEndPointRef) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef = driverEndPointRef;
        this.serializer = new JavaSerializer(conf);
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores, SparkTransportConf$.MODULE$.fromSparkConf$default$4());
    }
}

