/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll.slices;

import com.splunk.roll.slices.Slice;
import com.splunk.util.MapUtil;
import com.splunk.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class Slices
implements Iterable<Slice> {
    public static final Long DEFAULT_MISSING_VALUE = null;
    private final List<String> fields;
    private List<List<Long>> values;
    private final Map<String, List<Long>> extras;

    public Slices(Tuple<List<String>, List<List<Long>>> parsed) {
        this((List)parsed.key, (List)parsed.value);
    }

    public Slices(List<String> fields, List<List<Long>> values) {
        this.fields = fields;
        this.values = values;
        this.extras = new HashMap<String, List<Long>>();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty() || this.values.isEmpty();
    }

    public Slice get(int i) {
        List<Long> longs = this.values.get(i);
        Slice slice = new Slice();
        for (int j = 0; j < this.fields.size(); ++j) {
            slice.put(this.fields.get(j), longs.get(j));
        }
        for (Map.Entry<String, List<Long>> e : this.extras.entrySet()) {
            slice.put(e.getKey(), e.getValue().get(i));
        }
        return slice;
    }

    public void add(Slice slice) {
        ArrayList<Long> longs = new ArrayList<Long>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            longs.add(this.getSliceValue(slice, this.fields.get(i), DEFAULT_MISSING_VALUE));
        }
        this.values.add(longs);
        for (Map.Entry<String, List<Long>> e : this.extras.entrySet()) {
            e.getValue().add(this.getSliceValue(slice, e.getKey(), DEFAULT_MISSING_VALUE));
        }
    }

    private Long getSliceValue(Slice slice, String key, Long defaultValue) {
        Long val = (Long)slice.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public void addAll(List<Slice> slices) {
        for (Slice s : slices) {
            this.add(s);
        }
    }

    public int size() {
        return this.values.size();
    }

    public void addNewValueToSlices(String key, List<Long> longs) {
        if (this.fields.contains(key)) {
            throw new RuntimeException("Slices' values are immutable. Cannot change the value of an existing key. Key: " + key);
        }
        if (this.values.size() != longs.size()) {
            throw new RuntimeException("Number of values have to match the other values. Key: " + key);
        }
        this.extras.put(key, longs);
    }

    public void crop(int length) {
        this.values.subList(length, this.values.size()).clear();
        for (Map.Entry<String, List<Long>> e : this.extras.entrySet()) {
            e.getValue().subList(length, e.getValue().size()).clear();
        }
    }

    public void set(String key, int index, long value) {
        if (!this.extras.containsKey(key)) {
            throw new IllegalArgumentException("Extras did not contain key=" + key + ". Can only set values to our own added keys. index=" + index + " value=" + value);
        }
        this.extras.get(key).set(index, value);
    }

    public Slice getLast() {
        return this.get(this.size() - 1);
    }

    public byte[] toJson() {
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            return jsonMapper.writeValueAsBytes(MapUtil.asMap("version", 1L, "fields", this.fields, "values", this.values, "extras", this.extras));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return new String(this.toJson());
    }

    @Override
    public Iterator<Slice> iterator() {
        return new Iterator<Slice>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Slices.this.values.size();
            }

            @Override
            public Slice next() {
                return Slices.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Slices newEmpty() {
        return Slices.createWithFields(new ArrayList<String>());
    }

    public static Slices createWithFields(List<String> fields) {
        return new Slices(new Tuple<List<String>, List<List<Long>>>(fields, new ArrayList()));
    }
}

