slim config - get, set, or unset user or system options
=======================================================

## SYNOPSIS

`slim` `config` \[(`-h`|`--help`)] \[(`-l`|`--location=`)(`system`|`user`)] \[(`-g`|`--get=`)&lt;name> \[&lt;name>...]]
\[(`-s`|`--set=`)&lt;name> &lt;value> \[&lt;name> &lt;value>...]] \[(`-u`|`--unset=`)&lt;name> \[&lt;name>...]]

## DESCRIPTION

Gets and sets user or system options.

## OPTIONS

`-h`, `--help`  
Print help message and exit.

`-l` (`system`|`user`), `--location` (`system`|`user`)  
When writing settings: write to the named configuration file (default: user); when reading settings: read only from the named configuration
file rather than from `system` and `user`.

`-g` \[&lt;name> \[&lt;name>...]], `--get=`[&lt;name> [&lt;name>...]]  
Get the values for all settings (using '\*'), all settings in a section (using '&lt;section>[.*]'), or the named settings, where the name of each setting is its section and option name separated by a dot ('&lt;section>.&lt;option>').

`-s` &lt;name> &lt;value> \[&lt;name> &lt;value>...], `--set=`&lt;name> &lt;value> \[&lt;name> &lt;value>...]  
Set the value for the named setting, where the name of the setting is its section and option name separated by a dot (&lt;section>.&lt;option>).

`-u` \[&lt;name> \[&lt;name> ...]], `--unset=`[&lt;name> [&lt;name> ...]]  
Remove the named settings, where the name of each setting is its section and option name separated by a dot (&lt;section>.&lt;option>).
