# coding=utf-8
#
# Copyright © Splunk, Inc. All Rights Reserved.

from __future__ import absolute_import, division, print_function, unicode_literals

import re

from slim.app import AppConfigurationSettingDeclaration, AppConfigurationValidationPlugin


class InputsConfigurationValidationPlugin(AppConfigurationValidationPlugin):

    def fix_up(self, stanza, placement, position):
        """ Fix up the specified stanza declaration

        This method adds builtin setting declarations to modular input stanzas.

        """
        AppConfigurationValidationPlugin.fix_up(self, stanza, placement, position)

        if self._match_modular_input(stanza.name):
            setting_declaration = AppConfigurationSettingDeclaration.Section
            builtins = self._builtin_settings
            stanza.setting_declarations.update(
                ((name, setting_declaration(name, data_type, placement, position)) for name, data_type in builtins)
            )

    # region Protected

    _builtin_settings = (
        ('interval', '<integer>'),
        ('persistentQueue', '<boolean>'),
        ('persistentQueueSize', '<integer>[KB|MB|GB|TB]'),
        ('queueSize', '<integer>[KB|MB|GB]'),
        ('start_by_shell', '<boolean>'),
    )

    _match_modular_input = re.compile(
        # A modular input scheme is
        # * not a builtin scheme
        r'(?!(batch|fifo|filter|fschange|http|monitor|script|splunktcp-ssl||splunktcp|ssl|tcp-ssl|tcp|udp)://)'
        # * but a scheme nonetheless
        r'(?:[0-9a-zA-Z][0-9a-zA-Z_-]*://)',
        re.M | re.U
    ).match

    # endregion
    pass
