/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchNotNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.visitors.NodeVisitor;

public class SearchToWhereConverter
extends NodeVisitor<IWherePredicate> {
    @Override
    public IWherePredicate visit(Node node) {
        return null;
    }

    @Override
    public IWherePredicate visit(SearchAndNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < node.getArguments().size(); ++i) {
            args[i] = node.getArguments().get(i).accept(this);
        }
        return new AndNode(args);
    }

    @Override
    public IWherePredicate visit(SearchNotNode node) {
        if (node.getArguments().size() != 1) {
            throw new IllegalArgumentException("Malformed NOT search predicate");
        }
        IWherePredicate predicate = node.getArguments().get(0).accept(this);
        return new NotNode(predicate);
    }

    @Override
    public IWherePredicate visit(SearchOrNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < node.getArguments().size(); ++i) {
            args[i] = node.getArguments().get(i).accept(this);
        }
        return new OrNode(args);
    }

    @Override
    public IWherePredicate visit(SearchComparisonNode node) {
        if (node.getRhs() instanceof ISearchPredicate) {
            return new ComparisonNode(node.getOperator(), node.getLhs(), (TypeNode)((Object)((ISearchPredicate)((Object)node.getRhs())).getSearchNode().accept(this)));
        }
        return new ComparisonNode(node.getOperator(), node.getLhs(), node.getRhs());
    }

    @Override
    public IWherePredicate visit(SearchFunctionNode node) {
        IWherePredicate[] args = new IWherePredicate[node.getArguments().size()];
        for (int i = 0; i < node.getArguments().size(); ++i) {
            args[i] = node.getArguments().get(i).accept(this);
        }
        return new BooleanFunctionNode(node.getFunction(), SearchToWhereConverter.convert(args));
    }

    private static TypeNode[] convert(IWherePredicate[] array) {
        TypeNode[] retVal = new TypeNode[array.length];
        for (int i = 0; i < array.length; ++i) {
            retVal[i] = array[i].getTypeNode();
        }
        return retVal;
    }
}

