/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandSourceKind;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IFilteringCommand;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.AppendCommand;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.commons.visitors.ReferencedFieldsVisitor;
import com.splunk.commons.visitors.ReverseRenameVisitor;
import com.splunk.commons.visitors.WhereToSearchConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PredicatePushdownVisitor
extends CommandRebuilder {
    @Override
    public CommandNode visit(EvalCommand node) {
        CommandNode source = node.getSource();
        switch (source.getCommandName()) {
            case "eval": {
                int i;
                EvalCommand sourceEval = (EvalCommand)source;
                int sourceLength = sourceEval.getAssignments().length;
                int currentLength = node.getAssignments().length;
                int mergedLength = sourceLength + currentLength;
                AssignmentNode[] allAssignments = new AssignmentNode[mergedLength];
                for (i = 0; i < sourceLength; ++i) {
                    allAssignments[i] = sourceEval.getAssignments()[i];
                }
                for (i = 0; i < currentLength; ++i) {
                    allAssignments[sourceLength + i] = node.getAssignments()[i];
                }
                return new EvalCommand(sourceEval.getSource(), allAssignments).accept(this);
            }
        }
        return node.setSource(source.accept(this));
    }

    @Override
    public CommandNode visit(WhereCommand node) {
        CommandNode source = node.getSource();
        switch (source.getCommandName()) {
            case "append": {
                return this.handleAppendFilter((AppendCommand)source, node);
            }
            case "from": {
                return PredicatePushdownVisitor.handleFromWhere((FromCommand)source, node);
            }
            case "rename": {
                return this.handleRenameFilter((RenameCommand)source, node);
            }
            case "search": {
                return this.handleSearchWhere((SearchCommand)source, node);
            }
            case "union": {
                return this.handleUnionFilter((UnionCommand)source, node);
            }
            case "where": {
                return PredicatePushdownVisitor.handleWhereWhere((WhereCommand)source, node);
            }
        }
        return this.handleCommandFilter(source, node);
    }

    @Override
    public CommandNode visit(SearchCommand node) {
        if (node.getSources().length == 0) {
            return node;
        }
        CommandNode source = node.getSource();
        switch (source.getCommandName()) {
            case "append": {
                return this.handleAppendFilter((AppendCommand)source, node);
            }
            case "join": {
                return this.handleJoinSearch((JoinCommand)source, node);
            }
            case "selfjoin": {
                return this.handleSelfJoinSearch((JoinCommand)source, node);
            }
            case "rename": {
                return this.handleRenameFilter((RenameCommand)source, node);
            }
            case "search": {
                return PredicatePushdownVisitor.handleSearchSearch((SearchCommand)source, node).accept(this);
            }
            case "union": {
                return this.handleUnionFilter((UnionCommand)source, node);
            }
            case "where": {
                return this.handleWhereSearch((WhereCommand)source, node);
            }
        }
        return this.handleCommandFilter(source, node);
    }

    private CommandNode handleAppendFilter(AppendCommand append, IFilteringCommand filter) {
        if (filter == null) {
            throw new IllegalStateException("Expected either a Where or Search command.");
        }
        CommandNode left = filter.getCommand().setSource(append.getLeftSource()).accept(this);
        CommandNode right = filter.getCommand().setSource(append.getRightSource()).accept(this);
        return new AppendCommand(left, right);
    }

    private CommandNode handleUnionFilter(UnionCommand union, IFilteringCommand filter) {
        if (filter == null) {
            throw new IllegalStateException("Expected either a Where or Search command.");
        }
        CommandNode[] sources = new CommandNode[union.getSources().length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = filter.getCommand().setSource(union.getSources()[i]).accept(this);
        }
        return new UnionCommand(sources);
    }

    private CommandNode handleJoinSearch(JoinCommand join, SearchCommand search) {
        if (join.isV2()) {
            return this.handleV2JoinCommand(join, search);
        }
        return search.setSource(join.setSources(new CommandNode[]{join.getLhs().accept(this), join.getRhs().accept(this)}));
    }

    private CommandNode handleSelfJoinSearch(JoinCommand join, SearchCommand search) {
        return search.setSource(join.setSources(new CommandNode[]{join.getLhs().accept(this)}));
    }

    private CommandNode handleV2JoinCommand(JoinCommand join, SearchCommand search) {
        ArrayList<SearchNode> lhsPredicates = new ArrayList<SearchNode>();
        ArrayList<SearchNode> rhsPredicates = new ArrayList<SearchNode>();
        ArrayList<SearchNode> afterPredicates = new ArrayList<SearchNode>();
        SearchFunctionNode original = (SearchFunctionNode)search.getPredicate().getNode();
        for (SearchNode predicate : original.getArguments()) {
            ReverseRenameVisitor renamer;
            Set<String> referenced = PredicatePushdownVisitor.referencedBy(predicate);
            boolean hasLeft = false;
            boolean hasRight = false;
            for (String field : referenced) {
                if (field.startsWith(join.getLhsAlias())) {
                    hasLeft = true;
                    continue;
                }
                if (!field.startsWith(join.getRhsAlias())) continue;
                hasRight = true;
            }
            if (hasLeft && !hasRight) {
                renamer = new ReverseRenameVisitor(new RenameNode[]{new RenameNode("*", join.getLhsAlias().concat(".*"))});
                lhsPredicates.add((SearchNode)predicate.accept(renamer));
                continue;
            }
            if (hasRight && !hasLeft) {
                renamer = new ReverseRenameVisitor(new RenameNode[]{new RenameNode("*", join.getRhsAlias().concat(".*"))});
                rhsPredicates.add((SearchNode)predicate.accept(renamer));
                continue;
            }
            afterPredicates.add(predicate);
        }
        boolean isAnd = original.getFunction() == "AND";
        SearchFunctionNode lhsPredicate = PredicatePushdownVisitor.merge(lhsPredicates, isAnd);
        SearchFunctionNode rhsPredicate = PredicatePushdownVisitor.merge(rhsPredicates, isAnd);
        SearchFunctionNode afterPredicate = PredicatePushdownVisitor.merge(afterPredicates, isAnd);
        if (!isAnd && (afterPredicate != null || lhsPredicate != null && rhsPredicate != null)) {
            lhsPredicate = null;
            rhsPredicate = null;
            afterPredicate = original;
        }
        return this.rebuildJoin(join, lhsPredicate, rhsPredicate, afterPredicate);
    }

    private static SearchFunctionNode merge(List<SearchNode> predicates, boolean asAnd) {
        if (predicates.isEmpty()) {
            return null;
        }
        ISearchPredicate[] args = new ISearchPredicate[predicates.size()];
        for (int i = 0; i < predicates.size(); ++i) {
            args[i] = predicates.get(i);
        }
        if (asAnd) {
            return new SearchAndNode(args);
        }
        return new SearchOrNode(args);
    }

    private static IWherePredicate merge(IWherePredicate lhs, IWherePredicate rhs) {
        IWherePredicate merged = lhs == null ? rhs : (rhs == null ? lhs : (IWherePredicate)lhs.and(rhs));
        return merged;
    }

    private static ISearchPredicate merge(ISearchPredicate lhs, ISearchPredicate rhs) {
        ISearchPredicate merged = lhs == null || lhs instanceof SearchFunctionNode && ((SearchFunctionNode)lhs).getArguments().size() == 0 ? rhs : (rhs == null || rhs instanceof SearchFunctionNode && ((SearchFunctionNode)rhs).getArguments().size() == 0 ? lhs : (ISearchPredicate)lhs.and(rhs));
        return merged;
    }

    private CommandNode rebuildJoin(JoinCommand join, ISearchPredicate lhsPredicate, ISearchPredicate rhsPredicate, ISearchPredicate afterPredicate) {
        CommandNode lhs = join.getLhs();
        CommandNode rhs = join.getRhs();
        if (lhsPredicate != null) {
            lhs = new SearchCommand(lhs, lhsPredicate);
        }
        if (rhsPredicate != null) {
            rhs = new SearchCommand(rhs, rhsPredicate);
        }
        lhs = lhs.accept(this);
        rhs = rhs.accept(this);
        join = (JoinCommand)join.setSources(new CommandNode[]{lhs, rhs});
        if (afterPredicate != null) {
            return new SearchCommand(join, afterPredicate);
        }
        return join;
    }

    private CommandNode handleRenameFilter(RenameCommand rename, IFilteringCommand filtering) {
        if (!PredicatePushdownVisitor.hasWildcardRenames(rename)) {
            IPredicate modifiedPredicate = (IPredicate)((Object)filtering.getPredicate().getNode().accept(new ReverseRenameVisitor(rename.getRenames())));
            CommandNode renameSource = modifiedPredicate instanceof ISearchPredicate ? new SearchCommand(rename.getSource(), modifiedPredicate).accept(this) : new WhereCommand(rename.getSource(), modifiedPredicate).accept(this);
            return rename.setSource(renameSource);
        }
        return filtering.getCommand().setSource(rename.accept(this));
    }

    private static boolean hasWildcardRenames(RenameCommand command) {
        for (RenameNode rename : command.getRenames()) {
            if (!rename.getFieldName().contains("*")) continue;
            return true;
        }
        return false;
    }

    private static CommandNode handleWhereWhere(WhereCommand source, WhereCommand current) {
        IWherePredicate lhs = (IWherePredicate)((Object)source.getPredicate().getNode());
        IWherePredicate rhs = (IWherePredicate)((Object)current.getPredicate().getNode());
        IPredicate merged = lhs.and(rhs);
        return new WhereCommand(source.getSource(), merged);
    }

    private CommandNode handleWhereSearch(WhereCommand where, SearchCommand search) {
        return PredicatePushdownVisitor.swap(where, search).accept(this);
    }

    private CommandNode handleSearchWhere(SearchCommand search, WhereCommand where) {
        CommandNode cursor;
        WhereToSearchConverter converter = new WhereToSearchConverter();
        IPredicate original = where.getPredicate();
        IPredicate pushable = null;
        IPredicate nonPushable = null;
        if (original instanceof AndNode) {
            for (TypeNode arg : ((FunctionNode)((Object)original)).getArguments()) {
                IPredicate origPredicate = (IPredicate)((Object)arg);
                ISearchPredicate convPredicate = arg.accept(converter);
                if (convPredicate == null) {
                    if (nonPushable == null) {
                        nonPushable = new AndNode(new IWherePredicate[0]);
                    }
                    nonPushable = nonPushable.and(origPredicate);
                    continue;
                }
                if (pushable == null) {
                    pushable = new SearchAndNode(new ISearchPredicate[0]);
                }
                pushable = pushable.and(convPredicate);
            }
        } else {
            pushable = original.getNode().accept(converter);
            IPredicate iPredicate = nonPushable = pushable == null ? original : null;
        }
        if (pushable == null) {
            return where.setSource(search.accept(this));
        }
        IPredicate searchPredicate = search.getPredicate().and(pushable);
        CommandNode commandNode = cursor = search.isGenerating() ? new SearchCommand(searchPredicate) : new SearchCommand(search.getSource(), searchPredicate).accept(this);
        if (nonPushable != null) {
            cursor = new WhereCommand(cursor, nonPushable);
        }
        return cursor;
    }

    private static CommandNode handleSearchSearch(SearchCommand source, SearchCommand current) {
        ISearchPredicate merged = PredicatePushdownVisitor.merge((ISearchPredicate)source.getPredicate(), (ISearchPredicate)current.getPredicate());
        if (source.getCommandSourceKind() == CommandSourceKind.GENERATING) {
            return new SearchCommand(merged);
        }
        return new SearchCommand(source.getSource(), merged);
    }

    private static CommandNode handleFromWhere(FromCommand from, WhereCommand where) {
        if (from.getGroupBy() == null && from.getSelections() == null) {
            IWherePredicate toPush = (IWherePredicate)where.getPredicate();
            IWherePredicate root = from.getWhere();
            IWherePredicate merged = PredicatePushdownVisitor.merge(root, toPush);
            return new FromCommand(from.getDataset(), merged, null, null, from.getOrderings());
        }
        return where;
    }

    private CommandNode handleCommandFilter(CommandNode source, IFilteringCommand filter) {
        CommandNode cursor;
        CommandNode current = filter.getCommand();
        boolean isSearch = filter instanceof SearchCommand;
        if (source.getCommandType() != CommandType.SP_STREAM || !source.isSingleSourced()) {
            return current.setSource(source.accept(this));
        }
        Set<String> modified = PredicatePushdownVisitor.modifiedBy(source);
        IPredicate original = filter.getPredicate();
        ArrayList<IPredicate> predicates = new ArrayList<IPredicate>();
        if (original instanceof AndNode) {
            for (TypeNode t : ((FunctionNode)((Object)original)).getArguments()) {
                predicates.add((IPredicate)((Object)t));
            }
        } else if (original instanceof SearchAndNode) {
            predicates.addAll(((SearchFunctionNode)original).getArguments());
        } else if (original instanceof OrNode || original instanceof SearchOrNode) {
            predicates.add(original);
        } else {
            throw new IllegalStateException("Encountered an unexpected predicate type");
        }
        IPredicate before = null;
        IPredicate after = null;
        for (IPredicate predicate : predicates) {
            if (PredicatePushdownVisitor.canPush(modified, PredicatePushdownVisitor.referencedBy(predicate.getNode()))) {
                before = before == null ? predicate : before.and(predicate);
                continue;
            }
            after = after == null ? predicate : after.and(predicate);
        }
        if (before == null) {
            return current.setSource(source.accept(this));
        }
        if (after == null) {
            return PredicatePushdownVisitor.swap(source, current).accept(this);
        }
        if (isSearch) {
            cursor = new SearchCommand(source.getSource(), before);
            cursor = source.setSource(cursor).accept(this);
            cursor = new SearchCommand(cursor, after);
        } else {
            cursor = new WhereCommand(source.getSource(), before);
            cursor = source.setSource(cursor).accept(this);
            cursor = new WhereCommand(cursor, after);
        }
        return cursor;
    }

    private static boolean canPush(Set<String> modifiedFields, Set<String> referencedFields) {
        if (modifiedFields.contains("*") && !referencedFields.isEmpty()) {
            return false;
        }
        Set<String> copy = PredicatePushdownVisitor.clone(modifiedFields);
        copy.retainAll(referencedFields);
        return copy.isEmpty();
    }

    private static Set<String> referencedBy(Node node) {
        return node.accept(new ReferencedFieldsVisitor());
    }

    private static Set<String> modifiedBy(CommandNode node) {
        HashSet modifiedBy = new HashSet();
        return node.getFieldsAndProperties().getModified();
    }

    private static Set<String> clone(Set<String> original) {
        HashSet<String> clone = new HashSet<String>(original);
        return clone;
    }

    private static CommandNode swap(CommandNode first, CommandNode second) {
        if (first.isSingleSourced() && second.isSingleSourced() && second.getSource() == first) {
            return first.setSource(second.setSource(first.getSource()));
        }
        throw new IllegalStateException("Can't swap commands. They both need the same number of sources and first must be the source of second already.");
    }
}

