/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.providers.CompensatingFromProvider;
import com.splunk.commons.providers.IPlanProvider;
import com.splunk.commons.providers.handlers.IGroupByHandler;
import com.splunk.commons.providers.handlers.ISelectHandler;
import com.splunk.commons.providers.handlers.IWhereHandler;
import com.splunk.commons.visitors.Expander;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientDatasetPlanProvider
implements IPlanProvider,
IWhereHandler,
ISelectHandler,
IGroupByHandler {
    private final IDatasetResolver datasetResolver;
    private final Expander expander;
    private CompensatingFromProvider provider;
    private static final Logger logger = LoggerFactory.getLogger(TransientDatasetPlanProvider.class);

    public TransientDatasetPlanProvider(IDatasetResolver datasetResolver) {
        this.datasetResolver = datasetResolver;
        this.expander = new Expander(datasetResolver);
    }

    @Override
    public void groupBy(IGroupBy[] fields) {
        this.provider.groupBy(fields);
    }

    @Override
    public void select(ISelection[] projections) {
        this.provider.select(projections);
    }

    @Override
    public void where(IWherePredicate where) {
        this.provider.where(where);
    }

    private void initProvider(CommandNode node) throws IOException {
        if (node instanceof UnionCommand) {
            CommandNode[] sources = node.getSources();
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            String sharedKind = null;
            for (CommandNode source : sources) {
                Dataset dataset;
                if (source instanceof FromCommand && ((FromCommand)source).supportsShorthand()) {
                    dataset = source.getDataset();
                    IDatasetInfo datasetInfo = Modules.resolveRecursive(this.datasetResolver, dataset);
                    if (datasetInfo == null) {
                        throw new IllegalArgumentException("Dataset " + dataset + " couldn't be resolved from catalog.");
                    }
                    dataset = new Dataset(datasetInfo.getModule(), datasetInfo.getKind(), datasetInfo.getName());
                    if (sharedKind == null) {
                        sharedKind = dataset.getKind();
                    } else if (!sharedKind.equals(dataset.getKind())) {
                        sharedKind = null;
                        break;
                    }
                } else {
                    sharedKind = null;
                    break;
                }
                datasets.add(dataset);
            }
            if (sharedKind != null && datasets.size() == sources.length) {
                Dataset[] datasetArr = new Dataset[datasets.size()];
                try {
                    this.provider = new CompensatingFromProvider(this.datasetResolver);
                    this.provider.initialize(datasets.toArray(datasetArr));
                    return;
                }
                catch (RuntimeException ex) {
                    logger.warn("Failed to initialize compensating from provider, error=\"{}\"", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        CommandNode expandedNode = node.accept(this.expander);
        IPlanProvider simpleProvider = new IPlanProvider(){
            private Dataset dataset;

            @Override
            public void initialize(Dataset dataset) {
                this.dataset = dataset;
            }

            @Override
            public CommandNode getCommand() {
                return ((TransientDataset)this.dataset).getSource();
            }
        };
        this.provider = new CompensatingFromProvider(this.datasetResolver);
        this.provider.initialize(expandedNode.getDataset(), simpleProvider);
    }

    @Override
    public void initialize(Dataset dataset) throws IOException {
        if (!dataset.getKind().equals("transient")) {
            throw new IOException("TransientDatasetPlanProvider only supports transient datasets.");
        }
        this.initProvider(((TransientDataset)dataset).getSource());
    }

    @Override
    public CommandNode getCommand() {
        return this.provider.getCommand();
    }
}

