/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetInfo;
import java.util.Arrays;
import java.util.List;

public interface IDatasetResolver {
    default public IDatasetInfo resolveDataset(String name) {
        return this.resolveDataset(new Dataset(name));
    }

    default public IDatasetInfo resolveDataset(String kind, String name) {
        return this.resolveDataset(new Dataset(kind, name));
    }

    default public IDatasetInfo resolveDataset(Dataset dataset) {
        List<IDatasetInfo> datasetInfoList = this.query(Modules.buildWherePredicate(Arrays.asList(dataset), this.getModule()));
        if (!datasetInfoList.isEmpty()) {
            if (datasetInfoList.size() > 1) {
                throw new IllegalArgumentException("Dataset " + dataset + " resolved into multiple dataset info. Use query() interface instead.");
            }
            return datasetInfoList.get(0);
        }
        return null;
    }

    public List<IDatasetInfo> query(IWherePredicate var1);

    default public String getModule() {
        return "";
    }

    default public void setModule(String module) {
    }
}

