/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import java.lang.reflect.Type;
import java.math.BigDecimal;

public final class Number {
    private Number() {
    }

    public static boolean isNumeric(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Double || object instanceof Float || object instanceof Long || object instanceof Integer || object instanceof BigDecimal;
    }

    public static Type targetNumericType(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float && rhs instanceof Long || lhs instanceof Long && rhs instanceof Float) {
            return Double.class;
        }
        if (lhs instanceof Float || rhs instanceof Float) {
            return Float.class;
        }
        if (lhs instanceof Long || rhs instanceof Long) {
            return Long.class;
        }
        if (lhs instanceof Integer && rhs instanceof Integer) {
            return Integer.class;
        }
        if (lhs instanceof String && Number.isNumeric(rhs)) {
            return rhs.getClass();
        }
        try {
            new BigDecimal(lhs.toString());
            new BigDecimal(rhs.toString());
            return BigDecimal.class;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("One or both of the arguments is not a supported Numeric type");
        }
    }

    public static Object add(Object lhs, Object rhs) {
        Type target = Number.targetNumericType(lhs, rhs);
        if (target == null) {
            return null;
        }
        if (target == BigDecimal.class) {
            BigDecimal lhsValue = new BigDecimal(lhs.toString());
            BigDecimal rhsValue = new BigDecimal(rhs.toString());
            return lhsValue.add(rhsValue);
        }
        if (target == Double.class) {
            double dl = Double.parseDouble(lhs.toString());
            double dr = Double.parseDouble(rhs.toString());
            return dl + dr;
        }
        if (target == Float.class) {
            float fl = Float.parseFloat(lhs.toString());
            float fr = Float.parseFloat(rhs.toString());
            return Float.valueOf(fl + fr);
        }
        if (target == Long.class) {
            long ll = Long.parseLong(lhs.toString());
            long lr = Long.parseLong(rhs.toString());
            return ll + lr;
        }
        int il = Integer.parseInt(lhs.toString());
        int ir = Integer.parseInt(rhs.toString());
        return il + ir;
    }

    public static Object subtract(Object lhs, Object rhs) {
        Type target = Number.targetNumericType(lhs, rhs);
        if (target == null) {
            return null;
        }
        if (target == BigDecimal.class) {
            BigDecimal lhsValue = new BigDecimal(lhs.toString());
            BigDecimal rhsValue = new BigDecimal(rhs.toString());
            return lhsValue.subtract(rhsValue);
        }
        if (target == Double.class) {
            double dl = Double.parseDouble(lhs.toString());
            double dr = Double.parseDouble(rhs.toString());
            return dl - dr;
        }
        if (target == Float.class) {
            float fl = Float.parseFloat(lhs.toString());
            float fr = Float.parseFloat(rhs.toString());
            return Float.valueOf(fl - fr);
        }
        if (target == Long.class) {
            long ll = Long.parseLong(lhs.toString());
            long lr = Long.parseLong(rhs.toString());
            return ll - lr;
        }
        int il = Integer.parseInt(lhs.toString());
        int ir = Integer.parseInt(rhs.toString());
        return il - ir;
    }

    public static Object multiply(Object lhs, Object rhs) {
        Type target = Number.targetNumericType(lhs, rhs);
        if (target == null) {
            return null;
        }
        if (target == BigDecimal.class) {
            BigDecimal lhsValue = new BigDecimal(lhs.toString());
            BigDecimal rhsValue = new BigDecimal(rhs.toString());
            return lhsValue.multiply(rhsValue);
        }
        if (target == Double.class) {
            double dl = Double.parseDouble(lhs.toString());
            double dr = Double.parseDouble(rhs.toString());
            return dl * dr;
        }
        if (target == Float.class) {
            float fl = Float.parseFloat(lhs.toString());
            float fr = Float.parseFloat(rhs.toString());
            return Float.valueOf(fl * fr);
        }
        if (target == Long.class) {
            long ll = Long.parseLong(lhs.toString());
            long lr = Long.parseLong(rhs.toString());
            return ll * lr;
        }
        int il = Integer.parseInt(lhs.toString());
        int ir = Integer.parseInt(rhs.toString());
        return il * ir;
    }

    public static Object divide(Object lhs, Object rhs) {
        Type target = Number.targetNumericType(lhs, rhs);
        if (target == null) {
            return null;
        }
        if (target == BigDecimal.class) {
            double rhsValue;
            double lhsValue = new BigDecimal(lhs.toString()).doubleValue();
            double result = lhsValue / (rhsValue = new BigDecimal(rhs.toString()).doubleValue());
            if (result == (double)((long)result)) {
                return (long)result;
            }
            return result;
        }
        if (target == Double.class) {
            double dl = Double.parseDouble(lhs.toString());
            double dr = Double.parseDouble(rhs.toString());
            return dl / dr;
        }
        if (target == Float.class) {
            float fl = Float.parseFloat(lhs.toString());
            float fr = Float.parseFloat(rhs.toString());
            return Float.valueOf(fl / fr);
        }
        if (target == Long.class) {
            long ll = Long.parseLong(lhs.toString());
            long lr = Long.parseLong(rhs.toString());
            return ll / lr;
        }
        int il = Integer.parseInt(lhs.toString());
        int ir = Integer.parseInt(rhs.toString());
        return (double)il / (double)ir;
    }

    public static Object modulo(Object lhs, Object rhs) {
        Type target = Number.targetNumericType(lhs, rhs);
        if (target == null) {
            return null;
        }
        if (target == BigDecimal.class) {
            BigDecimal lhsValue = new BigDecimal(lhs.toString());
            BigDecimal rhsValue = new BigDecimal(rhs.toString());
            return lhsValue.remainder(rhsValue);
        }
        if (target == Double.class) {
            double dl = Double.parseDouble(lhs.toString());
            double dr = Double.parseDouble(rhs.toString());
            return dl % dr;
        }
        if (target == Float.class) {
            float fl = Float.parseFloat(lhs.toString());
            float fr = Float.parseFloat(rhs.toString());
            return Float.valueOf(fl % fr);
        }
        if (target == Long.class) {
            long ll = Long.parseLong(lhs.toString());
            long lr = Long.parseLong(rhs.toString());
            return ll % lr;
        }
        int il = Integer.parseInt(lhs.toString());
        int ir = Integer.parseInt(rhs.toString());
        return (double)il % (double)ir;
    }

    public static boolean equal(Object lhs, Object rhs) {
        try {
            int ir;
            Type target = Number.targetNumericType(lhs, rhs);
            if (target == null) {
                return false;
            }
            if (target == BigDecimal.class) {
                double rhsValue;
                double lhsValue = new BigDecimal(lhs.toString()).doubleValue();
                return lhsValue == (rhsValue = new BigDecimal(rhs.toString()).doubleValue());
            }
            if (target == Double.class) {
                double dr;
                double dl = Double.parseDouble(lhs.toString());
                return dl == (dr = Double.parseDouble(rhs.toString()));
            }
            if (target == Float.class) {
                float fr;
                float fl = Float.parseFloat(lhs.toString());
                return fl == (fr = Float.parseFloat(rhs.toString()));
            }
            if (target == Long.class) {
                long lr;
                long ll = Long.parseLong(lhs.toString());
                return ll == (lr = Long.parseLong(rhs.toString()));
            }
            int il = Integer.parseInt(lhs.toString());
            return il == (ir = Integer.parseInt(rhs.toString()));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean notEqual(Object lhs, Object rhs) {
        try {
            int ir;
            Type target = Number.targetNumericType(lhs, rhs);
            if (target == null) {
                return false;
            }
            if (target == BigDecimal.class) {
                double rhsValue;
                double lhsValue = new BigDecimal(lhs.toString()).doubleValue();
                return lhsValue != (rhsValue = new BigDecimal(rhs.toString()).doubleValue());
            }
            if (target == Double.class) {
                double dr;
                double dl = Double.parseDouble(lhs.toString());
                return dl != (dr = Double.parseDouble(rhs.toString()));
            }
            if (target == Float.class) {
                float fr;
                float fl = Float.parseFloat(lhs.toString());
                return fl != (fr = Float.parseFloat(rhs.toString()));
            }
            if (target == Long.class) {
                long lr;
                long ll = Long.parseLong(lhs.toString());
                return ll != (lr = Long.parseLong(rhs.toString()));
            }
            int il = Integer.parseInt(lhs.toString());
            return il != (ir = Integer.parseInt(rhs.toString()));
        }
        catch (NumberFormatException nfe) {
            return true;
        }
    }

    public static boolean greaterThan(Object lhs, Object rhs) {
        try {
            int ir;
            Type target = Number.targetNumericType(lhs, rhs);
            if (target == null) {
                return false;
            }
            if (target == BigDecimal.class) {
                double rhsValue;
                double lhsValue = new BigDecimal(lhs.toString()).doubleValue();
                return lhsValue > (rhsValue = new BigDecimal(rhs.toString()).doubleValue());
            }
            if (target == Double.class) {
                double dr;
                double dl = Double.parseDouble(lhs.toString());
                return dl > (dr = Double.parseDouble(rhs.toString()));
            }
            if (target == Float.class) {
                float fr;
                float fl = Float.parseFloat(lhs.toString());
                return fl > (fr = Float.parseFloat(rhs.toString()));
            }
            if (target == Long.class) {
                long lr;
                long ll = Long.parseLong(lhs.toString());
                return ll > (lr = Long.parseLong(rhs.toString()));
            }
            int il = Integer.parseInt(lhs.toString());
            return il > (ir = Integer.parseInt(rhs.toString()));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean greaterThanEqual(Object lhs, Object rhs) {
        try {
            int ir;
            Type target = Number.targetNumericType(lhs, rhs);
            if (target == null) {
                return false;
            }
            if (target == BigDecimal.class) {
                double rhsValue;
                double lhsValue = new BigDecimal(lhs.toString()).doubleValue();
                return lhsValue >= (rhsValue = new BigDecimal(rhs.toString()).doubleValue());
            }
            if (target == Double.class) {
                double dr;
                double dl = Double.parseDouble(lhs.toString());
                return dl >= (dr = Double.parseDouble(rhs.toString()));
            }
            if (target == Float.class) {
                float fr;
                float fl = Float.parseFloat(lhs.toString());
                return fl >= (fr = Float.parseFloat(rhs.toString()));
            }
            if (target == Long.class) {
                long lr;
                long ll = Long.parseLong(lhs.toString());
                return ll >= (lr = Long.parseLong(rhs.toString()));
            }
            int il = Integer.parseInt(lhs.toString());
            return il >= (ir = Integer.parseInt(rhs.toString()));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean lessThan(Object lhs, Object rhs) {
        try {
            int ir;
            Type target = Number.targetNumericType(lhs, rhs);
            if (target == null) {
                return false;
            }
            if (target == BigDecimal.class) {
                double rhsValue;
                double lhsValue = new BigDecimal(lhs.toString()).doubleValue();
                return lhsValue < (rhsValue = new BigDecimal(rhs.toString()).doubleValue());
            }
            if (target == Double.class) {
                double dr;
                double dl = Double.parseDouble(lhs.toString());
                return dl < (dr = Double.parseDouble(rhs.toString()));
            }
            if (target == Float.class) {
                float fr;
                float fl = Float.parseFloat(lhs.toString());
                return fl < (fr = Float.parseFloat(rhs.toString()));
            }
            if (target == Long.class) {
                long lr;
                long ll = Long.parseLong(lhs.toString());
                return ll < (lr = Long.parseLong(rhs.toString()));
            }
            int il = Integer.parseInt(lhs.toString());
            return il < (ir = Integer.parseInt(rhs.toString()));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean lessThanEqual(Object lhs, Object rhs) {
        try {
            int ir;
            Type target = Number.targetNumericType(lhs, rhs);
            if (target == null) {
                return false;
            }
            if (target == BigDecimal.class) {
                double rhsValue;
                double lhsValue = new BigDecimal(lhs.toString()).doubleValue();
                return lhsValue <= (rhsValue = new BigDecimal(rhs.toString()).doubleValue());
            }
            if (target == Double.class) {
                double dr;
                double dl = Double.parseDouble(lhs.toString());
                return dl <= (dr = Double.parseDouble(rhs.toString()));
            }
            if (target == Float.class) {
                float fr;
                float fl = Float.parseFloat(lhs.toString());
                return fl <= (fr = Float.parseFloat(rhs.toString()));
            }
            if (target == Long.class) {
                long lr;
                long ll = Long.parseLong(lhs.toString());
                return ll <= (lr = Long.parseLong(rhs.toString()));
            }
            int il = Integer.parseInt(lhs.toString());
            return il <= (ir = Integer.parseInt(rhs.toString()));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static enum NumberKind {
        DOUBLE,
        FLOAT,
        LONG,
        INTEGER,
        INVALID;

    }
}

