/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.util.RDPartition;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class RdOutCommand
extends CommandNode {
    private static final RDPartition defaultPartitioner = RDPartition.Hash;
    private final HostPort[] dfsWorkerNodes;
    private final FieldNode[] hashKeys;
    private final RDPartition partitionMethod;
    private final boolean orderSensitive;

    public RdOutCommand(CommandNode source, HostPort[] dfsWorkerNodes, FieldNode[] hashKeys, RDPartition partitionType, boolean orderSensitive) {
        super(source, "rdout", CommandType.SP_STREAM, new FieldsAndProperties().array());
        this.dfsWorkerNodes = dfsWorkerNodes;
        this.hashKeys = hashKeys;
        this.partitionMethod = partitionType;
        this.orderSensitive = orderSensitive;
    }

    public RdOutCommand(CommandNode source, HostPort[] dfsWorkerNodes, FieldNode[] hashKeys, RDPartition partition) {
        this(source, dfsWorkerNodes, hashKeys, partition, false);
    }

    public RdOutCommand(CommandNode source, HostPort[] dfsWorkerNodes, FieldNode[] hashKeys) {
        this(source, dfsWorkerNodes, hashKeys, defaultPartitioner, false);
    }

    public RdOutCommand(CommandNode source, HostPort[] dfsWorkerNodes, RDPartition partition) {
        this(source, dfsWorkerNodes, null, partition, false);
    }

    public String getDFSWorkersAsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.dfsWorkerNodes.length; ++i) {
            sb.append(this.dfsWorkerNodes[i].toString());
            if (i == this.dfsWorkerNodes.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public String getPartitionkeys() {
        StringBuffer sb = new StringBuffer();
        if (this.hashKeys == null) {
            return null;
        }
        for (int i = 0; i < this.hashKeys.length; ++i) {
            sb.append(this.hashKeys[i].getFieldName());
            if (i == this.hashKeys.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new RdOutCommand(source, this.dfsWorkerNodes, this.hashKeys, this.partitionMethod);
    }

    public CommandNode setSource(CommandNode source, HostPort[] dfsHostPort) {
        return new RdOutCommand(source, dfsHostPort, this.hashKeys, this.partitionMethod);
    }

    public HostPort[] getDfsWorkerNodes() {
        return this.dfsWorkerNodes;
    }

    public String getPartitionMethodAsString() {
        String partition;
        switch (this.partitionMethod) {
            case Hash: {
                partition = "hash";
                break;
            }
            case Range: {
                partition = "range";
                break;
            }
            case VirtualPartitioning: {
                partition = "vpc";
                break;
            }
            case Serial: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return partition;
    }

    public String getNumberOfIntermediaries() {
        return String.valueOf(this.dfsWorkerNodes.length);
    }

    public RDPartition getPartitionMethod() {
        return this.partitionMethod;
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
    }
}

