/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.SubsearchVisitor;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

public class DatasetsVisitor
extends SplunkCommandParserBaseVisitor<Dataset> {
    private static final Pattern safeChars = Pattern.compile("^\"[a-zA-Z\\_\\*\\.0-9]*\"$");

    @Override
    public Dataset visitUnnamedDataset(SplunkCommandParser.UnnamedDatasetContext ctx) {
        return new TransientDataset((CommandNode)new SubsearchVisitor().visit((ParseTree)ctx.subsearchParse()));
    }

    @Override
    public Dataset visitNamedDataset(SplunkCommandParser.NamedDatasetContext ctx) {
        String datasetName;
        StringBuilder builder = new StringBuilder();
        if (ctx.datasetType() != null) {
            builder.append(ctx.datasetType().getText()).append(":");
        }
        if (safeChars.matcher(datasetName = ctx.datasetName().getText()).matches()) {
            builder.append(datasetName.replaceAll("^\"|\"$", ""));
        } else {
            builder.append(datasetName);
        }
        return new Dataset(builder.toString());
    }
}

