/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

public class AddPartitionDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    String dbName;
    String location;
    boolean ifNotExists;
    boolean expectView;
    LinkedHashMap<String, String> partSpec;
    Map<String, String> partParams;
    String inputFormat = null;
    String outputFormat = null;
    int numBuckets = -1;
    List<FieldSchema> cols = null;
    String serializationLib = null;
    Map<String, String> serdeParams = null;
    List<String> bucketCols = null;
    List<Order> sortCols = null;

    public AddPartitionDesc() {
    }

    public AddPartitionDesc(String dbName, String tableName, Map<String, String> partSpec, String location, Map<String, String> params) {
        this(dbName, tableName, partSpec, location, true, false);
        this.partParams = params;
    }

    public AddPartitionDesc(String dbName, String tableName, Map<String, String> partSpec, String location, boolean ifNotExists, boolean expectView) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.partSpec = new LinkedHashMap<String, String>(partSpec);
        this.location = location;
        this.ifNotExists = ifNotExists;
        this.expectView = expectView;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Explain(displayName="Location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public LinkedHashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    @Explain(displayName="Spec")
    public String getPartSpecString() {
        return this.partSpec.toString();
    }

    public void setPartSpec(LinkedHashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public Map<String, String> getPartParams() {
        return this.partParams;
    }

    public void setPartParams(Map<String, String> partParams) {
        this.partParams = partParams;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    public List<FieldSchema> getCols() {
        return this.cols;
    }

    public void setCols(List<FieldSchema> cols) {
        this.cols = cols;
    }

    public String getSerializationLib() {
        return this.serializationLib;
    }

    public void setSerializationLib(String serializationLib) {
        this.serializationLib = serializationLib;
    }

    public Map<String, String> getSerdeParams() {
        return this.serdeParams;
    }

    public void setSerdeParams(Map<String, String> serdeParams) {
        this.serdeParams = serdeParams;
    }

    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(List<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(List<Order> sortCols) {
        this.sortCols = sortCols;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean getExpectView() {
        return this.expectView;
    }

    public void setExpectView(boolean expectView) {
        this.expectView = expectView;
    }
}

