/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.mr.input.VirtualIndex;
import com.splunk.roll.Bucket;
import com.splunk.roll.PathResolverV1;
import com.splunk.roll.PathResolverV2;
import com.splunk.roll.PathResolverV3;
import com.splunk.roll.util.ConfU;
import com.splunk.roll.util.TimeRange;
import com.splunk.util.ConcatenatesIterators;
import com.splunk.util.HdfsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public abstract class PathResolver {
    private static final String VERSION_DELIMITER = "_v";
    private static final Logger gLogger = Logger.getLogger(PathResolver.class);
    public static final int DEFAULT_VERSION = 3;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final int[] VERSIONS = new int[]{3, 2, 1};
    private final Path rollRoot;
    private final int version;

    public PathResolver(Path rollRoot, int version) {
        this.rollRoot = rollRoot;
        this.version = version;
    }

    private static String getVersionedRoot(Path rollRoot, int version) {
        return new Path(rollRoot.getParent(), rollRoot.getName() + VERSION_DELIMITER + String.valueOf(version)).toUri().toString();
    }

    int getVersion() {
        return this.version;
    }

    public Path findBucket(Configuration conf, Bucket.LocalBucket bucket) throws IOException {
        List<Integer> versions = this.getVersions(conf);
        for (Integer version : versions) {
            Path resolvedPath = PathResolver.createWithVersion(conf, version).resolvePath(bucket);
            if (!resolvedPath.getFileSystem(conf).exists(resolvedPath)) continue;
            return resolvedPath;
        }
        return null;
    }

    List<Integer> getVersions(Configuration conf) throws IOException {
        FileStatus[] ls;
        ArrayList<Integer> versions = new ArrayList<Integer>();
        Path rollRootParent = this.rollRoot.getParent();
        FileSystem fs = rollRootParent.getFileSystem(conf);
        for (FileStatus f : ls = HdfsUtil.ls(fs, rollRootParent, new PathFilter(){

            public boolean accept(Path p) {
                return p.getName().startsWith(PathResolver.this.rollRoot.getName() + PathResolver.VERSION_DELIMITER);
            }
        })) {
            Path path = f.getPath();
            Object[] split = path.getName().split(VERSION_DELIMITER);
            if (split.length == 2) {
                try {
                    versions.add(Integer.parseInt(split[1]));
                }
                catch (Exception e) {
                    gLogger.warn((Object)("Could not parse version number from path=" + path + " split=" + Arrays.toString(split)));
                }
                continue;
            }
            gLogger.warn((Object)("Cannot parse version number from path=" + path + " because the splitting the name by the version delimiter resulted in more than 2 splits=" + Arrays.toString(split) + ". Ignoring path=" + path));
        }
        return versions;
    }

    private List<Integer> getVersionsUnchecked(Configuration conf) {
        try {
            return this.getVersions(conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path resolvePath(Bucket b) {
        Path resolvedPath = new Path(this.doResolvePath(b, PathResolver.getVersionedRoot(this.rollRoot, this.version)));
        this.verifyCorrectlyResolvedPath(resolvedPath);
        return resolvedPath;
    }

    private void verifyCorrectlyResolvedPath(Path resolvedPath) {
        if (!resolvedPath.toUri().toString().startsWith(this.rollRoot.toUri().toString())) {
            throw new RuntimeException("PathResolver implementations must resolve paths which start with: " + this.rollRoot + ", was: " + resolvedPath.toUri().toString());
        }
    }

    protected abstract String doResolvePath(Bucket var1, String var2);

    public Iterable<Bucket.RemoteBucket> resolveBuckets(FileSystem fs) {
        return this.resolveBuckets(fs, null, TimeRange.ALL_TIME);
    }

    public Iterable<Bucket.RemoteBucket> resolveBuckets(FileSystem fs, String index, TimeRange range) {
        ArrayList<Iterator<Iterator<Bucket.RemoteBucket>>> iterators = new ArrayList<Iterator<Iterator<Bucket.RemoteBucket>>>();
        for (int version : this.getVersionsUnchecked(fs.getConf())) {
            iterators.add(PathResolver.createWithVersion(fs.getConf(), version).doResolveBuckets(fs, index, range, PathResolver.getVersionedRoot(this.rollRoot, version)).iterator());
        }
        final ConcatenatesIterators remoteBuckets = new ConcatenatesIterators(iterators);
        return new Iterable<Bucket.RemoteBucket>(){

            @Override
            public Iterator<Bucket.RemoteBucket> iterator() {
                return new VirtualIndex.DedupIterator<Bucket.RemoteBucket>(remoteBuckets, new HashSet<String>(), new VirtualIndex.DedupIterator.StringId<Bucket.RemoteBucket>(){

                    @Override
                    public String getId(Bucket.RemoteBucket b) {
                        String sep = "~!-";
                        return b.getIndex() + sep + b.getNumber() + sep + b.getServerGuid();
                    }
                });
            }
        };
    }

    protected abstract Iterable<Bucket.RemoteBucket> doResolveBuckets(FileSystem var1, String var2, TimeRange var3, String var4);

    public static PathResolver create(Configuration conf) {
        int version = ConfU.getPathResolverVersion(conf);
        return PathResolver.createWithVersion(conf, version);
    }

    public static PathResolver createWithVersion(Configuration conf, int version) {
        switch (version) {
            case 1: {
                return PathResolver.createV1(conf);
            }
            case 2: {
                return PathResolver.createV2(conf);
            }
            case 3: {
                return PathResolver.createV3(conf);
            }
        }
        throw new RuntimeException("Does not support path resolver version: " + version);
    }

    private static PathResolverV1 createV1(Configuration conf) {
        return new PathResolverV1(ConfU.getRollRoot(conf), conf.getLong("splunk.roll.path.resolver.1.early-mod-time", 604800L));
    }

    private static PathResolver createV2(Configuration conf) {
        return PathResolverV2.createWithDefaults(ConfU.getRollRoot(conf), conf);
    }

    private static PathResolver createV3(Configuration conf) {
        return PathResolverV3.createWithDefaults(ConfU.getRollRoot(conf), conf);
    }

    public static String getNormalizedBucketName(String bucketName) {
        if (Bucket.isReplicated(bucketName)) {
            return bucketName.replaceFirst("rb", "db");
        }
        return bucketName;
    }
}

