/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.FileStatusExt;
import com.splunk.mr.input.TimeRange;
import com.splunk.util.ReflectionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.ParquetInputSplit;

public class VixInputSplit
extends InputSplit
implements Writable {
    public static final String DEFAULT_BUCKET_ID = "_no_id";
    private static Logger gLogger = Logger.getLogger(VixInputSplit.class);
    protected Map<String, String> _fields = null;
    protected Map<String, String> _extra = new HashMap<String, String>();
    protected String _inputId = null;
    protected long _et = 0L;
    protected long _lt = Long.MAX_VALUE;
    protected long _mt = 0L;
    protected String _inputFormatClass = "";
    protected InputSplit _split = null;
    protected transient BaseSplunkRecordReader _reader = null;
    protected String _bucketId = "_no_id";
    protected boolean dmaSplit = false;
    static HashMap<String, String> CLASS2ID = new HashMap();
    static HashMap<String, String> ID2CLASS = new HashMap();

    protected VixInputSplit() {
        this._fields = new HashMap<String, String>();
    }

    public VixInputSplit(InputSplit fs, FileStatusExt fse) throws IOException {
        if (fse == null || fse.getFields() == null) {
            throw new IllegalArgumentException("Fields cannot be null");
        }
        this._split = fs;
        this._fields = new HashMap<String, String>();
        this._fields.putAll(fse.getFields());
        this._inputId = fse.getInputId();
        this._mt = fse.getModificationTime() / 1000L;
        this._et = fse.getEarliestTime();
        this._lt = fse.getLatestTime();
        if (fse.getBucketId() != null) {
            this._bucketId = fse.getBucketId();
        }
    }

    public void setRecordReader(BaseSplunkRecordReader reader) {
        this._reader = reader;
    }

    public BaseSplunkRecordReader getRecordReader() {
        return this._reader;
    }

    public String getInputFormatClass() {
        return this._inputFormatClass;
    }

    public String getInputId() {
        return this._inputId;
    }

    public String getIndex() {
        return this._fields.get("index");
    }

    public Map<String, String> getFields() {
        return this._fields;
    }

    public String getExtra(String key) {
        return this._extra.get(key);
    }

    public void putExtra(String key, String value) {
        this._extra.put(key, value);
    }

    public void setInputFormatClass(Class klass) {
        if (!org.apache.hadoop.mapred.InputFormat.class.isAssignableFrom(klass) && !InputFormat.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Invalid input format class: " + klass.getName());
        }
        this._inputFormatClass = klass.getName();
    }

    public void setHeaderField(String name, String value) {
        this._fields.put(name, value);
    }

    public InputSplit getSplit() {
        return this._split;
    }

    public String getBucketId() {
        return this._bucketId;
    }

    public String getSplitId() {
        return VixInputSplit.getSplitId(this.getIndex(), this._split);
    }

    public String toString() {
        return VixInputSplit.getSplitString(this._split);
    }

    public static String getSplitId(String index, InputSplit is) {
        if (index == null) {
            return MD5Hash.digest((String)VixInputSplit.getSplitString(is)).toString();
        }
        return MD5Hash.digest((String)(index + ":" + VixInputSplit.getSplitString(is))).toString();
    }

    public static String getSplitString(InputSplit is) {
        if (FileSplit.class.isAssignableFrom(is.getClass())) {
            FileSplit fis = (FileSplit)is;
            return fis.getPath().toUri().getPath() + ":" + fis.getStart() + "+" + fis.getLength();
        }
        try {
            if (ParquetInputSplit.class.isAssignableFrom(is.getClass())) {
                ParquetInputSplit pis = (ParquetInputSplit)is;
                return pis.getPath().toUri().getPath() + ":" + pis.getStart() + "+" + pis.getLength();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return is.toString();
    }

    public long getLength() {
        try {
            return this._split.getLength();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getLocations() {
        try {
            return this._split.getLocations();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public Path getPath() {
        if (this._split instanceof FileSplit) {
            return ((FileSplit)this._split).getPath();
        }
        try {
            Method m = this._split.getClass().getDeclaredMethod("getPath", new Class[0]);
            return (Path)m.invoke((Object)this._split, new Object[0]);
        }
        catch (Exception e) {
            gLogger.warn((Object)("Failed to get split path, splitClassName=" + this._split.getClass().getName() + ": " + e.getMessage()));
            return null;
        }
    }

    @Deprecated
    public long getStart() {
        if (this._split instanceof FileSplit) {
            return ((FileSplit)this._split).getStart();
        }
        try {
            Method m = this._split.getClass().getDeclaredMethod("getStart", new Class[0]);
            return (Long)m.invoke((Object)this._split, new Object[0]);
        }
        catch (Exception e) {
            gLogger.warn((Object)("Failed to get split starting point, splitClassName=" + this._split.getClass().getName() + ": " + e.getMessage()));
            return 0L;
        }
    }

    public long getEarliestTime() {
        return this._et;
    }

    public long getLatestTime() {
        return this._lt;
    }

    public Date getLatestTimeAsDate() {
        return this.secsAsDate(this.getLatestTime());
    }

    public Date getEarliestTimeAsDate() {
        return this.secsAsDate(this.getEarliestTime());
    }

    private Date secsAsDate(long secs) {
        if (secs == Long.MAX_VALUE) {
            return new Date(Long.MAX_VALUE);
        }
        return new Date(TimeUnit.MILLISECONDS.convert(secs, TimeUnit.SECONDS));
    }

    public long getModTime() {
        return this._mt;
    }

    public void setEarliestTime(long t) {
        this._et = t;
    }

    public void setLatestTime(long t) {
        this._lt = t;
    }

    public void setModTime(long t) {
        this._mt = t;
    }

    public void write(DataOutput out) throws IOException {
        String cid = CLASS2ID.get(this._split.getClass().getName());
        if (cid == null) {
            cid = this._split.getClass().getName();
        }
        Text.writeString((DataOutput)out, (String)cid);
        ((Writable)this._split).write(out);
        Text.writeString((DataOutput)out, (String)this._inputId);
        Text.writeString((DataOutput)out, (String)this._inputFormatClass);
        WritableUtils.writeVLong((DataOutput)out, (long)this._et);
        WritableUtils.writeVLong((DataOutput)out, (long)this._lt);
        WritableUtils.writeVLong((DataOutput)out, (long)this._mt);
        Text.writeString((DataOutput)out, (String)this._bucketId);
        WritableUtils.writeVInt((DataOutput)out, (int)this._fields.size());
        for (Map.Entry<String, String> me : this._fields.entrySet()) {
            Text.writeString((DataOutput)out, (String)me.getKey());
            Text.writeString((DataOutput)out, (String)me.getValue());
        }
        WritableUtils.writeVInt((DataOutput)out, (int)this._extra.size());
        for (Map.Entry<String, String> me : this._extra.entrySet()) {
            Text.writeString((DataOutput)out, (String)me.getKey());
            Text.writeString((DataOutput)out, (String)me.getValue());
        }
        WritableUtils.writeString((DataOutput)out, (String)Boolean.toString(this.dmaSplit));
    }

    public void readFields(DataInput in) throws IOException {
        String cid = Text.readString((DataInput)in);
        if (ID2CLASS.containsKey(cid)) {
            cid = ID2CLASS.get(cid);
        }
        this._split = (InputSplit)ReflectionUtil.newInstance(cid, new Object[0]);
        ((Writable)this._split).readFields(in);
        this._inputId = Text.readString((DataInput)in);
        this._inputFormatClass = Text.readString((DataInput)in);
        this._et = WritableUtils.readVLong((DataInput)in);
        this._lt = WritableUtils.readVLong((DataInput)in);
        this._mt = WritableUtils.readVLong((DataInput)in);
        this._bucketId = Text.readString((DataInput)in);
        int fieldCount = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < fieldCount; ++i) {
            this._fields.put(Text.readString((DataInput)in), Text.readString((DataInput)in));
        }
        int extraCount = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < extraCount; ++i) {
            this._extra.put(Text.readString((DataInput)in), Text.readString((DataInput)in));
        }
        this.dmaSplit = Boolean.parseBoolean(WritableUtils.readString((DataInput)in));
    }

    public boolean isWithinTimeRange(TimeRange searchTimeRange) {
        boolean earlyMatch = this.getEarliestTime() >= searchTimeRange.et;
        boolean lateMatch = this.getLatestTime() <= searchTimeRange.lt;
        return earlyMatch && lateMatch;
    }

    public boolean isDmaSplit() {
        return this.dmaSplit;
    }

    public void setDmaSplit(boolean dmaSplit) {
        this.dmaSplit = dmaSplit;
    }

    static {
        CLASS2ID.put(FileSplit.class.getName(), "0");
        for (Map.Entry<String, String> me : CLASS2ID.entrySet()) {
            ID2CLASS.put(me.getValue(), me.getKey());
        }
    }
}

