/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.visitors.CommandRebuilder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class StatsExpanderVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(StatsExpanderVisitor.class);

    public CommandNode visit(CommandNode node) {
        return node;
    }

    public CommandNode visit(StatsCommand node) {
        AggregateNode aggNode;
        int i;
        int length = node.getAggregates().size();
        LinkedList<Object> aggregatesList = new LinkedList<Object>();
        LinkedHashMap aggMap = new LinkedHashMap();
        for (i = 0; i < length; ++i) {
            aggNode = (AggregateNode)node.getAggregates().get(i);
            if (aggNode.getFunction() == AggregateFunction.ALL || aggNode.getFunction() == AggregateFunction.DEFAULT) {
                LinkedHashMap<AggregateFunction, AggregateNode> tempMap = new LinkedHashMap<AggregateFunction, AggregateNode>();
                for (int j = 0; j < AggregateFunction.ALL_AGGFUNCTIONS.length; ++j) {
                    String asName = AggregateFunction.ALL_AGGFUNCTIONS[j].toString() + "(" + aggNode.getField().getFieldName() + ")";
                    AggregateNode newAggNode = new AggregateNode(AggregateFunction.ALL_AGGFUNCTIONS[j], aggNode.getField(), asName);
                    tempMap.put(AggregateFunction.ALL_AGGFUNCTIONS[j], newAggNode);
                }
                aggMap.put(aggNode.getField().getFieldName(), tempMap);
                continue;
            }
            aggregatesList.add(aggNode);
        }
        for (i = 0; i < length; ++i) {
            AggregateNode tempNode;
            aggNode = (AggregateNode)node.getAggregates().get(i);
            if (aggNode.getFunction() == AggregateFunction.ALL || aggNode.getFunction() == AggregateFunction.DEFAULT) continue;
            String fieldName = null;
            if (aggNode.getField() != null) {
                fieldName = aggNode.getField().getFieldName();
                logger.debug((Object)String.format("using aggregator node field name: %s", fieldName));
            } else if (aggNode.getAsField() != null) {
                fieldName = aggNode.getAsField().getFieldName();
                logger.debug((Object)String.format("using aggregator node as-field name since field name was not found: %s", fieldName));
            }
            if (fieldName == null) {
                throw new RuntimeException(String.format("could not find field name in the aggregator node: %s", aggNode.getDefaultName()));
            }
            Map tempMap = (Map)aggMap.get(fieldName);
            if (tempMap == null || (tempNode = (AggregateNode)tempMap.get(aggNode.getFunction())) == null) continue;
            tempMap.remove(aggNode.getFunction());
            if (tempMap.size() != 0) continue;
            aggMap.remove(aggNode.getField().getFieldName());
        }
        for (Map.Entry entry : aggMap.entrySet()) {
            for (Map.Entry inner_entry : ((Map)entry.getValue()).entrySet()) {
                aggregatesList.add(inner_entry.getValue());
            }
        }
        AggregateNode[] aggregates = new AggregateNode[aggregatesList.size()];
        aggregates = aggregatesList.toArray(aggregates);
        return new StatsCommand(node.getSource(), Arrays.asList(aggregates), node.getByFields(), node.getPartitions(), node.getAllnum(), node.getDelim(), false, node.getFieldPropertiesArray(), node.isPreComputed());
    }
}

