/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandSourceKind;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.df.util.TimeParser;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class IndexDetectorVisitor
extends NodeVisitor<Object> {
    public static final String LATEST = "latest";
    public static final String EARLIEST = "earliest";
    private Date globalEarliest;
    private Date globalLatest;
    private Date globalNow;
    private Vector<DateIndexContainer> dateIndexContainerVector = new Vector();
    private Map<String, IndexSpecifier> indexSpecifierMap = new HashMap<String, IndexSpecifier>();
    private boolean isIntervalsMerged = false;
    HashSet<String> index = new HashSet();

    public Map<String, IndexSpecifier> getIndexSpecifierVector() {
        if (this.dateIndexContainerVector == null) {
            return null;
        }
        if (this.isIntervalsMerged && this.indexSpecifierMap != null) {
            return this.indexSpecifierMap;
        }
        assert (this.globalEarliest != null);
        assert (this.globalLatest != null);
        for (DateIndexContainer dateIndexContainer : this.dateIndexContainerVector) {
            Map map = dateIndexContainer.getMap();
            for (Map.Entry entry : map.entrySet()) {
                Date latest;
                Date earliest = dateIndexContainer.getEarliest() == null ? this.globalEarliest : dateIndexContainer.getEarliest();
                Date date = latest = dateIndexContainer.getLatest() == null ? this.globalLatest : dateIndexContainer.getLatest();
                if (!this.indexSpecifierMap.containsKey(entry.getKey())) {
                    IndexSpecifier newObj = new IndexSpecifier((String)entry.getKey(), (Integer)entry.getValue(), earliest, latest);
                    this.indexSpecifierMap.put((String)entry.getKey(), newObj);
                    continue;
                }
                IndexSpecifier obj = this.indexSpecifierMap.get(entry.getKey());
                obj.addInterval(earliest, latest);
                obj.addCount((Integer)entry.getValue());
            }
        }
        for (Map.Entry entry : this.indexSpecifierMap.entrySet()) {
            IndexSpecifier indexSpecifier = (IndexSpecifier)entry.getValue();
            indexSpecifier.replaceMergedIntervals();
        }
        this.isIntervalsMerged = true;
        return this.indexSpecifierMap;
    }

    public IndexDetectorVisitor(Date e, Date l) {
        this.globalEarliest = e;
        this.globalLatest = l;
        this.globalNow = new Date();
    }

    public IndexDetectorVisitor() {
        this.globalEarliest = new Date(1L);
        this.globalLatest = new Date();
        this.globalNow = new Date();
    }

    public Object visit(Node node) {
        return null;
    }

    public CommandNode visit(CommandNode node) {
        CommandNode[] x = node.getSources();
        for (int i = 0; i < x.length; ++i) {
            Object object = x[i].accept((NodeVisitor)this);
        }
        return null;
    }

    public Object visit(SearchCommand node) {
        if (node.getCommandSourceKind() != CommandSourceKind.GENERATING && node.getPredicate() == null) {
            return null;
        }
        IPredicate predicate = node.getPredicate();
        Object obj = predicate.getNode().accept((NodeVisitor)this);
        if (obj instanceof DateIndexContainer) {
            this.dateIndexContainerVector.add((DateIndexContainer)obj);
        }
        return null;
    }

    public Object visit(SearchFunctionNode node) {
        List arguments = node.getArguments();
        DateIndexContainer dateIndexContainer = new DateIndexContainer();
        boolean dataindexpresent = false;
        for (int x = 0; x < arguments.size(); ++x) {
            Object obj = ((SearchNode)arguments.get(x)).accept((NodeVisitor)this);
            if (obj instanceof DateIndexContainer) {
                dateIndexContainer.merge((DateIndexContainer)obj);
                dataindexpresent = true;
                continue;
            }
            if (obj instanceof Index) {
                Index i = (Index)obj;
                dateIndexContainer.add(i.get());
                dataindexpresent = true;
                continue;
            }
            if (obj instanceof Earliest) {
                Earliest e = (Earliest)obj;
                dateIndexContainer.addEarliest(e.get());
                dataindexpresent = true;
                continue;
            }
            if (!(obj instanceof Latest)) continue;
            Latest l = (Latest)obj;
            dateIndexContainer.addLatest(l.get());
            dataindexpresent = true;
        }
        if (dataindexpresent) {
            return dateIndexContainer;
        }
        return null;
    }

    public Object visit(SearchComparisonNode node) {
        FieldNode lhs = node.getLhs();
        TypeNode rhs = node.getRhs();
        Operator operator = node.getOperator();
        Object returnObject = null;
        switch (lhs.getFieldName()) {
            case "index": {
                if (operator != Operator.EQUAL_EQUAL) break;
                returnObject = new Index(((StringNode)rhs).getValue());
                break;
            }
            case "_time": {
                switch (operator) {
                    case EQUAL: 
                    case EQUAL_EQUAL: 
                    case NOT_EQUAL: {
                        break;
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        returnObject = new Earliest(((StringNode)rhs).getValue(), this.globalNow);
                        break;
                    }
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        returnObject = new Latest(((StringNode)rhs).getValue(), this.globalNow);
                    }
                }
                break;
            }
            case "earliest": {
                if (operator != Operator.EQUAL_EQUAL) break;
                returnObject = new Earliest(((StringNode)rhs).getValue(), this.globalNow);
                break;
            }
            case "latest": {
                if (operator != Operator.EQUAL_EQUAL) break;
                returnObject = new Latest(((StringNode)rhs).getValue(), this.globalNow);
            }
        }
        return returnObject;
    }

    public static class DateIndexContainer {
        Map<String, Integer> map = new HashMap<String, Integer>();
        Date earliest;
        Date latest;

        public void add(String x) {
            this.add(x, 1);
        }

        public void add(String x, int i) {
            if (this.map.containsKey(x)) {
                this.map.put(x, this.map.get(x) + i);
            } else {
                this.map.put(x, i);
            }
        }

        public void addEarliest(Date date) {
            if (this.earliest == null) {
                this.earliest = date;
            }
            if (date != null && date.getTime() < this.earliest.getTime()) {
                this.earliest = date;
            }
        }

        public void addLatest(Date date) {
            if (this.latest == null) {
                this.latest = date;
            }
            if (date != null && date.getTime() > this.latest.getTime()) {
                this.latest = date;
            }
        }

        public Date getEarliest() {
            return this.earliest;
        }

        private Date getLatest() {
            return this.latest;
        }

        private Map<String, Integer> getMap() {
            return this.map;
        }

        public void merge(DateIndexContainer obj) {
            this.addEarliest(obj.getEarliest());
            this.addLatest(obj.getLatest());
            for (Map.Entry<String, Integer> entry : obj.getMap().entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public static class Latest {
        Date date;

        public Latest(String x, Date now) {
            this.date = new TimeParser(x, now).getTime();
        }

        public Date get() {
            return this.date;
        }
    }

    public static class Earliest {
        Date date;

        public Earliest(String x, Date now) {
            this.date = new TimeParser(x, now).getTime();
        }

        public Date get() {
            return this.date;
        }
    }

    public static class Index {
        String name;

        public Index(String x) {
            this.name = x;
        }

        public String get() {
            return this.name;
        }
    }

    public static class IndexSpecifier {
        LinkedList<Interval> intervals;
        String indexName;
        IndexType indexType = IndexType.EVENTS;
        Integer count;
        boolean isIntervalsMerged = false;

        public IndexSpecifier(String index, Integer c, final Date earliest, final Date latest) {
            this.indexName = index;
            this.count = c;
            this.intervals = new LinkedList<Interval>(){
                {
                    this.add(new Interval(earliest, latest));
                }
            };
        }

        public void addInterval(Date earliest, Date latest) {
            this.intervals.add(new Interval(earliest, latest));
        }

        public void addCount(Integer c) {
            this.count = this.count + c;
        }

        private void replaceMergedIntervals() {
            Collections.sort(this.intervals);
            LinkedList<Interval> mergedlist = new LinkedList<Interval>();
            while (this.intervals.size() != 0) {
                Interval temp = this.intervals.poll();
                Interval top = this.intervals.peek();
                if (top == null || temp.latest.getTime() < top.earliest.getTime()) {
                    mergedlist.add(temp);
                    continue;
                }
                Interval newtemp = temp.latest.getTime() > top.latest.getTime() ? temp : new Interval(temp.earliest, top.latest);
                this.intervals.poll();
                this.intervals.addFirst(newtemp);
            }
            this.intervals = mergedlist;
            this.isIntervalsMerged = true;
        }

        public class Interval
        implements Comparable<Interval> {
            Date earliest;
            Date latest;

            public Interval(Date e, Date l) {
                this.earliest = e;
                this.latest = l;
            }

            @Override
            public int compareTo(Interval obj) {
                if (this.earliest == null) {
                    return -1;
                }
                if (obj.earliest == null) {
                    return 1;
                }
                if (this.earliest.getTime() < obj.earliest.getTime()) {
                    return -1;
                }
                if (this.earliest.getTime() > obj.earliest.getTime()) {
                    return 1;
                }
                if (this.earliest.getTime() == obj.earliest.getTime()) {
                    if (this.latest.getTime() < obj.latest.getTime()) {
                        return -1;
                    }
                    return 1;
                }
                return 1;
            }
        }
    }

    public static enum IndexType {
        EVENTS;

    }
}

