/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import org.apache.log4j.Logger;

public class TimeAndValAggregateValue
implements AggregateValue {
    static final Logger logger = Logger.getLogger(TimeAndValAggregateValue.class);
    private Double time = null;
    private Object val = null;
    private COMPARE_FUNCTION compareFunction;

    private TimeAndValAggregateValue(COMPARE_FUNCTION compareFunction) {
        this.compareFunction = compareFunction;
        this.time = compareFunction == COMPARE_FUNCTION.EARLIEST ? Double.MAX_VALUE : Double.MIN_VALUE;
    }

    public static TimeAndValAggregateValue getInstance(COMPARE_FUNCTION compareFunction) {
        return new TimeAndValAggregateValue(compareFunction);
    }

    @Override
    public AggregateValue accumulate(Object item) {
        assert (item instanceof Pair);
        Pair timeValPair = (Pair)item;
        this.compareAndSet(timeValPair);
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof TimeAndValAggregateValue);
        Pair timeValPair = (Pair)aggregateValue.getValue();
        this.compareAndSet(timeValPair);
        return this;
    }

    private void compareAndSet(Pair<Double, Object> timeValPair) {
        boolean cmpResult;
        boolean bl = this.compareFunction == COMPARE_FUNCTION.EARLIEST ? this.time > timeValPair.first() : (cmpResult = this.time < timeValPair.first());
        if (cmpResult) {
            this.time = timeValPair.first();
            this.val = timeValPair.second();
        }
    }

    @Override
    public Object getValue() {
        return new Pair<Double, Object>(this.time, this.val);
    }

    public static enum COMPARE_FUNCTION {
        EARLIEST,
        LATEST;

    }
}

