/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.SearchResultsReader;
import com.splunk.df.search.compute.SearchResult;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class DatasetDumpComparator {
    static Logger logger = null;
    private String lhs;
    private String rhs;

    public DatasetDumpComparator(String lhs, String rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public void printDifferences() {
        try {
            logger.info((Object)String.format(">>>> comparing dump files: %s and %s", this.lhs, this.rhs));
            Iterator<SearchResult> lhsSrs = new SearchResultsReader(new InputStreamReader(new FileInputStream(this.lhs)));
            Iterator<SearchResult> rhsSrs = new SearchResultsReader(new InputStreamReader(new FileInputStream(this.rhs)));
            HashSet lhsMap = new HashSet();
            int lhsCount = 0;
            logger.info((Object)String.format("creating lhs map from records ...", new Object[0]));
            while (lhsSrs.hasNext()) {
                lhsMap.add(lhsSrs.next());
                ++lhsCount;
            }
            logger.info((Object)String.format("created lhs map from records: %d, map contains: %d records", lhsCount, lhsMap.size()));
            logger.info((Object)String.format("creating rhs map from records ...", new Object[0]));
            HashSet rhsMap = new HashSet();
            int rhsCount = 0;
            while (rhsSrs.hasNext()) {
                rhsMap.add(rhsSrs.next());
                ++rhsCount;
            }
            logger.info((Object)String.format("created rhs map from records: %d, map contains: %d records", rhsCount, rhsMap.size()));
            boolean different = false;
            if (lhsCount != rhsCount) {
                logger.info((Object)String.format("record count varies: lhs count: %d, rhs count: %d", lhsCount, rhsCount));
                different = true;
            } else {
                logger.info((Object)String.format("record counts are same: %d", lhsCount));
            }
            if (lhsMap.size() != rhsMap.size()) {
                logger.info((Object)String.format("unique record counts vary: lhs map: %d, rhs map: %d", lhsMap.size(), rhsMap.size()));
                different = true;
            } else {
                logger.info((Object)String.format("unique record counts are same: %d", lhsMap.size()));
            }
            logger.info((Object)String.format("reading lhs map records and comparing with rhs map records ...", new Object[0]));
            lhsSrs = lhsMap.iterator();
            int diffCount = 0;
            int diffCutoff = 10;
            SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{SearchResult.FieldMeta.newFieldMeta("FlightNum"), SearchResult.FieldMeta.newFieldMeta("L.ArrTime"), SearchResult.FieldMeta.newFieldMeta("R.AirTime")};
            while (lhsSrs.hasNext()) {
                SearchResult sr = lhsSrs.next();
                if (rhsMap.contains(sr)) continue;
                different = true;
                if (++diffCount >= diffCutoff) continue;
                logger.info((Object)String.format("in lhs but not in rhs: %s, hash code: %d", sr.toString(), DatasetDumpComparator.hashCode(sr, fields)));
            }
            logger.info((Object)String.format("number of cases where lhs not in rhs: %d, just printed based on cutoff: %d", diffCount, diffCutoff));
            diffCount = 0;
            logger.error((Object)String.format("reading rhs map records and comparing with lhs map records ...", new Object[0]));
            for (SearchResult sr : rhsMap) {
                if (lhsMap.contains(sr)) continue;
                different = true;
                if (++diffCount >= diffCutoff) continue;
                logger.info((Object)String.format("in rhs but not in lhs: %s, hash code: %d", sr.toString(), DatasetDumpComparator.hashCode(sr, fields)));
            }
            logger.info((Object)String.format("number of cases where rhs not in lhs: %d, just printed based on cutoff: %d", diffCount, diffCutoff));
            logger.info((Object)String.format("processed lhs records: %d, rhs records: %d, lhs map: %d, rhs map: %d, found differences: %b", lhsCount, rhsCount, lhsMap.size(), rhsMap.size(), different));
        }
        catch (Throwable t) {
            logger.error((Object)String.format("error while finding diferences in dataset dump files: %s", t.getMessage()), t);
            throw new RuntimeException("error while getting differences between search results dumps", t);
        }
    }

    private static int hashCode(SearchResult srs, SearchResult.FieldMeta[] fieldNames) {
        int hashCode = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            SearchResult.FieldMeta fieldName = fieldNames[i];
            Object fieldValue = srs.getFieldValue(fieldName);
            hashCode = 31 * hashCode + (fieldName != null ? fieldName.hashCode() : 0);
            hashCode = 31 * hashCode + (fieldValue != null ? fieldValue.hashCode() : 0);
        }
        return hashCode;
    }

    public static void main(String[] args) {
        new DatasetDumpComparator(args[0], args[1]).printDifferences();
    }

    static {
        PropertyConfigurator.configure((String)(System.getenv("SPARK_HOME") + "/conf/log4j.properties"));
        logger = Logger.getLogger(DatasetDumpComparator.class);
    }
}

