/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCCallable;
import com.splunk.df.search.DFCParams;
import com.splunk.df.search.DFSExecutorService;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.DFSSearchCoordinatorState;
import com.splunk.df.search.DFSSearchExecutor;
import com.splunk.df.search.SearchResultInfoUtils;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.spark.KryoRegisteredClassHolder;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.DFSLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.json.JSONException;
import org.json.JSONObject;
import scala.Tuple2;

public class DFSSearchCoordinator
implements DFSSearchConstants {
    static Logger logger = DFSLogger.getLogger(DFSSearchCoordinator.class);
    private final String dfcId;
    private int dfsCoordinatorPort;
    private final int dfsMasterPort;
    private final int dfcReceiverPort;
    private final int dfcReceiverPortCount;
    private JavaSparkContext jsc = null;
    private String initialSid;
    private final int dfcNumCores;
    private final int dfcNumExecutors;
    private final int dfcExecutorMemMbs;
    private final int dfcDriverMemMbs;
    private final int dfcNumConcurrentSearches;
    private final long maxReducePartitionSize;
    private final SplunkReleaseVersion splunkVersion;
    private final String splunkConf;
    SearchResultInfoUtils searchResultInfoUtils;
    private final DFSExecutorService searchExecutorSes;

    public DFSSearchCoordinator(JavaSparkContext jsc, DFCParams dfcParams) {
        this.jsc = jsc;
        this.dfcId = dfcParams.getDfcId();
        this.dfsCoordinatorPort = dfcParams.getDfcPort();
        this.dfsMasterPort = dfcParams.getDfmMasterPort();
        this.maxReducePartitionSize = dfcParams.getMaxReducePartitionSize();
        this.dfcReceiverPort = dfcParams.getDfcReceiverPort();
        this.dfcReceiverPortCount = dfcParams.getDfcReceiverPortCount();
        this.initialSid = dfcParams.getSid();
        this.dfcNumCores = dfcParams.getDfcNumCores();
        this.dfcNumExecutors = dfcParams.getDfcNumExecutors();
        this.dfcExecutorMemMbs = dfcParams.getDfcExecutorMemMbs();
        this.dfcDriverMemMbs = dfcParams.getDfcDriverMemMbs();
        this.dfcNumConcurrentSearches = dfcParams.getDfcNumConcurrentSearches();
        this.searchExecutorSes = new DFSExecutorService();
        this.splunkVersion = new SplunkReleaseVersion(dfcParams.getSplunkVersion());
        this.splunkConf = dfcParams.getSplunkConf();
        logger.info((Object)String.format("executor memory mbs: %d, driver memory mbs: %d, num concurrent searches: %d", this.dfcExecutorMemMbs, this.dfcDriverMemMbs, this.dfcNumConcurrentSearches));
        this.startComputeEngineStateMonitoring();
    }

    public SplunkReleaseVersion getSplunkVersion() {
        return this.splunkVersion;
    }

    private void startComputeEngineStateMonitoring() {
        this.searchExecutorSes.submit(new DFCCallable(){

            @Override
            public Object runInternal() throws Exception {
                while (true) {
                    if (DFSSearchCoordinator.this.jsc.sc().isStopped()) {
                        DFSSearchCoordinator.this.informMasterDfcShutdown();
                        logger.warn((Object)String.format("dfc compute engine state is stopped hence will shutdown dfc for id: %s", DFSSearchCoordinator.this.dfcId));
                        System.exit(-1);
                    }
                    Thread.sleep(10000L);
                }
            }

            @Override
            public Object runOnFailure(Throwable throwable) throws Exception {
                return null;
            }
        });
    }

    private static long getMaxRdOutRecords() {
        long numRdoutRecs = 1000000000L;
        String temp = System.getenv("MAX_NUM_RDOUT_RECORDS");
        if (temp != null) {
            numRdoutRecs = Long.valueOf(temp);
        }
        return numRdoutRecs;
    }

    private static ServerSocket createListener(int port) {
        while (true) {
            if (port > 65535) {
                throw new DFSException("Max allowed port to start dfc listener is reached.");
            }
            try {
                return new ServerSocket(port, 0, InetAddress.getByName(null));
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Could not start dfc listener on port: %d, will retry with next available port", port));
                ++port;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ServerSocket listener = null;
        Socket socket = null;
        try {
            listener = DFSSearchCoordinator.createListener(this.dfsCoordinatorPort);
            this.dfsCoordinatorPort = listener.getLocalPort();
            logger.info((Object)String.format("Started DFC listener on: %s", listener.getLocalSocketAddress().toString()));
            this.informMasterDfcRunning();
            this.getSSLConfigFromDFM();
            while ((socket = listener.accept()) != null) {
                logger.debug((Object)String.format("Received connection on dfs search coordinator: %d", this.dfsCoordinatorPort));
                boolean keepalive = socket.getKeepAlive();
                if (!keepalive) {
                    socket.setKeepAlive(true);
                }
                final Socket temps = socket;
                final long startConnect = System.currentTimeMillis();
                this.searchExecutorSes.submit(new DFCCallable(){

                    @Override
                    protected Object runInternal() throws Exception {
                        StringBuilder input = new StringBuilder();
                        BufferedReader br = new BufferedReader(new InputStreamReader(temps.getInputStream(), StandardCharsets.UTF_8));
                        switch (DFSSearchCoordinator.this.checkRequest(br, input)) {
                            case PROTO_DFS_NEW_SEARCH_REQUEST: {
                                OutputStream rawos = temps.getOutputStream();
                                DFSSearchCoordinator.this.executeNewRequest(input, br, rawos, temps, startConnect);
                                break;
                            }
                            case PROTO_DFS_SHUTDOWN: {
                                DFSSearchCoordinator.this.executeShutDown(input);
                                break;
                            }
                            case PROTO_DFS_SEARCH_COORDINATOR_UPDATE: {
                                DFSSearchCoordinator.this.executeSearchUpdate();
                                break;
                            }
                            case PROTO_DFS_COORDINATOR_STATUS: {
                                DFSSearchCoordinator.this.executeCoordinatorStatusRequest(new BufferedWriter(new OutputStreamWriter(temps.getOutputStream())));
                                break;
                            }
                            case PROTO_DFS_MONITOR_REQ: {
                                break;
                            }
                            default: {
                                logger.error((Object)"Search sent incorrect message to DFS coordinator");
                                DFSSearchCoordinator.this.executeInvalidRequest();
                            }
                        }
                        return null;
                    }

                    @Override
                    protected Object runOnFailure(Throwable throwable) throws Exception {
                        SearchResultInfoUtils.sendAckError(Thread.currentThread(), temps.getOutputStream(), throwable);
                        DFSSearchCoordinator.this.informMasterDfcShutdown();
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Could not start dfc instance for id: %s", this.dfcId), t);
        }
        finally {
            try {
                if (listener != null) {
                    listener.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error Trying to close listener:" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    private static boolean canShutdownDfc() {
        boolean shutdown = true;
        String shutdownStr = System.getenv("DFS_CAN_SHUTDOWN_DFC");
        if (shutdownStr != null) {
            try {
                shutdown = Boolean.valueOf(shutdownStr);
            }
            catch (Throwable t) {
                logger.info((Object)String.format("could not parse can shutdown envvar: %s, reason: %s", shutdownStr, t.getMessage()));
            }
        }
        return shutdown;
    }

    protected void executeShutDown(StringBuilder input) {
        boolean shutdownDfc = DFSSearchCoordinator.canShutdownDfc();
        if (shutdownDfc) {
            logger.info((Object)("DFC service shutdown requested:" + input));
            this.jsc.stop();
        } else {
            logger.info((Object)String.format("received request to shutdown dfc but ignored: %s", input));
        }
    }

    private void informMasterDfcRunning() {
        logger.info((Object)("DFC has come up and notifying DFM --dfm port:" + this.dfsMasterPort));
        try {
            Socket toSend = new Socket("127.0.0.1", this.dfsMasterPort);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(toSend.getOutputStream()));
            String payload = String.format("%s,%s,%d,%s,%d\n", DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString(), this.dfcId, DFSSearchCoordinatorState.RUNNING.ordinal(), this.initialSid, this.dfsCoordinatorPort);
            bw.write(payload);
            bw.flush();
            toSend.close();
        }
        catch (Throwable t) {
            logger.error((Object)t);
            throw new RuntimeException(t);
        }
    }

    public void informMasterDfcShutdown() {
        try {
            Socket toSend = new Socket("127.0.0.1", this.dfsMasterPort);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(toSend.getOutputStream()));
            String payload = String.format("%s,%s,%d,%s,%d\n", DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString(), this.dfcId, DFSSearchCoordinatorState.SHUTDOWN.ordinal(), this.initialSid, this.dfsCoordinatorPort);
            bw.write(payload);
            bw.flush();
            toSend.close();
            logger.info((Object)String.format("Informed DFS master that DFC will be shutdown: dfc id: %s", this.dfcId));
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Could not inform master of dfc shutdown: %s", t.getMessage()), t);
        }
    }

    private void getSSLConfigFromDFM() {
        try {
            Socket socketToGetSSLConfig = new Socket("127.0.0.1", this.dfsMasterPort);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socketToGetSSLConfig.getOutputStream()));
            String payload = String.format("%s\n", DFSProtocolConstants.PROTO_DFS_SSL_CONFIG_REQ.toString());
            bw.write(payload);
            bw.flush();
            logger.info((Object)"Send SSLConfig Request");
            BufferedReader br = new BufferedReader(new InputStreamReader(socketToGetSSLConfig.getInputStream()));
            SSLConfig.getInstance(br.readLine());
            socketToGetSSLConfig.close();
            logger.info((Object)"Received SSLConfig Info");
        }
        catch (Throwable t) {
            logger.error((Object)"Cannot get SSLConfig from DFM", t);
            throw new RuntimeException(t);
        }
    }

    private void executeInvalidRequest() {
    }

    private void executeSearchUpdate() {
    }

    private void executeInErrorShutDown() {
    }

    private void executeCoordinatorStatusRequest(BufferedWriter writeToSplunkSearchProces) {
        logger.info((Object)String.format("Received request for DFC status", new Object[0]));
        try {
            String payload = "dfc.running";
            if (this.jsc.sc().isStopped()) {
                payload = "dfc.stopped";
                logger.warn((Object)String.format("Compute engine context is stopped hence this DFC should be shutdown", new Object[0]));
            }
            writeToSplunkSearchProces.write(String.format("%s\n", payload));
            writeToSplunkSearchProces.flush();
            writeToSplunkSearchProces.close();
            if (this.jsc.sc().isStopped()) {
                logger.warn((Object)String.format("Shutting down dfc since compute engine is stopped", new Object[0]));
                System.exit(-1);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
            throw new RuntimeException(t);
        }
    }

    private void executeNewRequest(StringBuilder blob, BufferedReader br, OutputStream rawos, Socket connection, long startConnect) throws JSONException {
        JSONObject dfsObject = new JSONObject(blob.toString());
        String searchId = dfsObject.getString(DFSProtocolConstants.PROTO_DFS_SID.toString());
        logger.info((Object)("Received search id" + searchId));
        this.searchResultInfoUtils = new SearchResultInfoUtils(rawos, this.getSearchResultsInfo((String)dfsObject.get(DFSProtocolConstants.PROTO_DFS_SRI.toString())));
        long maxRdoutRecs = DFSSearchCoordinator.getMaxRdOutRecords();
        int numPars = Math.max(1, (int)(maxRdoutRecs / 150000L));
        logger.info((Object)String.format("Number of rdout records: %d, total number of rdin partitions: %d", maxRdoutRecs, numPars));
        DFSSearchExecutor searchExecutor = new DFSSearchExecutor(this, searchId, dfsObject, br, rawos, this.jsc, connection, startConnect, this.dfcNumCores, this.dfcNumExecutors, this.dfcExecutorMemMbs, this.dfcDriverMemMbs, this.dfcNumConcurrentSearches, this.maxReducePartitionSize, this.dfcReceiverPort, this.dfcReceiverPortCount, this.splunkConf, this.searchExecutorSes, this.searchResultInfoUtils);
        this.searchExecutorSes.submit(searchExecutor);
    }

    private SearchResult getSearchResultsInfo(String infocsv) {
        try {
            CSVParser parser = new CSVParser((Reader)new CharArrayReader(infocsv.toCharArray()), CSVFormat.DEFAULT);
            Iterator recs = parser.iterator();
            CSVRecord header = (CSVRecord)recs.next();
            CSVRecord data = (CSVRecord)recs.next();
            int size = header.size();
            SearchResult.SRHashMap<SearchResult.FieldMeta, Object> dataMap = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(size * 2);
            for (int i = 0; i < size; ++i) {
                String field = header.get(i);
                String val = data.get(i);
                dataMap.put(SearchResult.FieldMeta.newFieldMeta(field), val);
            }
            parser.close();
            return SearchResultFactory.getInstance().createSearchResult(dataMap, new SearchResult.FieldMeta[0], new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to deseralize searchResultsInfo");
        }
    }

    private DFSProtocolConstants checkRequest(BufferedReader br, StringBuilder arguments) throws IOException {
        DFSProtocolConstants status = null;
        String input = br.readLine();
        if (input.startsWith(DFSProtocolConstants.PROTO_DFS_NEW_SEARCH_REQUEST.toString())) {
            input = input.substring(DFSProtocolConstants.PROTO_DFS_NEW_SEARCH_REQUEST.toString().length() + 1);
            status = DFSProtocolConstants.PROTO_DFS_NEW_SEARCH_REQUEST;
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString())) {
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE.toString().length() + 1);
            status = DFSProtocolConstants.PROTO_DFS_SEARCH_COORDINATOR_UPDATE;
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_SHUTDOWN;
            input = input.substring(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString().length() + 1);
        } else if (input.startsWith(DFSProtocolConstants.PROTO_DFS_COORDINATOR_STATUS.toString())) {
            status = DFSProtocolConstants.PROTO_DFS_COORDINATOR_STATUS;
        }
        if (status == null) {
            status = DFSProtocolConstants.PROTO_DFS_INVALID_REQUEST;
        }
        arguments.append(input);
        return status;
    }

    public static void main(String[] dfsArgs) {
        logger.info((Object)"Data Fabric Search (DFS) Version: 1.0.0");
        logger.info((Object)"DataFabric Coordinator launched.");
        if (dfsArgs.length < 1) {
            throw new RuntimeException(String.format("DFC launched without path to application arguments!", new Object[0]));
        }
        try {
            String dfcParamPath = dfsArgs[0];
            String dfcParams = new String(Files.readAllBytes(Paths.get(dfcParamPath, new String[0])));
            DFCParams dfcParamsObj = DFCParams.fromJson(dfcParams);
            logger.info((Object)String.format("DFC parameters received from dfc search dispatcher: %s", dfcParamsObj.toString()));
            String dfcAppName = dfcParamsObj.getDfcTitle();
            JavaSparkContext jsc = DFSSearchCoordinator.createJavaSparkContext(dfcAppName, dfcParamsObj.getExtraKryoClasses());
            new DFSSearchCoordinator(jsc, dfcParamsObj).execute();
            jsc.stop();
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error starting DFC instance: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("Could not start DFC: %s", t.getMessage()));
        }
    }

    private static boolean showConsoleProgress() {
        return System.getenv("SHOW_DFC_CONSOLE_PROGRESS") != null ? Boolean.valueOf(System.getenv("SHOW_DFC_CONSOLE_PROGRESS")) : true;
    }

    private static int getKryoSerializerMaxBufferSize() {
        int maxBuffMb = 256;
        String maxBuffStr = System.getenv("MAX_KRYO_BUFFER_SIZE_MB");
        if (maxBuffStr != null && !maxBuffStr.trim().isEmpty()) {
            maxBuffMb = Integer.parseInt(maxBuffStr);
        }
        logger.info((Object)String.format("max kryo buffer size set at: %d MB", maxBuffMb));
        return maxBuffMb;
    }

    private static int getLocalityWaitTimeSecs() {
        int localityWaitSecs = 1;
        String localityWaitSecsStr = System.getenv("TASK_LOCALITY_WAIT_SECS");
        if (localityWaitSecsStr != null) {
            try {
                localityWaitSecs = Integer.parseInt(localityWaitSecsStr);
                logger.info((Object)String.format("task locality wait time set based on envvar: %d seconds", localityWaitSecs));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not set task locality wait timeout seconds: %s, reason: %s", localityWaitSecsStr, t.getMessage()));
            }
        }
        logger.info((Object)String.format("task locality timeout set to: %d seconds", localityWaitSecs));
        return localityWaitSecs;
    }

    private static boolean getEnableHistory() {
        boolean enable = false;
        String enableStr = System.getenv("ENABLE_HISTORY");
        if (enableStr != null) {
            try {
                enable = Boolean.valueOf(enableStr);
                logger.info((Object)String.format("enable history overridden via envvar: %b", enable));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("error parsing envvar: %s, value: %s into boolean", "ENABLE_HISTORY", enableStr));
            }
        }
        logger.info((Object)String.format("enable history set to: %b", enable));
        return enable;
    }

    private static double getMinStartupExecutorRatio() {
        double ratio = 1.0;
        String ratioStr = System.getenv("MIN_STARTUP_EXECUTOR_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("min startup executor ratio set to %.2f using envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s envvar to double", "MIN_STARTUP_EXECUTOR_RATIO"));
            }
        }
        logger.info((Object)String.format("min startup executor ratio set to: %.2f", ratio));
        return ratio;
    }

    private static JavaSparkContext createJavaSparkContext(String dfcAppname, String extraKryoClasses) {
        SparkConf conf;
        block16: {
            conf = new SparkConf().setAppName(dfcAppname);
            int maxBuffMb = DFSSearchCoordinator.getKryoSerializerMaxBufferSize();
            conf.set("spark.kryoserializer.buffer.max", String.format("%dm", maxBuffMb));
            logger.info((Object)String.format("max kryo buffer size for search: %d mb", maxBuffMb));
            conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
            conf.set("spark.driver.maxResultSize", "2g");
            if (DFSSearchCoordinator.showConsoleProgress()) {
                conf.set("spark.ui.showConsoleProgress", "true");
            } else {
                conf.set("spark.ui.showConsoleProgress", "false");
            }
            conf.set("spark.rpc.message.maxSize", "1280");
            conf.set("spark.kryo.registrationRequired", "true");
            conf.set("spark.executor.heartbeatInterval", "12000s");
            conf.set("spark.rpc.retry.wait", "100s");
            conf.set("spark.rpc.numRetries", "100");
            conf.set("spark.task.maxFailures", "1");
            conf.set("spark.kryo.referenceTracking", "false");
            int localityWaitSecs = DFSSearchCoordinator.getLocalityWaitTimeSecs();
            localityWaitSecs = Math.max(1, localityWaitSecs);
            conf.set("spark.locality.wait", String.format("%ds", localityWaitSecs));
            double mrrr = DFSSearchCoordinator.getMinStartupExecutorRatio();
            mrrr = Math.min(1.0, mrrr);
            conf.set("spark.scheduler.minRegisteredResourcesRatio", String.format("%.2f", mrrr));
            conf.set("spark.network.timeout", "99999s");
            conf.set("spark.shuffle.compress", "true");
            conf.set("spark.shuffle.io.preferDirectBufs", "true");
            conf.set("spark.shuffle.service.enabled", "false");
            conf.set("spark.shuffle.spill.compress", "true");
            conf.set("spark.driver.maxResultSize", "50g");
            String sparkLocalDir = String.format("%s/dfstmp", System.getenv("SPARK_HOME"));
            File file = new File(sparkLocalDir);
            if (!file.exists()) {
                try {
                    boolean success = new File(sparkLocalDir).mkdirs();
                    if (success) {
                        logger.info((Object)String.format("Spark local dir: %s", sparkLocalDir));
                        conf.set("spark.local.dir", sparkLocalDir);
                        break block16;
                    }
                    logger.error((Object)("Failed to create spark local directory " + sparkLocalDir + ", default to /tmp"));
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Failed to create spark local directory " + sparkLocalDir, new Object[0]));
                }
            } else {
                logger.info((Object)String.format("Spark local dir: %s", sparkLocalDir));
                conf.set("spark.local.dir", sparkLocalDir);
            }
        }
        boolean enableHistory = DFSSearchCoordinator.getEnableHistory();
        if (enableHistory) {
            String sparkHome = System.getenv("SPARK_HOME");
            if (sparkHome != null) {
                File eventLogDir = new File(Paths.get(String.format("%s/eventlog/", sparkHome), new String[0]).toString());
                if (!eventLogDir.exists()) {
                    if (eventLogDir.mkdirs()) {
                        logger.info((Object)String.format("created event log directory since it did not exist: %s", eventLogDir.getAbsolutePath()));
                    } else {
                        logger.warn((Object)String.format("could not create event log directory: %s hence disabling history", eventLogDir.getAbsolutePath()));
                        enableHistory = false;
                    }
                } else {
                    logger.info((Object)String.format("event log directory already exists: %s", eventLogDir.getAbsolutePath()));
                }
                if (enableHistory) {
                    conf.set("spark.eventLog.dir", "file://" + eventLogDir.toString());
                }
            } else {
                logger.info((Object)String.format("could not enable dfc execution history since SPARK_HOME is not set as envvar hence disabling history", new Object[0]));
                enableHistory = false;
            }
        }
        if (enableHistory) {
            conf.set("spark.eventLog.enabled", "true");
            logger.info((Object)String.format("enabled history since all configurations could bet set correctly", new Object[0]));
        }
        conf.registerKryoClasses(KryoRegisteredClassHolder.getClasses(extraKryoClasses));
        JavaSparkContext sc = new JavaSparkContext(conf);
        DFSSearchCoordinator.printSparkConfWithoutSecurityInfo(sc);
        return sc;
    }

    private static void printSparkConfWithoutSecurityInfo(JavaSparkContext sc) {
        String version = sc.version();
        SparkConf sparkConfWithoutPassword = sc.getConf().clone();
        Tuple2[] authenticateConfs = sparkConfWithoutPassword.getAllWithPrefix("spark.authenticate");
        Tuple2[] sslConfs = sparkConfWithoutPassword.getAllWithPrefix("spark.ssl");
        if (authenticateConfs != null && authenticateConfs.length != 0) {
            for (Tuple2 t : authenticateConfs) {
                sparkConfWithoutPassword.remove(String.format("%s%s", "spark.authenticate", t._1()));
            }
        }
        if (sslConfs != null && sslConfs.length != 0) {
            for (Tuple2 t : sslConfs) {
                sparkConfWithoutPassword.remove(String.format("%s%s", "spark.ssl", t._1()));
            }
        }
        logger.info((Object)String.format("Created dfs context, with conf: %s\nSpark Core Version: %s", sparkConfWithoutPassword.toDebugString(), version));
    }
}

