/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.ast.JsonParser;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandOrderInfo;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.NoOpCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.commons.visitors.ValidationVisitor;
import com.splunk.df.search.DFSExecutionState;
import com.splunk.df.search.DFSSidGenerator;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.DFSVisitorUtil;
import com.splunk.df.visitors.ColumnOrderVisitor;
import com.splunk.df.visitors.FunctionValidationVisitor;
import com.splunk.df.visitors.JobPartitionerVisitor;
import com.splunk.df.visitors.OrderInfoVisitor;
import com.splunk.df.visitors.PartitionExtractionVisitor;
import com.splunk.df.visitors.RequiredFieldsOrderVisitor;
import com.splunk.df.visitors.SortFieldsValidationVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DFSPhaseFacilitator {
    static final Logger logger = Logger.getLogger(DFSPhaseFacilitator.class);
    private CommandNode searchQuery;
    private SplFormatter formatter;
    private CommandNode splunkSHJob;
    private CommandNode dfsJob;
    private ArrayList<CommandNode> rdinJobs;
    private ArrayList<CommandNode> internalJobs;
    private ArrayList<CommandNode> fshJobs;
    private HashMap<String, List<String>> datasetToRemoteSid;
    private ArrayList<CommandOrderInfo> orderInfo;
    private ArrayList<String> columnOrder;
    private boolean shouldShortCircuit;
    private boolean startPaused;
    private DFSExecutionState currentDFSExecutionState;
    private HashMap<Integer, FederatedDataSetInfo> datasetInfoMap;

    public DFSPhaseFacilitator(JSONObject astJsonObj) {
        this.searchQuery = (CommandNode)new JsonParser(false, false).parse(astJsonObj);
        this.init();
    }

    public DFSPhaseFacilitator(CommandNode query) {
        this.searchQuery = query;
        this.init();
    }

    public DFSPhaseFacilitator(JSONObject astJsonObj, HashMap<Integer, FederatedDataSetInfo> datasetInfoMap) {
        this(astJsonObj);
        this.datasetInfoMap = datasetInfoMap;
    }

    private void init() {
        this.formatter = new SplFormatter();
        this.splunkSHJob = null;
        this.dfsJob = null;
        this.fshJobs = null;
        this.internalJobs = null;
        this.datasetToRemoteSid = null;
        this.orderInfo = new ArrayList();
        this.columnOrder = new ArrayList();
        this.currentDFSExecutionState = DFSExecutionState.UNKNOWN;
    }

    public DFSExecutionState getCurrentDFSExecutionState() {
        return this.currentDFSExecutionState;
    }

    public ArrayList<CommandOrderInfo> getOrderForSearchPhases() {
        return this.orderInfo;
    }

    public ArrayList<String> getColumnOrder() {
        return this.columnOrder;
    }

    public String[] getRemoteSearchJobs() {
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            assert (this.internalJobs == null);
            return null;
        }
        assert (!this.internalJobs.isEmpty());
        String[] remoteSearches = new String[this.internalJobs.size()];
        int index = 0;
        for (CommandNode cn : this.internalJobs) {
            remoteSearches[index] = (String)cn.accept((NodeVisitor)this.formatter);
            logger.debug((Object)String.format("command node: %s, remote search: %s", cn.getCommandName(), cn.accept((NodeVisitor)this.formatter)));
            ++index;
        }
        return remoteSearches;
    }

    public String[] getFederatedJobs() {
        if (this.currentDFSExecutionState == DFSExecutionState.LOCAL_ONLY) {
            assert (this.fshJobs == null);
            return null;
        }
        String[] fshSearches = new String[this.fshJobs.size()];
        int index = 0;
        for (CommandNode cn : this.fshJobs) {
            fshSearches[index] = (String)cn.accept((NodeVisitor)this.formatter);
            ++index;
        }
        return fshSearches;
    }

    public String[] getAllFederatedDataSets() {
        if (this.currentDFSExecutionState == DFSExecutionState.LOCAL_ONLY) {
            assert (this.fshJobs == null);
            return null;
        }
        ArrayList<String> fshDataSets = new ArrayList<String>();
        for (CommandNode cn : this.fshJobs) {
            if (!(cn instanceof FromCommand)) {
                throw new IllegalStateException("Phase Generation Failed, FSH searches missing from command, found " + cn.getCommandName());
            }
            FromCommand fm = (FromCommand)cn;
            fshDataSets.add(fm.getDataset().getKind() + ":" + fm.getDataset().getName());
        }
        String[] fshDataSetArray = new String[fshDataSets.size()];
        fshDataSetArray = fshDataSets.toArray(fshDataSetArray);
        return fshDataSetArray;
    }

    public HashMap<String, List<String>> getDataSetToRemoteSid() {
        return this.datasetToRemoteSid;
    }

    public int getNumberOfFederatedSearch() {
        if (this.currentDFSExecutionState == DFSExecutionState.LOCAL_ONLY) {
            assert (this.fshJobs == null);
            return 0;
        }
        return this.fshJobs.size();
    }

    public int getNumberOfRemoteSearches() {
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            assert (this.internalJobs == null);
            return 0;
        }
        return this.internalJobs.size();
    }

    public String getSHSearchPhase() {
        return (String)this.splunkSHJob.accept((NodeVisitor)this.formatter);
    }

    public boolean isSHSearchPhasePresent() {
        return this.splunkSHJob != null;
    }

    public CommandNode getDFSPhase() {
        assert (this.dfsJob != null);
        return this.dfsJob;
    }

    public boolean isSearchStartPaused() {
        return this.shouldShortCircuit;
    }

    public boolean isShortCircuit() {
        return this.shouldShortCircuit;
    }

    public void generatePhases(DFSSidGenerator dfsSidGenerator) {
        JobPartitionerVisitor partitionerVisitor = new JobPartitionerVisitor();
        CommandNode partitionedQuery = (CommandNode)this.searchQuery.accept((NodeVisitor)partitionerVisitor);
        logger.debug((Object)("After Job Partitioning=" + (String)partitionedQuery.accept((NodeVisitor)this.formatter)));
        DFSVisitorUtil.JobStatus lastStatus = this.getLastPartitionStatus(partitionedQuery);
        switch (lastStatus) {
            case GENERATING_STATE: {
                partitionedQuery = this.appendJobPartition(partitionedQuery, DFSVisitorUtil.JobStatus.DFS_STATE);
                break;
            }
            case DFS_STATE: {
                partitionedQuery = this.appendJobPartition(partitionedQuery, DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE);
                break;
            }
            case FSH_STATE: {
                partitionedQuery = this.appendJobPartition(partitionedQuery, DFSVisitorUtil.JobStatus.DFS_STATE);
                break;
            }
            case SPLUNK_SH_STATE: {
                break;
            }
            default: {
                throw new IllegalStateException("Job Partitioner for the search query is in Illegal state:" + DFSVisitorUtil.JobStatus.UNDEFINED_STATE.toString());
            }
        }
        logger.debug((Object)("Query being sent for partitionVisitor==> " + (String)partitionedQuery.accept((NodeVisitor)this.formatter)));
        this.runExtractionPartitionVisitor(partitionedQuery, dfsSidGenerator);
        this.runColumnVisitor();
        this.runOrderInfoVisitor();
        this.runReqFieldOrderVisitor();
        this.runValidationVisitor();
        this.runSortFieldsValidationVisitor();
        this.runFunctionValidationVisitor();
        this.updateRedistributeOperator(partitionedQuery);
        logger.info((Object)"Phase generation completed at this point");
    }

    private void runFunctionValidationVisitor() {
        CommandNode dfsSearchToRun = this.dfsJob;
        FunctionValidationVisitor functionValidationVisitor = new FunctionValidationVisitor();
        dfsSearchToRun.accept((NodeVisitor)functionValidationVisitor);
    }

    private void runColumnVisitor() {
        CommandNode dfsSearchToRun = this.dfsJob;
        HashMap<String, ArrayList<String>> fshRemoteSidToColumnOrderMap = this.getFshRemoteSidToColumnOrderMap();
        ColumnOrderVisitor columnOrderVisitor = new ColumnOrderVisitor(fshRemoteSidToColumnOrderMap);
        dfsSearchToRun.accept((NodeVisitor)columnOrderVisitor);
        this.columnOrder = columnOrderVisitor.getColumnOrder();
    }

    private HashMap<String, ArrayList<String>> getFshRemoteSidToColumnOrderMap() {
        if (this.datasetInfoMap == null) {
            return null;
        }
        HashMap<String, ArrayList<String>> fshRemoteSidToColumnOrderMap = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, List<String>> entry : this.datasetToRemoteSid.entrySet()) {
            List<String> remoteSids = entry.getValue();
            block1: for (String remoteSid : remoteSids) {
                if (fshRemoteSidToColumnOrderMap.containsKey(remoteSid)) continue;
                String[] kindAndName = entry.getKey().split(":", 2);
                String dataSetName = kindAndName[1];
                for (FederatedDataSetInfo dataSetInfo : this.datasetInfoMap.values()) {
                    if (!dataSetInfo.getDatasetName().equals(dataSetName)) continue;
                    FederatedDataSetInfo fshInfo = this.datasetInfoMap.get(dataSetInfo.getId());
                    if (fshInfo == null) continue block1;
                    fshRemoteSidToColumnOrderMap.put(remoteSid, fshInfo.getColumnOrder());
                    continue block1;
                }
            }
        }
        return fshRemoteSidToColumnOrderMap;
    }

    private void runOrderInfoVisitor() {
        CommandNode dfsSearchToRun = this.dfsJob;
        OrderInfoVisitor orderInfoVisitor = new OrderInfoVisitor();
        dfsSearchToRun.accept((NodeVisitor)orderInfoVisitor);
        this.orderInfo = orderInfoVisitor.getPipelineOrderInfo();
    }

    private void runSortFieldsValidationVisitor() {
        CommandNode dfsSearchToRun = this.dfsJob;
        SortFieldsValidationVisitor sortFieldsValidationVisitor = new SortFieldsValidationVisitor();
        this.dfsJob = (CommandNode)dfsSearchToRun.accept((NodeVisitor)sortFieldsValidationVisitor);
    }

    private void runReqFieldOrderVisitor() {
        RequiredFieldsOrderVisitor reqFieldsOrderVisitor;
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            return;
        }
        ArrayList<LinkedHashSet<Object>> dfsJobReqFieldsList = new ArrayList<LinkedHashSet<Object>>(this.internalJobs.size());
        for (CommandNode rdinSearch : this.rdinJobs) {
            logger.debug((Object)("rdinSearch : " + rdinSearch.toString()));
            LinkedHashSet<Object> toAddReqFields = new LinkedHashSet();
            reqFieldsOrderVisitor = new RequiredFieldsOrderVisitor();
            rdinSearch.accept((NodeVisitor)reqFieldsOrderVisitor);
            toAddReqFields = reqFieldsOrderVisitor.getRequiredFields();
            if (rdinSearch.getPipeline().ordinal() <= CommandType.SP_EVENTS.ordinal()) {
                toAddReqFields.addAll(new ArrayList<String>(Arrays.asList("source", "sourcetype", "host", "index", "_bkt", "_cd", "_si", "splunk_server", "_linecount", "*")));
            }
            logger.debug((Object)("Req fields=" + Arrays.toString(toAddReqFields.toArray())));
            dfsJobReqFieldsList.add(toAddReqFields);
        }
        ArrayList<CommandNode> tempJob = new ArrayList<CommandNode>(this.internalJobs.size());
        for (CommandNode remoteSearch : this.internalJobs) {
            logger.debug((Object)("Remote Search= " + remoteSearch.toString()));
            reqFieldsOrderVisitor = new RequiredFieldsOrderVisitor(false);
            remoteSearch.accept((NodeVisitor)reqFieldsOrderVisitor);
            LinkedHashSet<String> toAddReqFields = new LinkedHashSet<String>();
            toAddReqFields.addAll(reqFieldsOrderVisitor.getRequiredFields());
            toAddReqFields.addAll((Collection)dfsJobReqFieldsList.get(tempJob.size()));
            logger.debug((Object)("Req fields=" + Arrays.toString(toAddReqFields.toArray())));
            tempJob.add(this.updateRemoteSearchWithRequiredFields(remoteSearch, toAddReqFields));
            logger.debug((Object)("Added " + tempJob.get(tempJob.size() - 1)));
        }
        this.internalJobs.clear();
        this.internalJobs = tempJob;
    }

    private CommandNode updateRemoteSearchWithRequiredFields(CommandNode remoteSearch, LinkedHashSet<String> toAddReqFields) {
        FieldsCommand fieldsCommand;
        FieldNode[] reqFields = new FieldNode[toAddReqFields.size()];
        int i = 0;
        for (String field : toAddReqFields) {
            reqFields[i] = new FieldNode(field);
            ++i;
        }
        CommandNode remoteSource = remoteSearch.getSource();
        if (remoteSource.getSources().length > 0 && remoteSource.getCommandType().ordinal() >= CommandType.SP_STREAM.ordinal()) {
            fieldsCommand = new FieldsCommand(remoteSource.getSource(), reqFields, false, true);
            CommandNode fieldParent = remoteSource.setSource(DFSVisitorUtil.rebuild((CommandNode)fieldsCommand));
            return remoteSearch.setSource(DFSVisitorUtil.rebuild(fieldParent));
        }
        fieldsCommand = new FieldsCommand(remoteSource, reqFields, false, true);
        return remoteSearch.setSource(DFSVisitorUtil.rebuild((CommandNode)fieldsCommand));
    }

    private void updateRedistributeOperator(CommandNode partitionedQuery) {
    }

    private void runExtractionPartitionVisitor(CommandNode partitionedQuery, DFSSidGenerator dfsSidGenerator) {
        PartitionExtractionVisitor partitioner = new PartitionExtractionVisitor(dfsSidGenerator);
        partitionedQuery.accept((NodeVisitor)partitioner);
        this.currentDFSExecutionState = partitioner.getCurrentDFSExecutionState();
        if (this.currentDFSExecutionState != DFSExecutionState.FEDERATED_ONLY) {
            this.internalJobs = partitioner.getSplunkRemoteJobs();
        }
        this.rdinJobs = partitioner.getRdinJobs();
        this.dfsJob = partitioner.getDFSJob();
        if (this.dfsJob.getCommandName().equalsIgnoreCase("rdin") && this.dfsJob.getSources().length == 0) {
            NoOpCommand noop = new NoOpCommand(this.dfsJob);
            this.dfsJob = noop;
        }
        this.splunkSHJob = partitioner.getSplunkSHJob();
        if (this.currentDFSExecutionState != DFSExecutionState.LOCAL_ONLY) {
            this.fshJobs = partitioner.getFSHJobs();
            this.datasetToRemoteSid = partitioner.getDataSetToRemoteSid();
        }
    }

    private void runValidationVisitor() {
        ValidationVisitor vv = new ValidationVisitor(true);
        if (this.currentDFSExecutionState == DFSExecutionState.UNKNOWN) {
            throw new IllegalStateException("DFS Execution state unknown , query building failed.");
        }
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            return;
        }
        assert (this.internalJobs.size() > 0);
        this.internalJobs.get(0).accept((NodeVisitor)vv);
        this.shouldShortCircuit = vv.getShouldShortCircuit();
        this.startPaused = vv.isStartPaused();
    }

    private CommandNode appendJobPartition(CommandNode partitionedQuery, DFSVisitorUtil.JobStatus toState) {
        logger.debug((Object)("Desired State=" + toState.toString()));
        if (DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE == toState) {
            throw new DFSException(logger, "This search cannot run because it contains unsupported command.");
        }
        JobPartitionerCommand partitionerCommand = new JobPartitionerCommand(partitionedQuery, toState.toString());
        logger.debug((Object)("After append=" + (String)partitionerCommand.accept((NodeVisitor)this.formatter)));
        return partitionerCommand;
    }

    private DFSVisitorUtil.JobStatus getLastPartitionStatus(CommandNode partitionedQuery) {
        CommandNode itrNode = partitionedQuery;
        DFSVisitorUtil.JobStatus jobStatus = DFSVisitorUtil.JobStatus.UNDEFINED_STATE;
        if (itrNode.getCommandName().equalsIgnoreCase("jobpartition")) {
            return DFSVisitorUtil.JobStatus.valueOf(((JobPartitionerCommand)itrNode).getJobPartitionName());
        }
        while (itrNode != null) {
            CommandNode[] sourceNodes = itrNode.getSources();
            if (sourceNodes.length >= 1) {
                itrNode = sourceNodes[0];
                if (!itrNode.getCommandName().equalsIgnoreCase("jobpartition")) continue;
                return DFSVisitorUtil.JobStatus.valueOf(((JobPartitionerCommand)itrNode).getJobPartitionName());
            }
            itrNode = null;
        }
        return jobStatus;
    }

    public void updateRDoutWithListeners(List<HostPort> remoteSearchHPList) {
        ArrayList<CommandNode> tempList = new ArrayList<CommandNode>();
        for (int i = 0; i < this.internalJobs.size(); ++i) {
            CommandNode itr = this.internalJobs.get(i);
            RdOutCommand currentRdout = null;
            if (!(itr instanceof RdOutCommand)) {
                throw new IllegalStateException("Remote search should start a rdout processor, actual state:" + (String)itr.accept((NodeVisitor)new SplFormatter()));
            }
            currentRdout = (RdOutCommand)itr;
            logger.debug((Object)("Updating search=" + (String)itr.accept((NodeVisitor)new SplFormatter())));
            HostPort[] hp = new HostPort[remoteSearchHPList.size()];
            remoteSearchHPList.toArray(hp);
            CommandNode updatedRdout = currentRdout.setSource(currentRdout.getSource(), hp);
            tempList.add(updatedRdout);
        }
        this.internalJobs.clear();
        this.internalJobs = tempList;
    }

    public CommandNode getRdOutCommand(int idx) {
        return this.internalJobs.get(idx);
    }

    public JSONObject getResponseForFSH() {
        JSONObject obj = new JSONObject();
        JSONObject dfsObject = new JSONObject();
        dfsObject.put("dfsSearch", this.getDFSPhase().accept((NodeVisitor)new SplFormatter()));
        JSONArray sidList = new JSONArray();
        dfsObject.put("remoteSID", (Object)sidList);
        JSONArray columnOrder = new JSONArray();
        dfsObject.put("columnOrder", (Object)columnOrder);
        JSONArray remoteSearchList = new JSONArray();
        dfsObject.put("remoteSearches", (Object)remoteSearchList);
        JSONArray orderArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("field", (Object)"_time");
        object.put("ASC", (Object)"false");
        orderArray.put((Object)object);
        dfsObject.put("orderInfoList", (Object)orderArray);
        JSONObject meta = new JSONObject();
        meta.put("isStartPaused", false);
        meta.put("allowRemoteTimeLine", false);
        meta.put("shouldShortCircuit", false);
        meta.put("isPrevPhaseOrdered", true);
        dfsObject.put("metainfo", (Object)meta);
        obj.put("dfsInfo", (Object)dfsObject);
        return obj;
    }
}

