/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.util.HashMap;
import java.util.Map;

public enum DFExecutionType {
    UNKNOWN(0),
    STREAMING(1),
    BATCH(2);

    public final int finalId;
    private static Map<Integer, DFExecutionType> lookupCache;
    private static boolean isCacheFilled;

    private DFExecutionType(int id) {
        this.finalId = id;
    }

    private static void lazyFillCache() {
        HashMap<Integer, DFExecutionType> localC = new HashMap<Integer, DFExecutionType>();
        for (DFExecutionType searchStatus : DFExecutionType.values()) {
            localC.put(searchStatus.finalId, searchStatus);
        }
        lookupCache = localC;
        isCacheFilled = true;
    }

    public static DFExecutionType getSearchState(int lookupVal) {
        if (!isCacheFilled) {
            DFExecutionType.lazyFillCache();
        }
        return lookupCache.get(lookupVal);
    }

    static {
        lookupCache = null;
        isCacheFilled = false;
    }
}

