/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSSearchConstants;
import java.nio.charset.StandardCharsets;

public class ChunkToDispatch
implements DFSSearchConstants {
    private final String srSet;
    private final String sri;

    public ChunkToDispatch(String sri, String srSet) {
        this.srSet = srSet;
        this.sri = sri;
    }

    public int getSRSetSize() {
        return this.srSet.getBytes(StandardCharsets.UTF_8).length;
    }

    public String getHeader() {
        return String.format("splunk %d,%d,%d", 345622, this.sri.getBytes(StandardCharsets.UTF_8).length, this.getSRSetSize());
    }

    public int sizeofChunk() {
        int payLoadSize = this.getHeader().length() + this.sri.length() + this.getSRSetSize();
        return payLoadSize;
    }

    public String getSrSet() {
        return this.srSet;
    }

    public String getSri() {
        return this.sri;
    }

    public String toString() {
        return String.format("sri:%s\nsrs:\n%s", this.sri, this.srSet);
    }
}

