/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.reader;

import com.splunk.io.SearchOutputStream;
import com.splunk.mr.ResultFileReader;
import com.splunk.mr.cache.CacheIndexer;
import com.splunk.mr.cache.GroupedProcessor;
import com.splunk.mr.cache.PathAndPointer;
import com.splunk.mr.cache.integration.CacheSplitListener;
import com.splunk.mr.cache.integration.KeyPointer;
import com.splunk.mr.cache.reader.GetsTransitionedPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class ResultProcessorFactory
implements GroupedProcessor.ProcessFactory<String, KeyPointer> {
    public static final int RETRY_LIMIT = 5;
    private static Logger gLogger = Logger.getLogger(ResultProcessorFactory.class);
    private final FileSystem fs;
    private final GetsTransitionedPath transitions;
    private final SearchOutputStream out;
    private final CacheSplitListener cacheSplitListener;
    private final ResultFileReaderFactory readerFactory;

    public ResultProcessorFactory(FileSystem fs, GetsTransitionedPath transitions, SearchOutputStream out, CacheSplitListener cacheSplitListener) {
        this.fs = fs;
        this.transitions = transitions;
        this.out = out;
        this.cacheSplitListener = cacheSplitListener;
        this.readerFactory = new ResultFileReaderFactory();
    }

    @Override
    public GroupedProcessor.Processor<KeyPointer> getNew(String path, GroupedProcessor<String, KeyPointer> queue) {
        return new ResultProcessor(path, queue);
    }

    public static class ResultFileReaderFactory {
        public ResultFileReader getNew(final PathAndPointer pnp, final InputStream inputStream, final String name, SearchOutputStream out) {
            return new ResultFileReader(new ResultFileReader.Source(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getPath() {
                    return pnp.getRawPath();
                }

                @Override
                public long getLength() {
                    return pnp.pointer.getLength();
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return inputStream;
                }

                @Override
                public String getStreamType() {
                    return "report_cache";
                }
            }, out, new HashSet<String>());
        }
    }

    public class ResultProcessor
    extends GroupedProcessor.Processor<KeyPointer> {
        private final String path;
        private final GroupedProcessor<String, KeyPointer> queue;
        private int tries;
        private FSDataInputStream fileIn = null;
        private boolean gotException = false;

        public ResultProcessor(String path, GroupedProcessor<String, KeyPointer> queue) {
            this.path = path;
            this.queue = queue;
            this.tries = 0;
        }

        @Override
        public void init() throws IOException {
            if (this.fileIn != null) {
                throw new IllegalStateException("File In should have been null/reset");
            }
        }

        @Override
        public void process(KeyPointer kp) {
            if (this.tries >= 5) {
                this.processFailure(kp);
            }
            if (!this.gotException) {
                this.doProcess(kp);
            } else {
                this.queueTransitionedPointer(kp);
            }
        }

        private void doProcess(KeyPointer kp) {
            try {
                if (this.fileIn == null) {
                    this.fileIn = ResultProcessorFactory.this.fs.open(CacheIndexer.getResultFile(new Path(this.path)));
                }
                this.readResults(kp.pathAndPointer);
                ResultProcessorFactory.this.cacheSplitListener.onCacheReadSuccess(kp.cacheKey);
            }
            catch (Exception e) {
                ++this.tries;
                gLogger.debug((Object)("Got exception when fetching result: " + e));
                this.gotException = true;
                ResultProcessorFactory.this.transitions.clearCache();
                this.queueTransitionedPointer(kp);
            }
        }

        private void readResults(PathAndPointer pnp) throws IOException {
            this.fileIn.seek(pnp.pointer.getOffset());
            ResultFileReader rfr = ResultProcessorFactory.this.readerFactory.getNew(pnp, (InputStream)this.getNonClosableInputStreamToPointer(pnp), "cache", ResultProcessorFactory.this.out);
            rfr.run();
        }

        private BoundedInputStream getNonClosableInputStreamToPointer(PathAndPointer pnp) {
            return new BoundedInputStream((InputStream)this.fileIn, pnp.pointer.getLength()){

                public void close() throws IOException {
                }
            };
        }

        private void queueTransitionedPointer(KeyPointer kp) {
            PathAndPointer newPnp = this.getNewPnp(kp);
            if (newPnp != null) {
                this.queue.offer(newPnp.getRawPath(), new KeyPointer(kp.cacheKey, newPnp));
            }
        }

        private PathAndPointer getNewPnp(KeyPointer kp) {
            PathAndPointer pnp = kp.pathAndPointer;
            try {
                GetsTransitionedPath.Transition transition = ResultProcessorFactory.this.transitions.getTransitionCached(new Path(this.path));
                if (transition.isDeleted()) {
                    gLogger.debug((Object)"Found deleted transition");
                    ResultProcessorFactory.this.cacheSplitListener.onCacheReadFailure(kp.cacheKey);
                    return null;
                }
                return pnp.transition(transition);
            }
            catch (IOException e1) {
                return pnp;
            }
        }

        @Override
        public void reset() {
            IOUtils.closeQuietly((InputStream)this.fileIn);
            this.fileIn = null;
            this.gotException = false;
        }

        @Override
        public void processFailure(KeyPointer take) {
            ResultProcessorFactory.this.cacheSplitListener.onCacheReadFailure(take.cacheKey);
        }
    }
}

