/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class SplunkdProcess {
    Process splunkProcess = null;
    InputStreamDataCollector stdoutCollector = null;
    InputStreamDataCollector stderrCollector = null;
    OutputStream toProc = null;
    String splunk_home;
    int _rv = Integer.MIN_VALUE;

    public static File getDispatchDir(String splunk_home, String searchId) {
        String dispatchDir = FilenameUtils.normalize((String)(splunk_home + "/var/run/splunk/dispatch/" + searchId));
        return new File(dispatchDir);
    }

    public SplunkdProcess(String splunk_home, Writer procStdout, Writer procStderr, String ... args) throws IOException {
        this(splunk_home, procStdout, procStderr, false, args);
    }

    public SplunkdProcess(String splunk_home, Writer procStdout, Writer procStderr, boolean closeWriter, String ... args) throws IOException {
        this.splunk_home = splunk_home;
        ArrayList<String> processArgs = new ArrayList<String>(args.length + 3);
        processArgs.add(FilenameUtils.normalize((String)(splunk_home + "/bin/splunk")));
        processArgs.add("cmd");
        processArgs.add("splunkd");
        processArgs.addAll(Arrays.asList(args));
        ProcessBuilder pb = new ProcessBuilder(processArgs);
        this.splunkProcess = pb.start();
        this.toProc = this.splunkProcess.getOutputStream();
        this.stdoutCollector = new InputStreamDataCollector(this.splunkProcess.getInputStream(), procStdout, closeWriter);
        this.stderrCollector = new InputStreamDataCollector(this.splunkProcess.getErrorStream(), procStderr, false);
    }

    protected void finalize() {
        this.destroy();
    }

    public OutputStream getStdin() {
        return this.toProc;
    }

    public void destroy() {
        try {
            this.splunkProcess.destroy();
            this.stdoutCollector.interrupt();
            this.stderrCollector.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getDispatchDir(String searchId) {
        return SplunkdProcess.getDispatchDir(this.splunk_home, searchId);
    }

    public void cleanupDispatchDir(String searchId) {
        File f = SplunkdProcess.getDispatchDir(this.splunk_home, searchId);
        if (f.isDirectory()) {
            FileUtils.deleteQuietly((File)f);
        }
    }

    public int waitFor() throws InterruptedException, IOException {
        if (this._rv == Integer.MIN_VALUE) {
            this.toProc.close();
            this._rv = this.splunkProcess.waitFor();
            this.stdoutCollector.join();
            this.stderrCollector.join();
        }
        return this._rv;
    }

    public int getExitCode() {
        return this._rv;
    }

    public long getStdoutBytesCopied() {
        return this.stdoutCollector.getBytesCopied();
    }

    public boolean hasStdoutError() {
        return this.stdoutCollector.getError() != null;
    }

    public IOException getStdoutError() {
        return this.stdoutCollector.getError();
    }

    public long getStderrBytesCopied() {
        return this.stderrCollector.getBytesCopied();
    }

    public boolean hasStderrError() {
        return this.stderrCollector.getError() != null;
    }

    public static SplunkdProcess createProcess(String splunk_home, String searchId, String search, Writer stdout, Writer stderr) throws IOException {
        if (!search.startsWith("stdin")) {
            search = "stdin | " + search;
        }
        ArrayList<String> args = new ArrayList<String>(10);
        args.add("search");
        args.add("--streaming");
        args.add("--annotateMessages=true");
        args.add("--outCsv");
        args.add("--pro");
        args.add("--user=admin");
        args.add("--app=search");
        args.add("--roles=admin");
        args.add("--maxout=0");
        args.add("--maxbuckets=0");
        args.add("--id=" + searchId);
        args.add("--search=" + search);
        return new SplunkdProcess(splunk_home, stdout, stderr, args.toArray(new String[0]));
    }

    public static class InputStreamDataCollector
    extends Thread {
        private static Logger logger = Logger.getLogger(InputStreamDataCollector.class);
        private InputStream _in = null;
        private Writer _out = null;
        private long _bytesCopied = 0L;
        private IOException _error = null;
        private boolean _closeWriter;

        public InputStreamDataCollector(InputStream ins, Writer out, boolean closeWriter) {
            this._in = ins;
            this._out = out;
            this._closeWriter = closeWriter;
            this.start();
        }

        @Override
        public void run() {
            try {
                this._bytesCopied = IOUtils.copyLarge((Reader)new InputStreamReader(this._in), (Writer)this._out);
            }
            catch (IOException ex) {
                this._error = ex;
                logger.error((Object)ex);
            }
            finally {
                if (this._closeWriter) {
                    IOUtils.closeQuietly((Writer)this._out);
                }
            }
        }

        public long getBytesCopied() {
            return this._bytesCopied;
        }

        public IOException getError() {
            return this._error;
        }
    }
}

