/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.data_delivery;

import com.splunk.mr.input.VirtualIndex;
import com.splunk.sdk.SplunkMiniSDK;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.MissingNode;

public class LicenseChecker {
    private SplunkMiniSDK _sdk;
    private static final Logger gLogger = Logger.getLogger(LicenseChecker.class);
    private JsonNode _hadoopLic = null;
    private final Configuration _conf;

    LicenseChecker(Configuration conf) {
        this._conf = conf;
        Map<String, Object> info = VirtualIndex.getForwardInfo(conf);
        this._sdk = SplunkMiniSDK.createForForwarding(conf);
        this._hadoopLic = this.getHadoopERPLicense();
    }

    private JsonNode getHadoopERPLicense() {
        if (this._hadoopLic == null) {
            try {
                JsonNode licEntry = this._sdk.get("/services/server/info", new String[0]).firstEntry();
                this._hadoopLic = licEntry.path("content").path("addOns").path("hadoop");
            }
            catch (Exception e) {
                gLogger.warn((Object)"Failed to get license:", (Throwable)e);
                this._hadoopLic = MissingNode.getInstance();
            }
        }
        return this._hadoopLic;
    }

    boolean isLicenseValid() {
        boolean isLicenseValid = false;
        ObjectMapper jsonNode = new ObjectMapper();
        JsonNode outputType = null;
        try {
            outputType = jsonNode.readTree(this._conf.get("splunk.args")).path("conf").path("provider").path("data.delivery.output.type");
            if (outputType.isNull() || outputType.isMissingNode() || outputType.getTextValue().equals("hdfs")) {
                isLicenseValid = this.isHDFSEnabled();
            } else if (outputType.getTextValue().equals("kafka")) {
                isLicenseValid = this.isKafkaEnabled();
            } else {
                gLogger.error((Object)("Unrecognized data.delivery.output.type: " + outputType));
            }
        }
        catch (JsonProcessingException e) {
            gLogger.error((Object)"Unable to retrieve information about data.delivery.output.type", (Throwable)e);
        }
        catch (IOException e) {
            gLogger.error((Object)"Unable to retrieve information about data.delivery.output.type", (Throwable)e);
        }
        return isLicenseValid;
    }

    private boolean isHDFSEnabled() {
        JsonNode result = this.getHadoopERPLicense().path("parameters").path("connector_hdfs");
        if (!result.isMissingNode() && result.getTextValue().equals("enabled")) {
            return true;
        }
        gLogger.error((Object)"License Error: Data delivery to HDFS not enabled");
        return false;
    }

    private boolean isKafkaEnabled() {
        JsonNode result = this.getHadoopERPLicense().path("parameters").path("connector_kafka");
        if (!result.isMissingNode() && result.getTextValue().equals("enabled")) {
            return true;
        }
        gLogger.error((Object)"License Error: Data delivery to Kakfa not enabled");
        return false;
    }
}

