/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;

public class CleanupInputFormat
extends InputFormat<Text, Text> {
    private static Logger gLogger = Logger.getLogger(CleanupInputFormat.class);

    public RecordReader<Text, Text> createRecordReader(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
        RecordReader<Text, Text> rr = new RecordReader<Text, Text>(){
            boolean done = false;

            public void close() throws IOException {
            }

            public Text getCurrentKey() throws IOException, InterruptedException {
                return null;
            }

            public Text getCurrentValue() throws IOException, InterruptedException {
                return null;
            }

            public float getProgress() throws IOException, InterruptedException {
                return this.done ? 1.0f : 0.0f;
            }

            public void initialize(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (!this.done) {
                    this.done = true;
                    return true;
                }
                return false;
            }
        };
        return rr;
    }

    protected JobClient getJobClient(JobConf conf) throws IOException {
        return new JobClient(conf);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        JobClient jc = this.getJobClient((JobConf)context.getConfiguration());
        ClusterStatus status = jc.getClusterStatus(true);
        Collection activeTTs = status.getActiveTrackerNames();
        for (String tt : activeTTs) {
            String serverName = tt.split(":")[0].split("_")[1];
            gLogger.info((Object)("Will run cleanup on: tracker_name=" + serverName));
            splits.add((InputSplit)new FileSplit(new Path(serverName), 0L, 0L, new String[]{serverName}));
        }
        return splits;
    }
}

