/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.parquet.converter;

import com.splunk.datasource.parquet.converter.JsonGroupConverter;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.Type;

public class JsonPrimitiveConverter
extends PrimitiveConverter {
    protected JsonGroupConverter parent;
    protected int index;

    private JsonPrimitiveConverter(JsonGroupConverter parent, int index) {
        this.parent = parent;
        this.index = index;
    }

    public static JsonPrimitiveConverter getInstance(Type type, JsonGroupConverter parent, int index) {
        switch (type.asPrimitiveType().getPrimitiveTypeName()) {
            case BINARY: {
                return new BinaryConverter(parent, index);
            }
        }
        return new JsonPrimitiveConverter(parent, index);
    }

    public void addBinary(Binary value) {
        this.parent.getCurrent().add(this.index, value.toStringUsingUTF8());
    }

    public void addBoolean(boolean value) {
        this.parent.getCurrent().add(this.index, value);
    }

    public void addDouble(double value) {
        this.parent.getCurrent().add(this.index, value);
    }

    public void addFloat(float value) {
        this.parent.getCurrent().add(this.index, value);
    }

    public void addInt(int value) {
        this.parent.getCurrent().add(this.index, value);
    }

    public void addLong(long value) {
        this.parent.getCurrent().add(this.index, value);
    }

    public static class BinaryConverter
    extends JsonPrimitiveConverter {
        private String[] dict;

        private BinaryConverter(JsonGroupConverter parent, int index) {
            super(parent, index);
        }

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new String[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this.dict[i] = dictionary.decodeToBinary(i).toStringUsingUTF8();
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.getCurrent().add(this.index, this.dict[dictionaryId]);
        }
    }
}

